/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class TunnelUtils {
    private static final boolean DEBUG = TunnelUtils.getDebug();
    public static final String TUNNEL_SEND = "/bea_wls_internal/iiop/ClientSend";
    public static final String TUNNEL_RECV = "/bea_wls_internal/iiop/ClientRecv";
    public static final String TUNNEL_LOGIN = "/bea_wls_internal/iiop/ClientLogin";
    public static final String TUNNEL_CLOSE = "/bea_wls_internal/iiop/ClientClose";
    public static final int MSG_HEADER_LENGTH = 12;
    public static final String TUNNEL_OK = "OK";
    public static final String TUNNEL_DEAD = "DEAD";
    public static final String TUNNEL_RETRY = "RETRY";
    public static final String TUNNEL_UNAVAIL = "UNAVAIL";
    public static final String RESULT_HEADER = "WL-Result";
    public static final String TYPE_HEADER = "WL-Type";
    public static final String VERSION_HEADER = "WL-Version";
    public static final String ID_HEADER = "Conn-Id";
    public static final String CONNECT_PARAM_HEADER_LEN = "HL";
    public static final String DEST_HEADER = "WL-Dest";
    public static final String CLUSTER_LIST_HEADER = "WL-List";
    public static final String SCHEME_HEADER = "WL-Scheme";
    public static final String PARAM_CONNECTION_ID = "connectionID";
    public static final String PARAM_RAND = "rand";
    public static final String TUNNEL_COOKIE_NAME = "JSESSIONID";
    public static final String CLIENT_ADDRESS = "WL-Client-Address";
    private static final SecureRandom rand = new SecureRandom();

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.http.tunnelUtils");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getNextRandom() {
        return rand.nextLong() & Long.MAX_VALUE;
    }

    public static void drainStream(InputStream i) throws IOException {
        if (i != null) {
            int r = 0;
            while ((r = i.read()) != -1) {
            }
            i.close();
        }
    }

    public static int toInt(int b) {
        return b & 0xFF;
    }

    public static void readConnectionParams(DataInputStream dIn) throws IOException {
        int headerLen = 12;
        String param = "";
        while ((param = dIn.readLine()) != null && param.length() != 0) {
            if (param.charAt(0) != CONNECT_PARAM_HEADER_LEN.charAt(0) || param.charAt(1) != CONNECT_PARAM_HEADER_LEN.charAt(1)) continue;
            try {
                headerLen = Integer.parseInt(param.substring(param.indexOf(58) + 1, param.length()));
            }
            catch (Exception nfe) {
                throw new ProtocolException("Invalid parameter: " + param);
            }
        }
    }

    public static Properties getProperties(String allProps) {
        if (allProps == null) {
            return null;
        }
        if (allProps.indexOf(61) == -1) {
            return null;
        }
        Properties returnProps = new Properties();
        if (allProps.indexOf(44) == -1) {
            TunnelUtils.setProperty(returnProps, allProps);
            return returnProps;
        }
        String[] splitProps = TunnelUtils.splitCompletely(allProps, ",");
        for (int i = 0; i < splitProps.length; ++i) {
            if (splitProps[i].indexOf(61) == -1) continue;
            TunnelUtils.setProperty(returnProps, splitProps[i]);
        }
        return returnProps;
    }

    public static void setCustomRequestProperties(Properties customHeaders, URLConnection conn) {
        if (customHeaders != null) {
            Enumeration<?> propertyNames = customHeaders.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String eachKey = (String)propertyNames.nextElement();
                String eachVal = customHeaders.getProperty(eachKey);
                if (DEBUG) {
                    TunnelUtils.p("setRequestProperty(" + eachKey + "," + eachVal + ")");
                }
                conn.setRequestProperty(eachKey, eachVal);
            }
        }
    }

    private static String[] splitCompletely(String string, String sep) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, sep);
        int i = stringTokenizer.countTokens();
        String[] st = new String[i];
        for (int j = 0; j < i; ++j) {
            st[j] = stringTokenizer.nextToken();
        }
        return st;
    }

    private static final void p(String msg) {
        System.out.println("<TunnelUtils>: " + msg);
    }

    private static final void setProperty(Properties props, String keyValue) {
        String key = keyValue.substring(0, keyValue.indexOf(61));
        String val = keyValue.substring(keyValue.indexOf(61) + 1);
        if (DEBUG) {
            TunnelUtils.p("CustomHeader(" + key + "," + val + ")");
        }
        props.setProperty(key, val);
    }

    public static final String getRequestArgs(String connectionID) {
        return "?connectionID=" + connectionID + "&rand=" + TunnelUtils.getNextRandom();
    }
}

