/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Arrays;

public final class MarshalledObject
implements Serializable {
    private byte[] objBytes = null;
    private int hash;

    public MarshalledObject(Object obj) throws IOException {
        if (obj == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshalledObjectOutputStream out = new MarshalledObjectOutputStream(baos);
        out.writeObject(obj);
        out.flush();
        this.objBytes = baos.toByteArray();
        int h = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            h = 31 * h + this.objBytes[i];
        }
        this.hash = h;
    }

    public Object readResolve() throws IOException, ClassNotFoundException, ObjectStreamException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.objBytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof MarshalledObject) {
            MarshalledObject other = (MarshalledObject)obj;
            if (this.objBytes == null || other.objBytes == null) {
                return this.objBytes == other.objBytes;
            }
            if (Arrays.equals(this.objBytes, other.objBytes)) {
                return true;
            }
        }
        return false;
    }

    private static class MarshalledObjectOutputStream
    extends ObjectOutputStream {
        MarshalledObjectOutputStream(OutputStream os) throws IOException {
            super(os);
            this.enableReplaceObject(true);
        }

        public Object replaceObject(Object o) throws IOException {
            if (o instanceof Remote) {
                throw new NotSerializableException("marshal remote object - " + o.getClass().getName());
            }
            return o;
        }
    }
}

