/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.Severities;
import weblogic.i18ntools.L10nLookup;

public class SeverityI18N
extends Severities {
    private static Localizer localizer1;
    private static Localizer localizer2;
    private static String lang1;
    private static String lang2;

    public static String severityNumToString(int n, Locale locale) {
        String string = locale.getLanguage();
        if ("en".equals(string)) {
            switch (n) {
                case 0: {
                    return "Off";
                }
                case 1: {
                    return "Emergency";
                }
                case 2: {
                    return "Alert";
                }
                case 4: {
                    return "Critical";
                }
                case 32: {
                    return "Notice";
                }
                case 8: {
                    return "Error";
                }
                case 16: {
                    return "Warning";
                }
                case 64: {
                    return "Info";
                }
                case 128: {
                    return "Debug";
                }
                case 256: {
                    return "Trace";
                }
                case 512: {
                    return "Dynamic";
                }
            }
            return "Unknown";
        }
        Localizer localizer = SeverityI18N.quicklyGetLocalizer(locale, string);
        return localizer.get(Severities.severityNumToString(n));
    }

    public static int severityStringToNum(String string, Locale locale) {
        String string2 = locale.getLanguage();
        if ("en".equals(string2)) {
            if (string.equalsIgnoreCase("Off")) {
                return 0;
            }
            if (string.equalsIgnoreCase("Emergency")) {
                return 1;
            }
            if (string.equalsIgnoreCase("Alert")) {
                return 2;
            }
            if (string.equalsIgnoreCase("Critical")) {
                return 4;
            }
            if (string.equalsIgnoreCase("Notice")) {
                return 32;
            }
            if (string.equalsIgnoreCase("Error")) {
                return 8;
            }
            if (string.equalsIgnoreCase("Warning")) {
                return 16;
            }
            if (string.equalsIgnoreCase("Info")) {
                return 64;
            }
            if (string.equalsIgnoreCase("Debug")) {
                return 128;
            }
            if (string.equalsIgnoreCase("Trace")) {
                return 256;
            }
            if (string.equalsIgnoreCase("Dynamic")) {
                return 512;
            }
            return 0;
        }
        Localizer localizer = SeverityI18N.quicklyGetLocalizer(locale, string2);
        if (string.equalsIgnoreCase(localizer.get("Off"))) {
            return 0;
        }
        if (string.equalsIgnoreCase(localizer.get("Emergency"))) {
            return 1;
        }
        if (string.equalsIgnoreCase(localizer.get("Alert"))) {
            return 2;
        }
        if (string.equalsIgnoreCase(localizer.get("Critical"))) {
            return 4;
        }
        if (string.equalsIgnoreCase(localizer.get("Notice"))) {
            return 32;
        }
        if (string.equalsIgnoreCase(localizer.get("Error"))) {
            return 8;
        }
        if (string.equalsIgnoreCase(localizer.get("Warning"))) {
            return 16;
        }
        if (string.equalsIgnoreCase(localizer.get("Info"))) {
            return 64;
        }
        if (string.equalsIgnoreCase(localizer.get("Debug"))) {
            return 128;
        }
        if (string.equalsIgnoreCase(localizer.get("Trace"))) {
            return 256;
        }
        if (string.equalsIgnoreCase(localizer.get("Dynamic"))) {
            return 512;
        }
        return 0;
    }

    private static Localizer quicklyGetLocalizer(Locale locale, String string) {
        if (lang1 != null && lang1.equals(string)) {
            return localizer1;
        }
        if (lang2 != null && lang2.equals(string)) {
            return localizer2;
        }
        Localizer localizer = L10nLookup.getLocalizer(locale, "weblogic.i18n.logging.LoggingTextLocalizer");
        if (lang1 == null) {
            lang1 = string;
            localizer1 = localizer;
        } else if (lang2 == null) {
            lang2 = string;
            localizer2 = localizer;
        } else {
            lang1 = string;
            localizer1 = localizer;
        }
        return localizer;
    }
}

