/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18ntools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.DefaultL10NClassLoaderFactory;
import weblogic.i18ntools.L10NClassLoaderFactory;

public final class L10nLookup
extends Properties {
    private static final long serialVersionUID = 508651606563984141L;
    private static boolean verbose = false;
    public static final String I18N_PROPERTIES = "i18n.properties";
    public static final String I18N_PROPERTIES_RESOURCE = "weblogic/i18n/i18n.properties";
    public static final String I18N_USER_PROPERTIES = "i18n_user.properties";
    public static final String I18N_USER_PROPERTIES_RESOURCE = "i18n_user.properties";
    public static final String I18N_EXT_PROPERTIES = "i18n_ext.properties";
    public static final String I18N_EXT_PROPERTIES_RESOURCE = "i18n_ext.properties";
    public static final int I18N_SERVER_MAX_MSG_ID = 500000;
    public static final int I18N_MAX_MSG_ID = 999999;
    public static final int I18N_MAX_ID_LENGTH = 6;
    public static final int EXTENDED_I18N_SERVER_MIN_MSG_ID = 1000000;
    public static final int EXTENDED_I18N_SERVER_MAX_MSG_ID = 9999999;
    private static final int CACHE_SIZE = 50;
    private static final String EMPTY_STRING = "";
    private boolean resourcesLoaded = false;
    private static String l10NClassLoaderFactoryClassName;
    private L10NClassLoaderFactory l10nClassLoaderFactory;
    private Vector subSystems;

    public static L10nLookup getL10n() {
        return L10nLookupInitializer.SINGLETON;
    }

    public static void setl10NClassLoaderFactoryClassName(String string) {
        l10NClassLoaderFactoryClassName = string;
    }

    public void load(String string) throws IOException {
        this.loadProps(string, false);
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(String string, boolean bl) throws IOException {
        Object object;
        Enumeration<URL> enumeration;
        InputStream inputStream = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (verbose) {
            new Exception().printStackTrace();
            L10nLookup.logger("Loading props from " + string);
        }
        if ((enumeration = Thread.currentThread().getContextClassLoader().getResources(string)) != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (verbose) {
                    L10nLookup.logger("Adding " + object);
                }
                hashSet.add(object);
            }
        }
        if (bl) {
            object = L10nLookup.class.getClassLoader();
            if (object == null) {
                object = ClassLoader.getSystemClassLoader();
            }
            if ((enumeration = ((ClassLoader)object).getResources(string)) != null) {
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (verbose) {
                        L10nLookup.logger("Adding " + uRL);
                    }
                    hashSet.add(uRL);
                }
            }
        }
        for (URL uRL : hashSet) {
            if (verbose) {
                L10nLookup.logger("Loading from " + uRL);
            }
            try {
                inputStream = uRL.openStream();
                super.load(inputStream);
            }
            catch (IOException iOException) {
                if (verbose) {
                    L10nLookup.logger("Skipping " + uRL);
                }
                if (!bl) continue;
                throw iOException;
            }
            finally {
                this.closeIS(inputStream);
            }
        }
    }

    public Object put(Object object, Object object2) {
        return super.put(object, ((String)object2).intern());
    }

    private void closeIS(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void logger(String string) {
        System.out.println(string);
    }

    private L10nLookup(boolean bl) {
        if (l10NClassLoaderFactoryClassName != null) {
            try {
                this.l10nClassLoaderFactory = (L10NClassLoaderFactory)Class.forName(l10NClassLoaderFactoryClassName).newInstance();
            }
            catch (Exception exception) {
                if (verbose) {
                    exception.printStackTrace();
                }
            }
        } else {
            this.l10nClassLoaderFactory = new DefaultL10NClassLoaderFactory();
        }
        if (bl) {
            this.ensureResourcesLoaded();
        }
    }

    public synchronized void ensureResourcesLoaded() {
        block5: {
            if (this.resourcesLoaded) {
                return;
            }
            try {
                this.loadProps(I18N_PROPERTIES_RESOURCE, true);
            }
            catch (IOException iOException) {
                L10nLookup.logger("Unable to access I18n properties file, weblogic/i18n/i18n.properties: " + iOException.toString());
            }
            try {
                this.loadProps("i18n_user.properties", true);
            }
            catch (IOException iOException) {
                if (!verbose) break block5;
                L10nLookup.logger("Unable to access I18n user properties file, i18n_user.properties: " + iOException.toString());
            }
        }
        this.resourcesLoaded = true;
    }

    public Localizer getLocalizer(String string, Locale locale) throws MissingResourceException {
        return this.getLocalizer(string, locale, false);
    }

    public Localizer getLocalizer(String string, Locale locale, boolean bl) throws MissingResourceException {
        String string2;
        this.ensureResourcesLoaded();
        String string3 = string;
        String string4 = null;
        if (string3.indexOf("-") != -1) {
            string3 = string3.substring(string.indexOf("-") + 1);
            string4 = string.substring(0, string.indexOf("-"));
        }
        if ((string2 = this.getProperty(string3)) == null) {
            try {
                if (Integer.valueOf(string3) < 500000) {
                    this.loadProps(I18N_PROPERTIES_RESOURCE, false);
                } else {
                    this.loadProps("i18n_user.properties", false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string2 = this.getProperty(string3);
            if (string2 == null) {
                throw new MissingResourceException("No localizer class found for message id.", "unknown", string3);
            }
        }
        if (verbose) {
            L10nLookup.logger("Localizer is " + string2);
        }
        for (int i = 0; i < string2.length(); ++i) {
            Localizer localizer;
            if (string2.charAt(i) != ':') continue;
            String string5 = string2.substring(++i);
            if (bl) {
                string5 = string5.concat("Detail");
            }
            if (verbose) {
                L10nLookup.logger("Getting bundle for " + string5);
            }
            if ((localizer = this.getLocalizerBundle(string5, locale, Thread.currentThread().getContextClassLoader())) == null) {
                throw new MissingResourceException("No localizer class found for message id.", "unknown", string3);
            }
            if (string4 != null && !string4.equals(localizer.getPrefix())) {
                throw new MissingResourceException("Prefix (" + string4 + ") in message id, " + string + ", does not match prefix in Localizer, " + localizer.getPrefix(), localizer.getClass().getName(), string3);
            }
            return localizer;
        }
        throw new MissingResourceException("Invalid I18n resource for " + string3 + ". Resource is " + string2, "weblogic.i18n.Localizer", string3);
    }

    public Localizer getLocalizer(int n, Locale locale) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getLocalizer(decimalFormat.format(n), locale, false);
    }

    public Localizer getLocalizer(String string) throws MissingResourceException {
        return this.getLocalizer(string, Locale.getDefault(), false);
    }

    public Localizer getLocalizer(int n) throws MissingResourceException {
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        return this.getLocalizer(decimalFormat.format(n), Locale.getDefault(), false);
    }

    public static Localizer getLocalizer(Locale locale, String string) throws MissingResourceException {
        return L10nLookup.getLocalizer(locale, string, null);
    }

    public static Localizer getLocalizer(Locale locale, String string, ClassLoader classLoader) throws MissingResourceException {
        Localizer localizer;
        Object object;
        if (string == null) {
            throw new NullPointerException("No class name provided");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (classLoader != null && (object = L10nLookupInitializer.SINGLETON.getLocalizerBundle(string, locale, classLoader)) != null) {
            return object;
        }
        object = L10nLookup.class.getClassLoader();
        if (object == null) {
            object = ClassLoader.getSystemClassLoader();
        }
        if (object == null) {
            if (verbose) {
                L10nLookup.logger("no system loader");
            }
            if ((object = Thread.currentThread().getContextClassLoader()) == null) {
                if (verbose) {
                    L10nLookup.logger("no context loader");
                }
            } else if (verbose) {
                L10nLookup.logger("Using context loader");
            }
        }
        if ((localizer = L10nLookupInitializer.SINGLETON.getLocalizerBundle(string, locale, (ClassLoader)object)) == null) {
            object = Thread.currentThread().getContextClassLoader();
            localizer = L10nLookupInitializer.SINGLETON.getLocalizerBundle(string, locale, (ClassLoader)object);
            if (localizer == null) {
                throw new MissingResourceException("Can't locate bundle for class '" + string + "'", string, EMPTY_STRING);
            }
        }
        return localizer;
    }

    public ClassLoader getL10NCustomClassLoader(Locale locale, ClassLoader classLoader) {
        if (this.l10nClassLoaderFactory == null || !this.l10nClassLoaderFactory.isValid()) {
            return null;
        }
        return this.l10nClassLoaderFactory.getClassLoader(locale, classLoader);
    }

    private Localizer getLocalizerBundle(String string, Locale locale, ClassLoader classLoader) {
        ResourceBundle resourceBundle;
        Locale locale2;
        Localizer localizer = this.getLocalizerBundle_inner(string, locale, classLoader);
        if (localizer != null && !L10nLookup.isParentLocale(locale2 = (resourceBundle = localizer.getBundle()).getLocale(), locale)) {
            locale = new Locale(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
            localizer = this.getLocalizerBundle_inner(string, locale, classLoader);
        }
        return localizer;
    }

    private static boolean isParentLocale(Locale locale, Locale locale2) {
        String string = locale.getLanguage();
        String string2 = locale2.getLanguage();
        if (EMPTY_STRING.equals(string)) {
            return true;
        }
        if (!string.equals(string2)) {
            return false;
        }
        String string3 = locale.getCountry();
        String string4 = locale2.getCountry();
        if (EMPTY_STRING.equals(string3)) {
            return true;
        }
        if (!string3.equals(string4)) {
            return false;
        }
        String string5 = locale.getVariant();
        String string6 = locale2.getVariant();
        if (EMPTY_STRING.equals(string5)) {
            return true;
        }
        return string5.equals(string6);
    }

    private Localizer getLocalizerBundle_inner(String string, Locale locale, ClassLoader classLoader) {
        Object object;
        try {
            object = this.getL10NCustomClassLoader(locale, classLoader);
            if (object != null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, (ClassLoader)object);
                return new Localizer(resourceBundle);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object = ResourceBundle.getBundle(string, locale, classLoader);
            return new Localizer((ResourceBundle)object);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public Vector getSubSystems() {
        this.ensureResourcesLoaded();
        if (this.subSystems == null) {
            this.subSystems = new Vector();
            Enumeration<Object> enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String string2 = string.substring(0, n = string.indexOf(58));
                if (this.subSystems.contains(string2)) continue;
                this.subSystems.add(string2);
            }
        }
        return this.subSystems;
    }

    static class LocalizerKey {
        String s;
        Locale l;
        ClassLoader cl;
        int hash;

        LocalizerKey(String string, Locale locale, ClassLoader classLoader) {
            this.s = string;
            this.l = locale;
            this.cl = classLoader;
            this.hash = 0;
        }

        public int hashCode() {
            if (this.hash == 0) {
                if (this.s != null) {
                    this.hash = this.s.hashCode();
                }
                if (this.l != null) {
                    this.hash |= this.l.hashCode();
                }
                if (this.cl != null) {
                    this.hash |= this.cl.hashCode();
                }
            }
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LocalizerKey) {
                LocalizerKey localizerKey = (LocalizerKey)object;
                if (this.s.equals(localizerKey.s) && this.l.equals(localizerKey.l) && (this.cl == null ? localizerKey.cl == null : this.cl.equals(localizerKey.cl))) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class L10nLookupInitializer {
        private static final L10nLookup SINGLETON = new L10nLookup(false);

        private L10nLookupInitializer() {
        }
    }
}

