/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.EmptyStackException;
import weblogic.kernel.ResettableThreadLocal;
import weblogic.utils.collections.Stack;

public final class ResettableThreadLocalStack
extends ResettableThreadLocal {
    public ResettableThreadLocalStack() {
    }

    public ResettableThreadLocalStack(boolean bl) {
        super(bl);
    }

    public Object get() {
        return this.peek();
    }

    public void set(Object object) {
        Stack stack = (Stack)super.get();
        stack.clear();
        stack.push(object);
    }

    public Object peek() {
        Stack stack = (Stack)super.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public void push(Object object) {
        ((Stack)super.get()).push(object);
    }

    public Object pop() {
        try {
            return ((Stack)super.get()).pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new AssertionError((Object)emptyStackException);
        }
    }

    public int getSize() {
        return ((Stack)super.get()).size();
    }

    public Object popAndPeek() {
        try {
            Stack stack = (Stack)super.get();
            stack.pop();
            if (stack.isEmpty()) {
                return null;
            }
            return stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    protected Object initialValue() {
        return new Stack();
    }

    protected Object resetValue(Object object) {
        ((Stack)object).clear();
        return object;
    }

    protected Object childValue(Object object) {
        Stack stack = (Stack)object;
        if (!stack.isEmpty()) {
            Stack stack2 = (Stack)this.initialValue();
            stack2.push(stack.peek());
            return stack2;
        }
        return this.initialValue();
    }
}

