/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.EmptyStackException;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.utils.collections.Stack;

public final class ThreadLocalStack {
    private final AuditableThreadLocal tlstack;

    public ThreadLocalStack() {
        this.tlstack = AuditableThreadLocalFactory.createThreadLocal(new StackInitialValue());
    }

    public ThreadLocalStack(boolean bl) {
        this.tlstack = AuditableThreadLocalFactory.createThreadLocal(new StackInitialValue(bl));
    }

    public int getSize() {
        return ((Stack)this.tlstack.get()).size();
    }

    public Object get() {
        return this.peek();
    }

    public Object get(AuditableThread auditableThread) {
        return this.peek(auditableThread);
    }

    public void set(Object object) {
        Stack stack = (Stack)this.tlstack.get();
        stack.clear();
        stack.push(object);
    }

    public Object peek() {
        Stack stack = (Stack)this.tlstack.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public Object peek(AuditableThread auditableThread) {
        Stack stack = (Stack)this.tlstack.get(auditableThread);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public void push(Object object) {
        ((Stack)this.tlstack.get()).push(object);
    }

    public Object pop() {
        try {
            return ((Stack)this.tlstack.get()).pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new AssertionError((Object)emptyStackException);
        }
    }

    public Object popAndPeek() {
        try {
            Stack stack = (Stack)this.tlstack.get();
            stack.pop();
            if (stack.isEmpty()) {
                return null;
            }
            return stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private static final class StackInitialValue
    extends ThreadLocalInitialValue {
        private StackInitialValue() {
            this(false);
        }

        private StackInitialValue(boolean bl) {
            super(bl);
        }

        protected Object initialValue() {
            return new Stack();
        }

        protected Object resetValue(Object object) {
            ((Stack)object).clear();
            return object;
        }

        protected Object childValue(Object object) {
            Stack stack = (Stack)object;
            if (!stack.isEmpty()) {
                Stack stack2 = (Stack)this.initialValue();
                stack2.push(stack.peek());
                return stack2;
            }
            return this.initialValue();
        }
    }
}

