/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.extensions.DisconnectEventImpl;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorException;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.HeartbeatHelper;

public abstract class AbstractDisconnectMonitorDelegate
implements DisconnectMonitorProvider {
    private static final boolean DEBUG = AbstractDisconnectMonitorDelegate.getDebug();
    private final HashMap listenerSet = new HashMap();
    private final HashMap remote2Helper = new HashMap();
    private static ThreadGroup hbmThreadGroup = null;
    private static boolean hasThreadGroupAccess = true;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.dgc");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final void p(String string) {
        System.out.println("<AbstractDisconnectMonitorDelegate>: " + string);
    }

    public AbstractDisconnectMonitorDelegate() {
        DisconnectMonitorListImpl.getDisconnectMonitorList().addDisconnectMonitor(this);
    }

    protected abstract HeartbeatHelper getHeartbeatHelper(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        HeartbeatHelper heartbeatHelper = this.getHeartbeatHelper(remote);
        if (heartbeatHelper == null) {
            return false;
        }
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.p("addDisconnectMonitorListener...");
        }
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            this.remote2Helper.put(disconnectListener, heartbeatHelper);
            HelperEntry helperEntry = (HelperEntry)this.listenerSet.get(heartbeatHelper);
            if (helperEntry == null) {
                helperEntry = new HelperEntry(this.startPinger(heartbeatHelper));
                this.listenerSet.put(heartbeatHelper, helperEntry);
            }
            helperEntry.listeners.add(disconnectListener);
        }
        return true;
    }

    private Timer startPinger(HeartbeatHelper heartbeatHelper) {
        Timer timer = new Timer(this, heartbeatHelper);
        Thread thread = AbstractDisconnectMonitorDelegate.createThread(timer, "Request Timer Thread");
        thread.setDaemon(true);
        Pinger pinger = new Pinger(this, heartbeatHelper, timer);
        Thread thread2 = AbstractDisconnectMonitorDelegate.createThread(pinger, "Heartbeat Request Thread");
        thread2.setDaemon(true);
        thread2.start();
        thread.start();
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.p("timer/pinger started");
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDisconnectListener(Remote remote, DisconnectListener disconnectListener) {
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            HeartbeatHelper heartbeatHelper = (HeartbeatHelper)this.remote2Helper.remove(disconnectListener);
            if (heartbeatHelper == null) {
                return false;
            }
            HelperEntry helperEntry = (HelperEntry)this.listenerSet.get(heartbeatHelper);
            if (helperEntry != null) {
                helperEntry.listeners.remove(disconnectListener);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverDisconnectEvent(Throwable throwable, Object object) {
        HelperEntry helperEntry = null;
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.p("deliver [" + throwable + "] to listeners");
        }
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            helperEntry = (HelperEntry)this.listenerSet.remove(object);
            if (helperEntry == null) {
                return;
            }
        }
        for (DisconnectListener disconnectListener : (HashSet)helperEntry.listeners.clone()) {
            disconnectListener.onDisconnect(new DisconnectEventImpl(throwable));
        }
    }

    private static Thread createThread(Runnable runnable, String string) {
        if (!KernelStatus.isApplet()) {
            return new Thread(runnable, string);
        }
        AbstractDisconnectMonitorDelegate.initializeHBMThreadGroup();
        if (hbmThreadGroup != null) {
            return new Thread(hbmThreadGroup, runnable, string);
        }
        return new Thread(runnable, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeHBMThreadGroup() {
        if (!hasThreadGroupAccess || hbmThreadGroup != null) return;
        Class<AbstractDisconnectMonitorDelegate> clazz = AbstractDisconnectMonitorDelegate.class;
        synchronized (AbstractDisconnectMonitorDelegate.class) {
            if (hbmThreadGroup != null) return;
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                while (true) {
                    if (threadGroup.getName().equals("main") && threadGroup.getParent().getName().equals("system")) {
                        ThreadGroup threadGroup2 = threadGroup;
                        hbmThreadGroup = new ThreadGroup(threadGroup2, "HeartbeatMonitor ThreadGroup"){

                            public String toString() {
                                return "HBMThreadGroup(name=" + this.getName() + ", parent=" + this.getParent() + ")";
                            }
                        };
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    threadGroup = threadGroup.getParent();
                }
            }
            catch (SecurityException securityException) {
                System.out.println(" +++ <Warining> Don't have permissions to access ThreadGroup.  We strongly recommend to use signed applet.");
                System.out.println(" +++ <Warining> Proceed further without creating ThreadGroup.");
                hasThreadGroupAccess = false;
            }
            return;
        }
    }

    protected static class Pinger
    implements Runnable {
        protected AbstractDisconnectMonitorDelegate delegate;
        protected HeartbeatHelper helper;
        protected Timer timer;

        protected Pinger(AbstractDisconnectMonitorDelegate abstractDisconnectMonitorDelegate, HeartbeatHelper heartbeatHelper, Timer timer) {
            this.delegate = abstractDisconnectMonitorDelegate;
            this.helper = heartbeatHelper;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.p("pinger called");
                    }
                    this.helper.ping();
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.p("pinger renews lease");
                    }
                    this.timer.renewLease();
                    continue;
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.p("pinger caught: [" + exception + "]");
                        exception.printStackTrace();
                    }
                    this.delegate.deliverDisconnectEvent(exception, this.helper);
                    return;
                }
                finally {
                    HashMap hashMap = this.delegate.listenerSet;
                    synchronized (hashMap) {
                        HelperEntry helperEntry = (HelperEntry)this.delegate.listenerSet.get(this.helper);
                        if (helperEntry == null || helperEntry.listeners.isEmpty()) {
                            this.timer.cancel();
                            this.delegate.listenerSet.remove(this.helper);
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    protected static class Timer
    implements Runnable {
        protected AbstractDisconnectMonitorDelegate delegate;
        protected Object key;
        protected int lease = 1;
        protected volatile boolean cancel = false;

        protected Timer(AbstractDisconnectMonitorDelegate abstractDisconnectMonitorDelegate, Object object) {
            this.delegate = abstractDisconnectMonitorDelegate;
            this.key = object;
        }

        protected void renewLease() {
            ++this.lease;
        }

        protected synchronized void cancel() {
            this.cancel = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            int n = this.lease;
            try {
                long l2;
                while (true) {
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.p("timer waits...");
                    }
                    try {
                        Timer timer = this;
                        synchronized (timer) {
                            this.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.cancel) {
                        if (DEBUG) {
                            AbstractDisconnectMonitorDelegate.p("timer canceled");
                        }
                        return;
                    }
                    if (n < this.lease) {
                        n = this.lease;
                        l = System.currentTimeMillis();
                        continue;
                    }
                    l2 = System.currentTimeMillis() - l;
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.p("timer fires after " + l2 + "ms, oldLease=" + n + ", lease=" + this.lease);
                    }
                    if (l2 >= 240000L) break;
                }
                this.delegate.deliverDisconnectEvent(new DisconnectMonitorException("DisconnectMonitor timed out after " + l2 / 1000L + "s."), this.key);
                return;
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    throwable.printStackTrace();
                }
                this.delegate.deliverDisconnectEvent(throwable, this.key);
                return;
            }
        }
    }

    private static class HelperEntry {
        private Timer timer;
        private HashSet listeners = new HashSet();

        private HelperEntry(Timer timer) {
            this.timer = timer;
        }
    }
}

