/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.util.EmptyStackException;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.ThreadLocalStack;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectStack;
import weblogic.security.subject.SubjectStackDelegate;

public class DelegatingSubjectStack
implements SubjectStack {
    private static final ThreadLocalStack threadSubject = new ThreadLocalStack(true);
    private SubjectStackDelegate delegate;

    public AbstractSubject getCurrentSubject(AbstractSubject abstractSubject) {
        SubjectManager.getSubjectManager().checkKernelIdentity(abstractSubject);
        AbstractSubject abstractSubject2 = (AbstractSubject)threadSubject.get();
        if (this.delegate != null) {
            abstractSubject2 = this.delegate.getCurrentSubject(abstractSubject, abstractSubject2);
        }
        return abstractSubject2;
    }

    public AbstractSubject getCurrentSubject(AbstractSubject abstractSubject, AuditableThread auditableThread) {
        SubjectManager.getSubjectManager().checkKernelIdentity(abstractSubject);
        AbstractSubject abstractSubject2 = (AbstractSubject)threadSubject.get(auditableThread);
        if (this.delegate != null) {
            abstractSubject2 = this.delegate.getCurrentSubject(abstractSubject, abstractSubject2);
        }
        return abstractSubject2;
    }

    public void pushSubject(AbstractSubject abstractSubject, AbstractSubject abstractSubject2) {
        if (abstractSubject2 == null) {
            throw new IllegalArgumentException("Illegal null Subject passed as a parameter.");
        }
        SubjectManager.getSubjectManager().checkKernelIdentity(abstractSubject);
        if (this.delegate != null) {
            this.delegate.pushSubject(abstractSubject, abstractSubject2);
        }
        threadSubject.push(abstractSubject2);
    }

    public void popSubject(AbstractSubject abstractSubject) {
        SubjectManager.getSubjectManager().checkKernelIdentity(abstractSubject);
        Object object = null;
        try {
            object = threadSubject.popAndPeek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (this.delegate != null) {
            this.delegate.popSubject(abstractSubject, (AbstractSubject)object);
        }
    }

    public int getSize() {
        return threadSubject.getSize();
    }

    public void addDelegate(SubjectStackDelegate subjectStackDelegate) {
        if (this.delegate != null) {
            this.delegate.addDelegate(subjectStackDelegate);
        } else {
            this.delegate = subjectStackDelegate;
        }
    }
}

