/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.kernel.AuditableThread;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectProxy;
import weblogic.security.subject.SubjectStack;

public abstract class SubjectManager
implements SubjectStack {
    public static final String KERNEL_USERNAME = "<WLS Kernel>";
    public static final String ANONYMOUS_USERNAME = SubjectManager.initAnonymousUsername();
    private static final String DEFAULT_ANONYMOUS_USERNAME = "<anonymous>";
    private static final GetKernelIdentityAction THE_ONE = new GetKernelIdentityAction();
    protected static final Permission KERNEL_PERM = new RuntimePermission("weblogic.kernelPermission");
    private static SubjectManager singleton;

    public static final PrivilegedAction getKernelIdentityAction() {
        return THE_ONE;
    }

    public static final Permission getKernelPermission() {
        return KERNEL_PERM;
    }

    public void checkKernelPermission() {
        AccessController.checkPermission(KERNEL_PERM);
    }

    public boolean isKernelIdentity(AbstractSubject abstractSubject) {
        return abstractSubject == this.getCachedKernelIdentity();
    }

    private AbstractSubject getCachedKernelIdentity() {
        return KernelIdentityMaker.KERNEL_ID;
    }

    public void checkKernelIdentity(AbstractSubject abstractSubject) {
        if (!this.isKernelIdentity(abstractSubject)) {
            throw new SecurityException("Subject '" + (abstractSubject == null ? "<null>" : abstractSubject.toString()) + "' is not the kernel identity");
        }
    }

    protected abstract AbstractSubject getKernelIdentity();

    public static final SubjectManager getSubjectManager() {
        if (singleton == null) {
            return new SubjectManager(){

                protected AbstractSubject getKernelIdentity() {
                    return null;
                }

                public AbstractSubject getCurrentSubject(AbstractSubject abstractSubject) {
                    throw new SecurityException("SubjectManager not installed");
                }

                public AbstractSubject getCurrentSubject(AbstractSubject abstractSubject, AuditableThread auditableThread) {
                    throw new SecurityException("SubjectManager not installed");
                }

                public void pushSubject(AbstractSubject abstractSubject, AbstractSubject abstractSubject2) {
                    throw new SecurityException("SubjectManager not installed");
                }

                public void popSubject(AbstractSubject abstractSubject) {
                    throw new SecurityException("SubjectManager not installed");
                }

                protected AbstractSubject createAbstractSubject(Subject subject) {
                    throw new SecurityException("SubjectManager not installed");
                }

                public int getSize() {
                    throw new SecurityException("SubjectManager not installed");
                }

                public AbstractSubject getAnonymousSubject() {
                    throw new SecurityException("SubjectManager not installed");
                }
            };
        }
        return singleton;
    }

    protected static final boolean subjectManagerInstalled() {
        return singleton != null;
    }

    public static final void setSubjectManager(SubjectManager subjectManager) {
        if (singleton != null) {
            AccessController.checkPermission(KERNEL_PERM);
        }
        singleton = subjectManager;
    }

    public static final PrivilegedAction setSubjectManagerAction(SubjectManager subjectManager) {
        return new SetSubjectManagerAction(subjectManager);
    }

    public Object runAs(Subject subject, PrivilegedAction privilegedAction) {
        if (subject == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(subject).doAs(this.getCachedKernelIdentity(), privilegedAction);
    }

    public Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (subject == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(subject).doAs(this.getCachedKernelIdentity(), privilegedExceptionAction);
    }

    protected abstract AbstractSubject createAbstractSubject(Subject var1);

    private final AbstractSubject getAbstractSubject(final Subject subject) {
        return (AbstractSubject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object object : subject.getPrivateCredentials()) {
                    if (!(object instanceof AbstractSubject)) continue;
                    return object;
                }
                return SubjectManager.this.createAbstractSubject(subject);
            }
        });
    }

    public String getSubjectName(AbstractSubject abstractSubject) {
        if (abstractSubject == null) {
            throw new AssertionError((Object)"subject is null");
        }
        if (this.isKernelIdentity(abstractSubject)) {
            return KERNEL_USERNAME;
        }
        Principal principal = SubjectManager.getOnePrincipal(abstractSubject, SubjectProxy.class);
        if (principal == null) {
            return ANONYMOUS_USERNAME;
        }
        return principal.getName();
    }

    public static Principal getOnePrincipal(AbstractSubject abstractSubject, Class clazz) {
        return SubjectManager.getOnePrincipalClass(abstractSubject.getPrincipals(), clazz);
    }

    public static Principal getOnePrincipalClass(Set set, Class clazz) {
        for (Principal principal : set) {
            if (!clazz.isAssignableFrom(principal.getClass())) continue;
            return principal;
        }
        return null;
    }

    private static String initAnonymousUsername() {
        try {
            return System.getProperty("weblogic.security.anonymousUserName", DEFAULT_ANONYMOUS_USERNAME);
        }
        catch (Exception exception) {
            return DEFAULT_ANONYMOUS_USERNAME;
        }
    }

    public abstract AbstractSubject getAnonymousSubject();

    private static final class SetSubjectManagerAction
    implements PrivilegedAction {
        private final SubjectManager manager;

        private SetSubjectManagerAction(SubjectManager subjectManager) {
            this.manager = subjectManager;
        }

        public final Object run() {
            SubjectManager.setSubjectManager(this.manager);
            return null;
        }
    }

    private static final class GetKernelIdentityAction
    implements PrivilegedAction {
        private GetKernelIdentityAction() {
        }

        public final Object run() {
            return SubjectManager.getSubjectManager().getKernelIdentity();
        }
    }

    private static class KernelIdentityMaker {
        private static AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());

        private KernelIdentityMaker() {
        }
    }
}

