/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class SubjectProxy
implements AbstractSubject {
    public static SubjectProxy ANON = new SubjectProxy(new Subject());
    private final Subject subject;

    public SubjectProxy(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Set getPrincipals() {
        return this.subject.getPrincipals();
    }

    public Set getPublicCredentials() {
        return this.subject.getPublicCredentials();
    }

    public Set getPrivateCredentials(AbstractSubject abstractSubject) {
        return this.subject.getPrivateCredentials();
    }

    public Set getPrincipals(Class clazz) {
        return this.subject.getPrincipals(clazz);
    }

    public Set getPublicCredentials(Class clazz) {
        return this.subject.getPublicCredentials(clazz);
    }

    public Set getPrivateCredentials(AbstractSubject abstractSubject, Class clazz) {
        return this.subject.getPrivateCredentials(clazz);
    }

    public boolean isReadOnly() {
        return this.subject.isReadOnly();
    }

    public void setReadOnly(AbstractSubject abstractSubject) {
        this.subject.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAs(AbstractSubject abstractSubject, PrivilegedAction privilegedAction) {
        if (privilegedAction == null) {
            throw new SecurityException("Null PrivilegedAction");
        }
        SubjectManager.getSubjectManager().pushSubject(abstractSubject, this);
        Object var3_3 = null;
        try {
            var3_3 = privilegedAction.run();
        }
        finally {
            SubjectManager.getSubjectManager().popSubject(abstractSubject);
        }
        return var3_3;
    }

    public Object doAs(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (privilegedExceptionAction == null) {
            throw new SecurityException("Null PrivilegedActionException");
        }
        SubjectManager.getSubjectManager().pushSubject(abstractSubject, this);
        Object var3_3 = null;
        try {
            var3_3 = privilegedExceptionAction.run();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
        finally {
            SubjectManager.getSubjectManager().popSubject(abstractSubject);
        }
        return var3_3;
    }

    public String toString() {
        return "SubjectProxy[" + System.identityHashCode(this.subject) + "]";
    }
}

