/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction;

import java.util.EmptyStackException;
import java.util.Stack;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.ClientTransactionManager;

public abstract class TransactionHelper {
    private static TransactionHelper singleton;
    private static Stack txStack;

    public static TransactionHelper getTransactionHelper() {
        if (singleton == null) {
            try {
                singleton = (TransactionHelper)Class.forName("weblogic.transaction.internal.CETransactionHelperImpl").newInstance();
            }
            catch (Exception exception) {
                try {
                    singleton = (TransactionHelper)Class.forName("weblogic.transaction.internal.TransactionHelperImpl").newInstance();
                }
                catch (Exception exception2) {
                    throw new IllegalArgumentException(exception2.toString());
                }
            }
        }
        return singleton;
    }

    public static void setTransactionHelper(TransactionHelper transactionHelper) {
        singleton = transactionHelper;
    }

    public static void pushTransactionHelper(TransactionHelper transactionHelper) {
        if (!KernelStatus.isServer()) {
            txStack.push(transactionHelper);
            singleton = transactionHelper;
        }
    }

    public static TransactionHelper popTransactionHelper() throws EmptyStackException {
        if (!KernelStatus.isServer()) {
            try {
                singleton = (TransactionHelper)txStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return singleton;
    }

    public abstract UserTransaction getUserTransaction();

    public abstract ClientTransactionManager getTransactionManager();

    public Transaction getTransaction() {
        try {
            ClientTransactionManager clientTransactionManager = this.getTransactionManager();
            if (clientTransactionManager != null) {
                return clientTransactionManager.getTransaction();
            }
        }
        catch (SystemException systemException) {
            systemException.printStackTrace();
        }
        return null;
    }

    static {
        txStack = new Stack();
    }
}

