/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea.spi;

import java.io.IOException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextEntry;

public final class WorkContextEntryImpl
implements WorkContextEntry {
    public static final String[] PROP_NAMES = new String[]{"LOCAL", "WORK", "RMI", "TRANSACTION", "JMS_QUEUE", "JMS_TOPIC", "SOAP", "MIME_HEADER", "ONEWAY"};
    private String name;
    private int propagationMode;
    private WorkContext context;
    private boolean originator;

    private WorkContextEntryImpl() {
    }

    public WorkContextEntryImpl(String string, WorkContext workContext, int n) {
        this.name = string;
        this.context = workContext;
        this.propagationMode = n;
        this.originator = true;
    }

    private WorkContextEntryImpl(String string, WorkContextInput workContextInput) throws IOException, ClassNotFoundException {
        this.name = string;
        this.propagationMode = workContextInput.readInt();
        this.context = workContextInput.readContext();
    }

    public WorkContext getWorkContext() {
        return this.context;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof WorkContextEntry) {
            return ((WorkContextEntry)object).getName().equals(this.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getPropagationMode() {
        return this.propagationMode;
    }

    public boolean isOriginator() {
        return this.originator;
    }

    public void write(WorkContextOutput workContextOutput) throws IOException {
        if (this == NULL_CONTEXT) {
            workContextOutput.writeUTF("");
        } else {
            workContextOutput.writeUTF(this.name);
            workContextOutput.writeInt(this.propagationMode);
            workContextOutput.writeContext(this.context);
        }
    }

    public static WorkContextEntry readEntry(WorkContextInput workContextInput) throws IOException, ClassNotFoundException {
        String string = workContextInput.readUTF();
        if (string.length() == 0) {
            return NULL_CONTEXT;
        }
        return new WorkContextEntryImpl(string, workContextInput);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append(", ");
        int n = this.propagationMode;
        for (int i = 0; i < 9; ++i) {
            if ((n >>>= 1) != 1) continue;
            stringBuffer.append(" | ").append(PROP_NAMES[i]);
        }
        return stringBuffer.toString();
    }
}

