/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common;

import java.util.LinkedList;
import weblogic.common.CompletionListener;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class CompletionRequest
implements Runnable {
    private Object result;
    private int numWaiters = 0;
    private LinkedList listeners = new LinkedList();
    private boolean running;
    private boolean runListenersInSetResult;
    private WorkManager workManager;

    public CompletionRequest() {
        this.result = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object object) {
        CompletionRequest completionRequest = this;
        synchronized (completionRequest) {
            if (this.hasResult()) {
                throw new IllegalStateException("Result has already been set");
            }
            this.result = object;
            if (this.numWaiters > 0) {
                this.notifyAll();
            }
            if (this.listeners.isEmpty()) {
                return;
            }
            this.running = true;
        }
        if (this.runListenersInSetResult) {
            this.run();
        } else {
            this.workManager.schedule(this);
        }
    }

    public synchronized boolean runListenersInSetResult(boolean bl) {
        boolean bl2 = this.runListenersInSetResult;
        this.runListenersInSetResult = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getResult() throws Throwable {
        while (!this.hasResult()) {
            try {
                ++this.numWaiters;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                --this.numWaiters;
            }
        }
        if (this.result instanceof Throwable) {
            throw (Throwable)this.result;
        }
        return this.result;
    }

    public void addListener(CompletionListener completionListener) {
        this.addListener(completionListener, WorkManagerFactory.getInstance().getSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CompletionListener completionListener, WorkManager workManager) {
        if (completionListener == null || workManager == null) {
            throw new IllegalArgumentException();
        }
        CompletionRequest completionRequest = this;
        synchronized (completionRequest) {
            this.workManager = workManager;
            this.listeners.addLast(completionListener);
            if (!this.hasResult() || this.running) {
                return;
            }
            this.running = true;
        }
        if (this.runListenersInSetResult) {
            this.run();
        } else {
            workManager.schedule(this);
        }
    }

    public void addFirstListener(CompletionListener completionListener) {
        this.addFirstListener(completionListener, WorkManagerFactory.getInstance().getSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirstListener(CompletionListener completionListener, WorkManager workManager) {
        if (completionListener == null || workManager == null) {
            throw new IllegalArgumentException();
        }
        CompletionRequest completionRequest = this;
        synchronized (completionRequest) {
            this.workManager = workManager;
            this.listeners.addFirst(completionListener);
            if (!this.hasResult() || this.running) {
                return;
            }
            this.running = true;
        }
        if (this.runListenersInSetResult) {
            this.run();
        } else {
            workManager.schedule(this);
        }
    }

    public synchronized boolean removeListener(CompletionListener completionListener) {
        return this.listeners.remove(completionListener);
    }

    public synchronized void reset() {
        this.runListenersInSetResult = false;
        if (this.running || this.numWaiters > 0 || this.listeners.size() != 0) {
            throw new IllegalStateException();
        }
        this.result = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                boolean bl;
                CompletionListener completionListener;
                CompletionRequest completionRequest = this;
                synchronized (completionRequest) {
                    if (this.listeners.isEmpty()) {
                        this.running = false;
                        break;
                    }
                    completionListener = (CompletionListener)this.listeners.removeFirst();
                    bl = this.result instanceof Throwable;
                }
                if (bl) {
                    completionListener.onException(this, (Throwable)this.result);
                    continue;
                }
                completionListener.onCompletion(this, this.result);
            }
        }
        finally {
            CompletionRequest completionRequest = this;
            synchronized (completionRequest) {
                this.running = false;
            }
        }
    }

    public boolean hasResult() {
        return this.result != this;
    }
}

