/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.GatheredArgument;
import weblogic.diagnostics.instrumentation.InstrumentationSupportBase;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.LocalHolder;
import weblogic.diagnostics.instrumentation.MonitorLocalHolder;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstrumentationSupport
extends InstrumentationSupportBase {
    private static final String SUPPORT_CLASSNAME = "weblogic.diagnostics.instrumentation.rtsupport.InstrumentationSupportImpl";
    public static final String SENSITIVE_VALUE = "*****";
    private static InstrumentationSupportInterface support = InstrumentationSupport.getInstrumentationSupport();

    private static InstrumentationSupportInterface getInstrumentationSupport() {
        InstrumentationSupportInterface instrumentationSupportInterface = InstrumentationSupport.getInstrumentationSupportOverride();
        if (instrumentationSupportInterface == null) {
            try {
                instrumentationSupportInterface = (InstrumentationSupportInterface)Class.forName(SUPPORT_CLASSNAME).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return instrumentationSupportInterface;
    }

    private static InstrumentationSupportInterface getInstrumentationSupportOverride() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = InstrumentationSupport.class.getClassLoader().getResourceAsStream("weblogic-diagnostics.properties");
            properties.load(inputStream);
            String string = properties.getProperty("weblogic.diagnostics.instrumentation.rt.SupportOverrideClassName");
            if (string == null) {
                return null;
            }
            InstrumentationSupportInterface instrumentationSupportInterface = null;
            instrumentationSupportInterface = (InstrumentationSupportInterface)Class.forName(string).newInstance();
            return instrumentationSupportInterface;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static DiagnosticMonitor getMonitor(Class clazz, String string) {
        if (support != null) {
            return support.getMonitor(clazz, string);
        }
        return new PlaceholderDelegatingMonitor(string);
    }

    public static JoinPoint createJoinPoint(Class clazz, String string, String string2, String string3, String string4, int n, Map<String, PointcutHandlingInfo> map, boolean bl) {
        if (support != null) {
            return support.createJoinPoint(clazz, string, string2, string3, string4, n, map, bl);
        }
        return new PlaceholderJoinPoint(clazz, string, string2, string3, string4, n, map, bl);
    }

    public static void createDynamicJoinPoint(LocalHolder localHolder) {
        MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
        monitorLocalHolder.djp = support != null ? support.createDynamicJoinPoint(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp, monitorLocalHolder.captureArgs ? localHolder.args : null, localHolder.ret) : new PlaceholderDynamicJoinPoint(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp);
    }

    public static DynamicJoinPoint createDynamicJoinPoint(JoinPoint joinPoint, Object[] objectArray, Object object) {
        if (support != null) {
            return support.createDynamicJoinPoint(joinPoint, objectArray, object);
        }
        return new PlaceholderDynamicJoinPoint(joinPoint);
    }

    public static void process(LocalHolder localHolder) {
        if (support != null) {
            MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
            support.process(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp, monitorLocalHolder.monitor, monitorLocalHolder.actions);
        }
    }

    public static void process(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray) {
        if (support != null) {
            support.process(joinPoint, diagnosticMonitor, diagnosticActionArray);
        }
    }

    public static void process(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, Throwable throwable) {
        if (support != null) {
            support.process(joinPoint, diagnosticMonitor, diagnosticActionArray);
        }
    }

    public static void preProcess(LocalHolder localHolder) {
        InstrumentationSupport.applyActionStates(localHolder);
        if (support != null) {
            MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
            support.preProcess(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp, monitorLocalHolder.monitor, monitorLocalHolder.actions, monitorLocalHolder.states);
        }
    }

    public static void preProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        if (support != null) {
            support.preProcess(joinPoint, diagnosticMonitor, diagnosticActionArray, diagnosticActionStateArray);
        }
    }

    public static void postProcess(LocalHolder localHolder) {
        if (support != null) {
            MonitorLocalHolder monitorLocalHolder = localHolder.monitorHolder[localHolder.monitorIndex];
            support.postProcess(monitorLocalHolder.djp == null ? localHolder.jp : monitorLocalHolder.djp, monitorLocalHolder.monitor, monitorLocalHolder.actions, monitorLocalHolder.states);
        }
    }

    public static void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray) {
        if (support != null) {
            support.postProcess(joinPoint, diagnosticMonitor, diagnosticActionArray, diagnosticActionStateArray);
        }
    }

    public static void postProcess(JoinPoint joinPoint, DiagnosticMonitor diagnosticMonitor, DiagnosticAction[] diagnosticActionArray, DiagnosticActionState[] diagnosticActionStateArray, Throwable throwable) {
        if (support != null) {
            support.postProcess(joinPoint, diagnosticMonitor, diagnosticActionArray, diagnosticActionStateArray);
        }
    }

    public static PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo valueHandlingInfo, ValueHandlingInfo valueHandlingInfo2, ValueHandlingInfo[] valueHandlingInfoArray) {
        if (support != null) {
            return support.createPointcutHandlingInfo(valueHandlingInfo, valueHandlingInfo2, valueHandlingInfoArray);
        }
        return new PlaceholderPointcutHandlingInfo(valueHandlingInfo, valueHandlingInfo2, valueHandlingInfoArray);
    }

    public static ValueHandlingInfo createValueHandlingInfo(String string, String string2, boolean bl, boolean bl2) {
        if (support != null) {
            return support.createValueHandlingInfo(string, string2, bl, bl2);
        }
        return new PlaceholderValueHandlingInfo(string, string2, bl, bl2);
    }

    public static Map<String, PointcutHandlingInfo> makeMap(String[] stringArray, PointcutHandlingInfo[] pointcutHandlingInfoArray) {
        if (support != null) {
            return support.makeMap(stringArray, pointcutHandlingInfoArray);
        }
        return InstrumentationSupport.placeholderMakeMap(stringArray, pointcutHandlingInfoArray);
    }

    private static Map<String, PointcutHandlingInfo> placeholderMakeMap(String[] stringArray, PointcutHandlingInfo[] pointcutHandlingInfoArray) {
        if (stringArray == null || pointcutHandlingInfoArray == null || stringArray.length == 0 && pointcutHandlingInfoArray.length == 0) {
            return null;
        }
        if (stringArray.length != pointcutHandlingInfoArray.length) {
            return null;
        }
        HashMap<String, PointcutHandlingInfo> hashMap = new HashMap<String, PointcutHandlingInfo>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                return null;
            }
            hashMap.put(stringArray[i], pointcutHandlingInfoArray[i]);
        }
        return hashMap;
    }

    public static Object[] toSensitive(Object[] objectArray) {
        return objectArray == null ? null : InstrumentationSupport.toSensitive(objectArray.length);
    }

    public static Object[] toSensitive(int n) {
        return SensitiveArrayHandler.toSensitive(n);
    }

    public static boolean isSensitiveArray(Object[] objectArray) {
        return SensitiveArrayHandler.isHandledSensitiveArray(objectArray);
    }

    private static class SensitiveArrayHandler {
        private static final Object[] SENSITIVE_ARRAY_1 = new Object[]{"*****"};
        private static final Object[] SENSITIVE_ARRAY_2 = new Object[]{"*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_3 = new Object[]{"*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_4 = new Object[]{"*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_5 = new Object[]{"*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_6 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_7 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_8 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_9 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_10 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[][] SENSITIVE_ARRAYS = new Object[][]{SENSITIVE_ARRAY_1, SENSITIVE_ARRAY_2, SENSITIVE_ARRAY_3, SENSITIVE_ARRAY_4, SENSITIVE_ARRAY_5, SENSITIVE_ARRAY_6, SENSITIVE_ARRAY_7, SENSITIVE_ARRAY_8, SENSITIVE_ARRAY_9, SENSITIVE_ARRAY_10};
        private static HashMap<Integer, Object[]> extendedArrays = new HashMap();

        private SensitiveArrayHandler() {
        }

        public static Object[] toSensitive(int n) {
            if (n == 0) {
                return null;
            }
            if (n > SENSITIVE_ARRAYS.length) {
                return SensitiveArrayHandler.getExtendedArray(n);
            }
            return SENSITIVE_ARRAYS[n - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isHandledSensitiveArray(Object[] objectArray) {
            if (objectArray == null || objectArray.length == 0) {
                return false;
            }
            if (objectArray.length > SENSITIVE_ARRAYS.length) {
                HashMap<Integer, Object[]> hashMap = extendedArrays;
                synchronized (hashMap) {
                    Object[] objectArray2 = extendedArrays.get(new Integer(objectArray.length));
                    if (objectArray2 == null) {
                        return false;
                    }
                    return objectArray2 == objectArray;
                }
            }
            return objectArray == SENSITIVE_ARRAYS[objectArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object[] getExtendedArray(int n) {
            Integer n2 = new Integer(n);
            Object[] objectArray = extendedArrays.get(n2);
            if (objectArray != null) {
                return objectArray;
            }
            HashMap<Integer, Object[]> hashMap = extendedArrays;
            synchronized (hashMap) {
                objectArray = extendedArrays.get(n2);
                if (objectArray != null) {
                    return objectArray;
                }
                objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = InstrumentationSupport.SENSITIVE_VALUE;
                }
                extendedArrays.put(n2, objectArray);
            }
            return objectArray;
        }
    }

    private static class PlaceholderValueHandlingInfo
    implements ValueHandlingInfo {
        private String name;
        private String rendererClassName;
        private boolean sensitive;
        private boolean gathered;

        public PlaceholderValueHandlingInfo(String string, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.rendererClassName = string2;
            this.sensitive = bl;
            this.gathered = bl2;
        }

        public String getName() {
            return this.name;
        }

        public String getRendererClassName() {
            return this.rendererClassName;
        }

        public boolean isGathered() {
            return this.gathered;
        }

        public boolean isSensitive() {
            return this.sensitive;
        }
    }

    private static class PlaceholderPointcutHandlingInfo
    implements PointcutHandlingInfo {
        private ValueHandlingInfo classValueHandlingInfo;
        private ValueHandlingInfo returnValueHandlingInfo;
        private ValueHandlingInfo[] argumentValueHandlingInfo;

        public PlaceholderPointcutHandlingInfo(ValueHandlingInfo valueHandlingInfo, ValueHandlingInfo valueHandlingInfo2, ValueHandlingInfo[] valueHandlingInfoArray) {
            this.classValueHandlingInfo = valueHandlingInfo;
            this.returnValueHandlingInfo = valueHandlingInfo2;
            this.argumentValueHandlingInfo = valueHandlingInfoArray;
        }

        public ValueHandlingInfo[] getArgumentValueHandlingInfo() {
            return this.argumentValueHandlingInfo;
        }

        public ValueHandlingInfo getClassValueHandlingInfo() {
            return this.classValueHandlingInfo;
        }

        public ValueHandlingInfo getReturnValueHandlingInfo() {
            return this.returnValueHandlingInfo;
        }
    }

    private static class PlaceholderDynamicJoinPoint
    extends PlaceholderJoinPoint
    implements DynamicJoinPoint {
        private JoinPoint jp;
        private static Object[] placeHolderArgs = new Object[0];

        PlaceholderDynamicJoinPoint(JoinPoint joinPoint) {
            this.jp = joinPoint;
        }

        public Object[] getArguments() {
            return placeHolderArgs;
        }

        public JoinPoint getDelegate() {
            return this.jp;
        }

        public Object getReturnValue() {
            return "";
        }

        public boolean isReturnGathered() {
            return false;
        }

        public GatheredArgument[] getGatheredArguments() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlaceholderJoinPoint
    implements JoinPoint {
        private static final String UNKNOWN = "Unknown";
        private Class joinpointClass = null;
        private String source = "Unknown";
        private String className = "Unknown";
        private String methodName = "Unknown";
        private String methodDesc = "Unknown";
        private int lineNum = 0;
        private Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap = null;
        private boolean isStatic = true;

        public PlaceholderJoinPoint() {
        }

        public PlaceholderJoinPoint(Class clazz, String string, String string2, String string3, String string4, int n, Map<String, PointcutHandlingInfo> map, boolean bl) {
            this.joinpointClass = clazz;
            this.source = string;
            this.className = string2;
            this.methodName = string3;
            this.methodDesc = string4;
            this.lineNum = n;
            this.pointcutHandlingInfoMap = map;
            this.isStatic = bl;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        @Override
        public String getMethodDescriptor() {
            return this.methodDesc;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public String getModuleName() {
            return UNKNOWN;
        }

        @Override
        public String getSourceFile() {
            return this.source;
        }

        @Override
        public boolean isReturnGathered(String string) {
            return false;
        }

        @Override
        public GatheredArgument[] getGatheredArguments(String string) {
            return null;
        }

        @Override
        public Map<String, PointcutHandlingInfo> getPointcutHandlingInfoMap() {
            return this.pointcutHandlingInfoMap;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }
    }

    private static class PlaceholderDelegatingMonitor
    implements DelegatingMonitor {
        private String type;

        PlaceholderDelegatingMonitor(String string) {
            this.type = string;
        }

        public String getAttribute(String string) {
            return null;
        }

        public String[] getAttributeNames() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public boolean isArgumentsCaptureNeeded() {
            return false;
        }

        public boolean isComponentScopeAllowed() {
            return true;
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean isEnabledAndNotDyeFiltered() {
            return false;
        }

        public boolean isServerScopeAllowed() {
            return true;
        }

        public void setAttribute(String string, String string2) {
        }

        public void setDescription(String string) {
        }

        public void setEnabled(boolean bl) {
        }

        public void setName(String string) {
        }

        public long getDyeMask() {
            return 0L;
        }

        public boolean isDyeFilteringEnabled() {
            return false;
        }

        public void setDyeFilteringEnabled(boolean bl) {
        }

        public void setDyeMask(long l) {
        }

        public void addAction(DiagnosticAction diagnosticAction) {
        }

        public DiagnosticAction[] getActions() {
            return null;
        }

        public String[] getCompatibleActionTypes() {
            return null;
        }

        public void removeAction(DiagnosticAction diagnosticAction) {
        }

        public String[] getIncludes() {
            return null;
        }

        public void setIncludes(String[] stringArray) {
        }

        public String[] getExcludes() {
            return null;
        }

        public void setExcludes(String[] stringArray) {
        }

        public boolean isServerManaged() {
            return false;
        }

        public void setServerManaged(boolean bl) {
        }

        public String getDiagnosticVolume() {
            return "Off";
        }

        public void setDiagnosticVolume(String string) {
        }

        public String getEventClassName() {
            return null;
        }

        public Class getEventClass() {
            return null;
        }

        public void setEventClassName(String string) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InstrumentationSupportInterface {
        public DiagnosticMonitor getMonitor(Class var1, String var2);

        public void process(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3);

        public void preProcess(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3, DiagnosticActionState[] var4);

        public void postProcess(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3, DiagnosticActionState[] var4);

        public JoinPoint createJoinPoint(Class var1, String var2, String var3, String var4, String var5, int var6, Map<String, PointcutHandlingInfo> var7, boolean var8);

        public DynamicJoinPoint createDynamicJoinPoint(JoinPoint var1, Object[] var2, Object var3);

        public PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo var1, ValueHandlingInfo var2, ValueHandlingInfo[] var3);

        public ValueHandlingInfo createValueHandlingInfo(String var1, String var2, boolean var3, boolean var4);

        public Map<String, PointcutHandlingInfo> makeMap(String[] var1, PointcutHandlingInfo[] var2);
    }
}

