/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.LocalHolder;

public class InstrumentationSupportBase {
    protected static final DebugLogger debugLogger = DebugLogger.getDebugLogger("DebugDiagnosticInstrumentationActions");

    public static DiagnosticActionState[] getActionStates(DiagnosticAction[] diagnosticActionArray) {
        if (diagnosticActionArray == null) {
            return null;
        }
        int n = diagnosticActionArray.length;
        DiagnosticActionState[] diagnosticActionStateArray = new DiagnosticActionState[n];
        for (int i = 0; i < n; ++i) {
            try {
                diagnosticActionStateArray[i] = ((AroundDiagnosticAction)diagnosticActionArray[i]).createState();
                continue;
            }
            catch (Throwable throwable) {
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("failure calling createState for action class: " + ((AroundDiagnosticAction)diagnosticActionArray[i]).getClass().getName(), throwable);
            }
        }
        return diagnosticActionStateArray;
    }

    public static void applyActionStates(LocalHolder localHolder) {
        DiagnosticAction[] diagnosticActionArray = localHolder.monitorHolder[localHolder.monitorIndex].actions;
        if (diagnosticActionArray == null) {
            return;
        }
        int n = diagnosticActionArray.length;
        DiagnosticActionState[] diagnosticActionStateArray = new DiagnosticActionState[n];
        for (int i = 0; i < n; ++i) {
            try {
                diagnosticActionStateArray[i] = ((AroundDiagnosticAction)diagnosticActionArray[i]).createState();
                continue;
            }
            catch (Throwable throwable) {
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("failure calling createState for action class: " + ((AroundDiagnosticAction)diagnosticActionArray[i]).getClass().getName(), throwable);
            }
        }
        localHolder.monitorHolder[localHolder.monitorIndex].states = diagnosticActionStateArray;
    }

    public static Object convertToObject(byte by) throws ClassCastException {
        return new Byte(by);
    }

    public static Object convertToObject(char c) throws ClassCastException {
        return new Character(c);
    }

    public static Object convertToObject(short s) throws ClassCastException {
        return new Short(s);
    }

    public static Object convertToObject(int n) throws ClassCastException {
        return new Integer(n);
    }

    public static Object convertToObject(long l) throws ClassCastException {
        return new Long(l);
    }

    public static Object convertToObject(float f) throws ClassCastException {
        return new Float(f);
    }

    public static Object convertToObject(double d) throws ClassCastException {
        return new Double(d);
    }

    public static Object convertToObject(boolean bl) throws ClassCastException {
        return new Boolean(bl);
    }

    public static byte convertFromObject(Byte by) {
        return by;
    }

    public static char convertFromObject(Character c) {
        return c.charValue();
    }

    public static short convertFromObject(Short s) {
        return s;
    }

    public static int convertFromObject(Integer n) {
        return n;
    }

    public static long convertFromObject(Long l) {
        return l;
    }

    public static float convertFromObject(Float f) {
        return f.floatValue();
    }

    public static double convertFromObject(Double d) {
        return d;
    }

    public static boolean convertFromObject(Boolean bl) {
        return bl;
    }
}

