/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public final class JMSCHandler
implements ExceptionListener,
MessageListener {
    private final int id;

    private native void JmsHandleException(int var1, JMSException var2);

    private native void JmsHandleMessage(int var1, Message var2);

    public JMSCHandler(int n) {
        this.id = n;
    }

    public void onException(JMSException jMSException) {
        try {
            this.JmsHandleException(this.id, jMSException);
        }
        catch (Throwable throwable) {
            System.out.println("An exception was raised in the native C exception handler: " + throwable);
        }
    }

    public void onMessage(Message message) {
        try {
            this.JmsHandleMessage(this.id, message);
        }
        catch (Throwable throwable) {
            System.out.println("An exception was raised in the native C message handler: " + throwable);
        }
    }

    static {
        try {
            System.loadLibrary("jmsc");
        }
        catch (Throwable throwable) {
            System.out.println("Could not load library jmsc: " + throwable);
        }
    }
}

