/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSMessageContext;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.JMSSystemMessageListener;
import weblogic.jms.client.JMSSystemMessageListenerImpl2;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidSelectorException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.frontend.FEConsumerSetListenerRequest;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.security.subject.AbstractSubject;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.expressions.ExpressionEvaluator;
import weblogic.utils.expressions.ExpressionParserException;

public final class JMSConsumer
implements ConsumerInternal,
Reconnectable,
Cloneable,
Invocable {
    private static final String EXPRESSION_PARSER_CLASS = "weblogic.utils.expressions.ExpressionParser";
    private volatile JMSID consumerId;
    private volatile boolean closeInProgress;
    private long expectedSequenceNumber;
    private final JMSSession session;
    private final DestinationImpl destination;
    private final String selector;
    private final String name;
    private final boolean noLocal;
    private ExpressionEvaluator expressionEvaluator;
    private int windowMaximum;
    private int windowCurrent;
    private int windowThreshold;
    private String runtimeMBeanName;
    private JMSMessageContext messageListenerContext;
    private boolean debugHybridConsumer = false;
    private boolean isClosed;
    private WLConsumerImpl wlConsumerImpl;
    private JMSConsumer replacementConsumer;
    private final byte destinationFlags;
    private ConsumerReconnectInfo consumerReconnectInfo;

    JMSConsumer(JMSSession jMSSession, String string, DestinationImpl destinationImpl, String string2, boolean bl, int n, byte by) throws JMSException {
        this.name = string;
        this.session = jMSSession;
        this.destination = destinationImpl;
        this.selector = string2;
        this.noLocal = bl;
        if (jMSSession.getAcknowledgeMode() != 128) {
            this.windowMaximum = n;
            this.windowCurrent = n;
            this.windowThreshold = n + 1 >> 1;
        } else if (string2 != null && string2.trim().length() > 0) {
            this.expressionEvaluator = JMSConsumer.createExpressionEvaluator(string2);
        }
        this.destinationFlags = by;
    }

    public Object clone() throws CloneNotSupportedException {
        JMSConsumer jMSConsumer = (JMSConsumer)super.clone();
        return jMSConsumer;
    }

    WLConsumerImpl getWLConsumerImpl() {
        return this.wlConsumerImpl;
    }

    public ReconnectController getReconnectController() {
        return this.wlConsumerImpl;
    }

    public Reconnectable getReconnectState(int n) throws CloneNotSupportedException {
        JMSConsumer jMSConsumer = (JMSConsumer)this.clone();
        jMSConsumer.replacementConsumer = this;
        this.closeInProgress = true;
        return jMSConsumer;
    }

    public Reconnectable preCreateReplacement(Reconnectable reconnectable) throws JMSException {
        ConsumerReconnectInfo consumerReconnectInfo = this.consumerReconnectInfo.getClone();
        consumerReconnectInfo.setLastExposedMsgId(this.session.getLastExposedMsgId());
        consumerReconnectInfo.setLastAckMsgId(this.session.getLastAckMsgId());
        if (this.isDurable()) {
            consumerReconnectInfo.setServerDestId(null);
        }
        JMSConsumer jMSConsumer = ((JMSSession)reconnectable).setupConsumer(this.destination, this.selector, this.noLocal, this.name, this.destinationFlags, consumerReconnectInfo);
        jMSConsumer.windowCurrent = this.windowCurrent;
        MessageListener messageListener = null;
        if (this.messageListenerContext != null) {
            messageListener = this.messageListenerContext.getMessageListener();
        }
        if (messageListener != null && !(messageListener instanceof JMSSystemMessageListener)) {
            jMSConsumer.setMessageListener(messageListener);
        }
        ((JMSSession)reconnectable).mapReplacementConsumer(this.replacementConsumer, jMSConsumer);
        this.replacementConsumer = jMSConsumer;
        return jMSConsumer;
    }

    public void postCreateReplacement() {
        this.replacementConsumer.setWlConsumerImpl(this.wlConsumerImpl);
        this.wlConsumerImpl.setPhysicalReconnectable(this.replacementConsumer);
    }

    public void forgetReconnectState() {
        this.replacementConsumer = null;
    }

    public PeerInfo getFEPeerInfo() {
        return this.session.getFEPeerInfo();
    }

    public boolean isReconnectControllerClosed() {
        return this.wlConsumerImpl == null || this.wlConsumerImpl.isClosed();
    }

    public final boolean isClosed() {
        return this.isClosed || this.closeInProgress;
    }

    public String getWLSServerName() {
        return this.session.getConnection().getWLSServerName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return this.session;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    final void setWlConsumerImpl(WLConsumerImpl wLConsumerImpl) {
        this.wlConsumerImpl = wLConsumerImpl;
    }

    public void setConsumerReconnectInfo(ConsumerReconnectInfo consumerReconnectInfo) {
        this.consumerReconnectInfo = consumerReconnectInfo;
    }

    boolean hasTemporaryDestination() {
        DestinationImpl destinationImpl = this.destination;
        return destinationImpl != null && (destinationImpl.getType() == 4 || destinationImpl.getType() == 8);
    }

    public final JMSSession getSession() {
        return this.session;
    }

    public final void setRuntimeMBeanName(String string) {
        this.runtimeMBeanName = string;
    }

    public final String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    private void incrementWindowCurrent(int n, boolean bl) throws JMSException {
        this.session.consumerIncrementWindowCurrent(this.consumerId, n, bl);
        this.windowCurrent += n;
        if (this.windowCurrent > this.windowMaximum) {
            this.windowCurrent = this.windowMaximum;
        }
    }

    public final void decrementWindowCurrent(boolean bl) throws JMSException {
        if (--this.windowCurrent < this.windowThreshold) {
            this.incrementWindowCurrent(this.windowMaximum - this.windowCurrent, bl);
        }
    }

    public final void setWindowCurrent(int n) {
        this.windowCurrent = n;
    }

    public final int getWindowCurrent() {
        return this.windowCurrent;
    }

    public final int getWindowMaximum() {
        return this.windowMaximum;
    }

    public final ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final void setId(JMSID jMSID) {
        this.consumerId = jMSID;
    }

    public final JMSID getJMSID() {
        return this.consumerId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public final InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public final boolean isDurable() {
        return this.name != null;
    }

    public final synchronized long getExpectedSequenceNumber() {
        return this.expectedSequenceNumber;
    }

    public final synchronized void setExpectedSequenceNumber(long l) {
        this.setExpectedSequenceNumber(l, false);
    }

    public final synchronized void setExpectedSequenceNumber(long l, boolean bl) {
        if (bl || l > this.expectedSequenceNumber) {
            this.expectedSequenceNumber = l;
        }
    }

    public final Destination getDestination() {
        return this.destination;
    }

    public final String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public final MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        if (this.messageListenerContext != null) {
            return this.messageListenerContext.getMessageListener();
        }
        return null;
    }

    public final JMSMessageContext getMessageListenerContext() {
        return this.messageListenerContext;
    }

    public final void setMessageListener(MessageListener messageListener) throws JMSException {
        this.setMessageListener(messageListener, -1L);
    }

    final void setMessageListener(final MessageListener messageListener, long l) throws JMSException {
        final long l2 = l;
        if (!KernelStatus.isServer()) {
            this.setMessageListenerInternal(messageListener, l2);
            return;
        }
        AbstractSubject abstractSubject = CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getSession().getConnection().getFrontEndDispatcher(), CrossDomainSecurityManager.getCurrentSubject(), true);
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("setMessageListener:   subject to use = " + abstractSubject);
        }
        CrossDomainSecurityManager.doAs(abstractSubject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                JMSConsumer.this.setMessageListenerInternal(messageListener, l2);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setMessageListenerInternal(MessageListener messageListener, long l) throws JMSException {
        JMSSession jMSSession = this.session;
        synchronized (jMSSession) {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.checkClosed();
                if (l != -1L) {
                    this.session.setRealLastSequenceNumber(l);
                }
                if (this.session.getMessageListener() != null) {
                    throw new IllegalStateException(JMSClientExceptionLogger.logMessageListenerExistsLoggable());
                }
                if (messageListener instanceof JMSSystemMessageListenerImpl2) {
                    this.session.markAsSystemMessageListener(true);
                } else {
                    this.session.markAsSystemMessageListener(false);
                }
                try {
                    if (this.getMessageListener() == null && messageListener != null) {
                        this.session.incrementConsumerListenerCount();
                    } else if (this.getMessageListener() != null && messageListener == null) {
                        this.session.decrementConsumerListenerCount();
                    } else {
                        Object var8_5 = null;
                        this.messageListenerContext = new JMSMessageContext(messageListener);
                        return;
                    }
                    try {
                        Response response = this.session.getConnection().getFrontEndDispatcher().dispatchSync(new FEConsumerSetListenerRequest(this.consumerId, messageListener != null, this.session.getLastSequenceNumber()));
                    }
                    catch (JMSException jMSException) {
                        messageListener = null;
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.messageListenerContext = new JMSMessageContext(messageListener);
                    throw throwable;
                }
                Object var8_6 = null;
                this.messageListenerContext = new JMSMessageContext(messageListener);
            }
        }
    }

    public final Message receive() throws JMSException {
        return this.receiveInternal(Long.MAX_VALUE, null);
    }

    public final Message receiveNoWait() throws JMSException {
        return this.receiveInternal(0x7FFFFFFFFFFFFFFEL, null);
    }

    public final Message receive(long l) throws JMSException {
        return this.receiveInternal(l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message receiveInternal(long l, CompletionListener completionListener) throws JMSException {
        Cloneable cloneable;
        block28: {
            Cloneable cloneable2;
            JMSSystemMessageListener jMSSystemMessageListener = null;
            cloneable = this.session;
            synchronized (cloneable) {
                cloneable2 = this;
                synchronized (cloneable2) {
                    this.checkClosed();
                    if (this.session.getAcknowledgeMode() == 128) {
                        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSynchronousMulticastReceiveLoggable());
                    }
                    if (l == 0L) {
                        l = Long.MAX_VALUE;
                    } else if (l < 0L) {
                        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidTimeoutLoggable(l));
                    }
                    try {
                        jMSSystemMessageListener = (JMSSystemMessageListener)this.getMessageListener();
                    }
                    catch (ClassCastException classCastException) {
                        throw new IllegalStateException(JMSClientExceptionLogger.logListenerExistsLoggable());
                    }
                    if (jMSSystemMessageListener == null) {
                        if (!this.session.prefetchDisabled()) {
                            int n = this.session.getConnection().getSynchronousPrefetchMode();
                            if (this.destination.isTopic() && n > 0 || this.destination.isQueue() && n == 1 || System.getProperty("weblogic.jms.MessagePrefetch2") != null) {
                                if (this.session.prefetchStarted()) {
                                    throw new UnsupportedOperationException(JMSClientExceptionLogger.logMultiplePrefetchConsumerPerSessionLoggable().getMessage());
                                }
                                if (!this.session.isTransacted() && this.session.userTransactionsEnabled() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                                    this.session.disablePrefetch();
                                }
                                if (this.session.consumersCount() > 1) {
                                    this.session.disablePrefetch();
                                }
                                if (!this.session.prefetchDisabled()) {
                                    jMSSystemMessageListener = new JMSSystemMessageListenerImpl2(this);
                                    this.setMessageListener(jMSSystemMessageListener);
                                    this.session.startPrefetch();
                                }
                            }
                        }
                    } else if (this.session.prefetchStarted()) {
                        if (!this.session.isTransacted() && this.session.userTransactionsEnabled() && TransactionHelper.getTransactionHelper().getTransaction() != null) {
                            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUserTXNotSupportPrefetchConsumerPerSessionLoggable().getMessage());
                        }
                    } else {
                        throw new IllegalStateException(JMSClientExceptionLogger.logListenerExistsLoggable());
                    }
                    this.session.setState(2);
                }
            }
            if (jMSSystemMessageListener == null) break block28;
            cloneable = (MessageImpl)jMSSystemMessageListener.receive(l);
            cloneable2 = this.session.afterReceive((MessageImpl)cloneable, this.consumerId, completionListener);
            Object var11_11 = null;
            this.session.clearState(2);
            return cloneable2;
        }
        try {
            cloneable = this.session.receiveMessage(this, l, completionListener);
            Object var11_12 = null;
            this.session.clearState(2);
            return cloneable;
        }
        catch (Exception exception) {
            try {
                throw JMSSession.handleException(exception);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.session.clearState(2);
                throw throwable;
            }
        }
    }

    public final void close() throws JMSException {
        this.close(-1L);
    }

    final void close(long l) throws JMSException {
        this.session.consumerClose(this, l);
        if (this.messageListenerContext != null && this.messageListenerContext.getMessageListener() instanceof JMSSystemMessageListener) {
            this.session.markAsSystemMessageListener(false);
        }
        if (this.isDurable()) {
            this.removeDurableConsumer();
        }
    }

    private synchronized void checkClosed() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(JMSClientExceptionLogger.logClosedConsumerLoggable());
        }
    }

    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    public final void removeDurableConsumer() {
        if (this.session.getConnection() != null) {
            this.session.getConnection().removeDurableSubscriber(this.name);
        }
    }

    public final Topic getTopic() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public final boolean privateGetNoLocal() {
        return this.noLocal;
    }

    public final boolean getNoLocal() throws JMSException {
        this.checkClosed();
        return this.noLocal;
    }

    public final int getSubscriptionSharingPolicy() throws JMSException {
        this.checkClosed();
        return this.session.getSubscriptionSharingPolicy();
    }

    public final Queue getQueue() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request request) {
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        weblogic.jms.common.JMSException jMSException = jMSPushExceptionRequest.getException();
        if (jMSException instanceof ConsumerClosedException) {
            ((ConsumerClosedException)jMSException).setConsumer(this);
        }
        if (this.isDurable()) {
            this.removeDurableConsumer();
        }
        try {
            JMSConsumer jMSConsumer = this;
            synchronized (jMSConsumer) {
                this.setClosed(true);
            }
            this.session.onException(jMSException);
        }
        catch (Throwable throwable) {
            JMSClientExceptionLogger.logStackTrace(throwable);
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public final int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15366: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNoSuchMethod4Loggable(request.getMethodId()));
    }

    private static ExpressionEvaluator createExpressionEvaluator(String string) throws weblogic.jms.common.JMSException, InvalidSelectorException {
        ExpressionEvaluator expressionEvaluator;
        Class<?> clazz;
        try {
            clazz = Class.forName(EXPRESSION_PARSER_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logMulticastSelectorsLoggable());
        }
        try {
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("parse", String.class);
            expressionEvaluator = (ExpressionEvaluator)method.invoke(obj, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInternalErrorLoggable(illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInternalError2Loggable(noSuchMethodException));
        }
        catch (InstantiationException instantiationException) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInternalError3Loggable(instantiationException));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string2 = throwable instanceof ExpressionParserException ? throwable.getMessage() : JMSClientExceptionLogger.logInvalidSelectorLoggable(throwable).getMessage();
            throw new InvalidSelectorException(string2);
        }
        return expressionEvaluator;
    }
}

