/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;
import weblogic.jms.client.JMSQueueBrowser;
import weblogic.jms.common.JMSEnumerationNextElementResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEEnumerationNextElementRequest;
import weblogic.messaging.dispatcher.Response;

final class JMSEnumeration
implements Enumeration {
    private final Queue queue;
    private final JMSQueueBrowser browser;
    private JMSID enumerationId;
    private final JMSDispatcher frontEndDispatcher;
    private MessageImpl message;

    public JMSEnumeration(Queue queue, JMSQueueBrowser jMSQueueBrowser, JMSID jMSID, JMSDispatcher jMSDispatcher) throws JMSException {
        this.queue = queue;
        this.browser = jMSQueueBrowser;
        this.enumerationId = jMSID;
        this.frontEndDispatcher = jMSDispatcher;
    }

    public boolean hasMoreElements() {
        if (this.message != null) {
            return true;
        }
        if (!this.isClosed()) {
            this.message = this.getNextMessage();
        }
        return this.message != null;
    }

    public Object nextElement() {
        if (this.message == null) {
            if (!this.isClosed()) {
                this.message = this.getNextMessage();
            }
            if (this.message == null) {
                throw new NoSuchElementException();
            }
        }
        MessageImpl messageImpl = this.message;
        this.message = null;
        try {
            messageImpl.setJMSDestination(this.queue);
            if (this.isClosed() || this.browser.getSession().getConnection().isLocal()) {
                boolean bl = messageImpl.isOldMessage();
                messageImpl = messageImpl.copy();
                messageImpl.setOldMessage(bl);
            }
            messageImpl.includeJMSXDeliveryCount(true);
        }
        catch (JMSException jMSException) {
            throw new AssertionError();
        }
        return messageImpl;
    }

    private boolean isClosed() {
        if (this.enumerationId == null) {
            return true;
        }
        if (this.browser.isClosed()) {
            this.close();
        }
        return this.enumerationId == null;
    }

    private void close() {
        this.enumerationId = null;
    }

    private MessageImpl getNextMessage() {
        MessageImpl messageImpl = null;
        try {
            Response response = this.frontEndDispatcher.dispatchSync(new FEEnumerationNextElementRequest(this.enumerationId));
            messageImpl = ((JMSEnumerationNextElementResponse)response).getMessage();
        }
        catch (JMSException jMSException) {
            return null;
        }
        if (messageImpl == null) {
            this.close();
        }
        return messageImpl;
    }
}

