/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.transaction.Transaction;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.ProducerInternal;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.common.AlreadyClosedException;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.LostServerException;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.ProducerSendResponse;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEProducerSendRequest;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.transaction.TransactionHelper;

public final class JMSProducer
implements ProducerInternal,
Invocable,
Reconnectable,
Cloneable {
    private static int ONEWAYSENDCONSECUTIVEMESSAGELIMIT = 320000;
    private final JMSSession session;
    private volatile JMSID producerId;
    private volatile boolean closeInProgress;
    private final DestinationImpl destination;
    private int deliveryMode;
    private int priority;
    private long timeToDeliver = -1L;
    private long timeToLive;
    private int redeliveryLimit = -1;
    private long sendTimeout;
    private boolean messageIdsDisabled;
    private boolean messageTimestampsDisabled;
    private boolean flowControlEnabled;
    private final int flowMinimum;
    private final int flowMaximum;
    private final double flowDecrease;
    private final int flowIncrease;
    private final long flowInterval;
    private PeerInfo peerInfo;
    private double flowRateCurrent;
    private long backOffTime;
    private boolean needsFlowControl;
    private long currentTime;
    private long elapsedTime;
    private long lastTimeChanged;
    private long lastTimeLeave;
    private long asyncSendFlowControlTime;
    private final String runtimeMBeanName;
    private String unitOfOrderName;
    private String sequenceName;
    private int compressionThreshold = Integer.MAX_VALUE;
    private WLProducerImpl wlProducerImpl;
    private byte destinationFlags;
    private JMSProducer replacementProducer;
    private int oneWaySendMode;
    private int oneWayWindowSize;
    private static boolean ONEWAYSENDENABLED = false;
    private static int oneWaySendModeConf = 0;
    private static int oneWayWindowSizeConf = 1;
    private static final int MODE_SYNC_TRAN = 0;
    private static final int MODE_SYNC_NO_TRAN = 1;
    private static final int MODE_SYNC_NO_TRAN_WITH_ID = 2;
    private static final int MODE_NO_REPLY_WITH_ID = 3;
    private static final int MODE_ASYNC_TRAN = 4;
    private static final int MODE_ASYNC_NO_TRAN = 5;
    int count = 0;
    int totalConsecutiveOneWaySendMessageSize = 0;

    JMSProducer(JMSSession jMSSession, JMSID jMSID, DestinationImpl destinationImpl, String string) {
        this.session = jMSSession;
        this.producerId = jMSID;
        this.destination = destinationImpl;
        this.runtimeMBeanName = string;
        this.peerInfo = jMSSession.getConnection().getFEPeerInfo();
        this.deliveryMode = jMSSession.getDeliveryMode();
        this.priority = jMSSession.getPriority();
        this.timeToLive = jMSSession.getTimeToLive();
        this.sendTimeout = jMSSession.getSendTimeout();
        JMSConnection jMSConnection = jMSSession.getConnection();
        this.flowControlEnabled = jMSConnection.isFlowControlEnabled();
        this.flowMinimum = jMSConnection.getFlowMinimum();
        this.flowMaximum = jMSConnection.getFlowMaximum();
        this.flowIncrease = jMSConnection.getFlowIncrease();
        this.flowDecrease = jMSConnection.getFlowDecrease();
        this.flowInterval = jMSConnection.getFlowInterval();
        this.flowRateCurrent = this.flowMaximum;
        this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
        this.compressionThreshold = jMSSession.getConnection().getCompressionThreshold();
        this.oneWaySendMode = jMSConnection.getOneWaySendMode();
        this.oneWayWindowSize = jMSConnection.getOneWaySendWindowSize();
        if (this.oneWaySendMode != 0 && JMSEnvironment.getJMSEnvironment().isThinClient()) {
            this.oneWaySendMode = 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JMSProducer jMSProducer = (JMSProducer)super.clone();
        return jMSProducer;
    }

    public ReconnectController getReconnectController() {
        return this.wlProducerImpl;
    }

    public Reconnectable getReconnectState(int n) throws CloneNotSupportedException {
        JMSProducer jMSProducer = (JMSProducer)this.clone();
        this.closeInProgress = true;
        return jMSProducer;
    }

    public Reconnectable preCreateReplacement(Reconnectable reconnectable) throws JMSException {
        JMSProducer jMSProducer = ((JMSSession)reconnectable).setupJMSProducer(this.destination, this.destinationFlags);
        if (this.unitOfOrderName == null && jMSProducer.getUnitOfOrder() != null || this.unitOfOrderName != null && !this.unitOfOrderName.equals(jMSProducer.getUnitOfOrder())) {
            jMSProducer.setUnitOfOrder(this.unitOfOrderName);
        }
        jMSProducer.sequenceName = this.sequenceName;
        jMSProducer.messageIdsDisabled = this.messageIdsDisabled;
        jMSProducer.messageTimestampsDisabled = this.messageTimestampsDisabled;
        jMSProducer.deliveryMode = this.deliveryMode;
        jMSProducer.priority = this.priority;
        jMSProducer.timeToDeliver = this.timeToDeliver;
        jMSProducer.timeToLive = this.timeToLive;
        jMSProducer.redeliveryLimit = this.redeliveryLimit;
        jMSProducer.sendTimeout = this.sendTimeout;
        this.replacementProducer = jMSProducer;
        return jMSProducer;
    }

    public void postCreateReplacement() {
        this.replacementProducer.setWlProducerImpl(this.wlProducerImpl);
        this.wlProducerImpl.setPhysicalReconnectable(this.replacementProducer);
    }

    public boolean isReconnectControllerClosed() {
        return this.wlProducerImpl == null || this.wlProducerImpl.isClosed();
    }

    public void forgetReconnectState() {
        this.replacementProducer = null;
    }

    public PeerInfo getFEPeerInfo() {
        return this.session.getFEPeerInfo();
    }

    public boolean isClosed() {
        return this.producerId == null || this.closeInProgress;
    }

    public String getWLSServerName() {
        return this.session.getConnection().getWLSServerName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return this.session;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public final void setCompressionThreshold(int n) throws JMSException {
        if (n < 0) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidCompressionThresholdLoggable().getMessage());
        }
        this.compressionThreshold = n;
    }

    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    void setId(JMSID jMSID) {
        this.producerId = jMSID;
    }

    public JMSID getJMSID() {
        return this.producerId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.sendWithListener(null, destination, message);
    }

    private void sendWithListener(CompletionListener completionListener, Destination destination, Message message) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.sendInternal(destination, message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        this.sendWithListener(null, destination, message, n, n2, l);
    }

    private void sendWithListener(CompletionListener completionListener, Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestination2Loggable().getMessage());
        }
        this.sendInternal(destination, message, n, n2, l, completionListener);
    }

    public void send(Message message) throws JMSException {
        this.sendWithListener(null, message);
    }

    private void sendWithListener(CompletionListener completionListener, Message message) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.sendInternal(this.destination, message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        this.sendWithListener(null, message, n, n2, l);
    }

    private void sendWithListener(CompletionListener completionListener, Message message, int n, int n2, long l) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestination2Loggable().getMessage());
        }
        this.sendInternal(this.destination, message, n, n2, l, completionListener);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        this.send((Destination)queue, message, n, n2, l);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        this.send(message, n, n2, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send(topic, message);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        this.send(topic, message, n, n2, l);
    }

    private void forwardInternal(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (!(message instanceof MessageImpl)) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNotForwardable3Loggable());
        }
        if (this.peerInfo.getMajor() < 9) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logUnsupportedLoggable());
        }
        if (!((MessageImpl)message).isForwardable()) {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logNotForwardable2Loggable());
        }
        this.deliveryInternal(destination, message, n, n2, l, true, null);
    }

    private void sendInternal(Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) throws JMSException {
        this.deliveryInternal(destination, message, n, n2, l, false, completionListener);
    }

    public static void sendReturn(ProducerSendResponse producerSendResponse, Message message, MessageImpl messageImpl, boolean bl, long l, long l2, int n, int n2, Destination destination) throws JMSException {
        JMSMessageId jMSMessageId = producerSendResponse.getMessageId();
        if (!bl) {
            messageImpl.setId(jMSMessageId);
            messageImpl.setOldMessage(!producerSendResponse.get90StyleMessageId());
        }
        if (message == messageImpl) {
            if (l != 0L) {
                messageImpl.setDeliveryTime(jMSMessageId.getTimestamp() + l);
            }
            messageImpl.setJMSDestinationImpl((DestinationImpl)destination);
        } else {
            try {
                message.setJMSDestination(destination);
            }
            catch (ClassCastException classCastException) {
            }
            catch (javax.jms.InvalidDestinationException invalidDestinationException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            message.setJMSDeliveryMode(messageImpl.getJMSDeliveryMode());
            message.setJMSPriority(messageImpl.getJMSPriority());
            if (message instanceof MessageImpl) {
                if (!bl) {
                    ((MessageImpl)message).setId(jMSMessageId);
                    ((MessageImpl)message).setOldMessage(messageImpl.isOldMessage());
                }
            } else {
                message.setJMSTimestamp(messageImpl.getJMSTimestamp());
                try {
                    message.setJMSMessageID(messageImpl.getJMSMessageID());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (messageImpl.getJMSExpiration() != 0L) {
            message.setJMSExpiration(jMSMessageId.getTimestamp() + l2);
        } else {
            message.setJMSExpiration(0L);
        }
        try {
            n = producerSendResponse.getDeliveryMode();
            if (n != -1) {
                message.setJMSDeliveryMode(n);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        n2 = producerSendResponse.getPriority();
        if (n2 != -1) {
            message.setJMSPriority(n2);
        }
        if ((l2 = producerSendResponse.getTimeToLive()) != -1L) {
            message.setJMSExpiration(jMSMessageId.getTimestamp() + l2);
        }
        if (message instanceof MessageImpl) {
            int n3;
            l = producerSendResponse.getTimeToDeliver();
            if (l != -1L) {
                ((MessageImpl)message).setDeliveryTime(jMSMessageId.getTimestamp() + l);
            }
            if ((n3 = producerSendResponse.getRedeliveryLimit()) != 0) {
                ((MessageImpl)message).setJMSRedeliveryLimit(n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliveryInternal(Destination destination, Message message, int n, int n2, long l, boolean bl, CompletionListener completionListener) throws JMSException {
        MessageImpl messageImpl;
        if (destination == null) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logNullDestination2Loggable().getMessage());
        }
        if (!(destination instanceof DestinationImpl)) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logForeignDestination2Loggable().getMessage());
        }
        if (this.session.getType() == 2 && !((DestinationImpl)destination).isQueue()) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logMustBeAQueueLoggable(destination.toString()).getMessage());
        }
        if (this.session.getType() == 1 && !((DestinationImpl)destination).isTopic()) {
            throw new InvalidDestinationException(JMSClientExceptionLogger.logMustBeATopicLoggable(destination.toString()).getMessage());
        }
        if (completionListener == null) {
            this.doFlowControl();
        } else {
            this.asyncSendFlowControlTime = this.getFlowControlSleepTime();
        }
        try {
            Destination destination2;
            messageImpl = (MessageImpl)message;
            messageImpl.resetUserPropertySize();
            if (!bl) {
                messageImpl.setForward(false);
                messageImpl.resetForwardsCount();
                messageImpl.setOldMessage(false);
                messageImpl.setJMSXUserID(null);
                if (!(messageImpl.getSAFSequenceName() == null && messageImpl.getSAFSeqNumber() == 0L || messageImpl.getKeepSAFSequenceNameAndNumber())) {
                    messageImpl.setSAFSequenceName(null);
                    messageImpl.setSAFSeqNumber(0L);
                }
            }
            if (this.session.getConnection().isLocal() && (destination2 = (messageImpl = messageImpl.copy()).getJMSReplyTo()) != null && destination2 instanceof DestinationImpl) {
                try {
                    messageImpl.setJMSReplyTo((Destination)((DestinationImpl)destination2).clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
        catch (ClassCastException classCastException) {
            messageImpl = JMSProducer.convertMessage(message);
        }
        if (l == 0L) {
            l = 0L;
        }
        try {
            messageImpl.setJMSExpiration(l);
            long l2 = this.getTimeToDeliverInternal();
            messageImpl.setDeliveryTime(l2);
            messageImpl.setJMSRedeliveryLimit(this.redeliveryLimit);
            messageImpl.setJMSDestinationImpl(null);
            if (!bl) {
                messageImpl.setId(null);
            }
            messageImpl.setJMSDeliveryMode(n);
            messageImpl.setJMSPriority(n2);
            messageImpl.setDDForwarded(false);
            messageImpl.setDeliveryCount(0);
            messageImpl.setUnitOfOrderName(this.unitOfOrderName);
            JMSWorkContextHelper.infectMessage(messageImpl);
            if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Sending message deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l + " timeToDeliver = " + l2 + " redeliveryLimit = " + this.redeliveryLimit);
            }
            JMSProducerSendResponse jMSProducerSendResponse = (JMSProducerSendResponse)this.toFEProducer(destination, message, messageImpl, n, l2, n2, l, bl, completionListener);
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            throw throwable;
        }
    }

    private void wrappedSendReturn(JMSProducerSendResponse jMSProducerSendResponse, Destination destination, Message message, MessageImpl messageImpl, int n, long l, int n2, long l2, boolean bl) throws JMSException {
        JMSProducer.sendReturn(jMSProducerSendResponse, message, messageImpl, bl, l, l2, n, n2, destination);
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Successfully sent message " + message.getJMSMessageID());
        }
        this.updateFlowControl(jMSProducerSendResponse);
    }

    private static MessageImpl convertMessage(Message message) throws JMSException {
        try {
            if (message instanceof BytesMessage) {
                return new BytesMessageImpl((BytesMessage)message);
            }
            if (message instanceof MapMessage) {
                return new MapMessageImpl((MapMessage)message);
            }
            if (message instanceof ObjectMessage) {
                return new ObjectMessageImpl((ObjectMessage)message);
            }
            if (message instanceof StreamMessage) {
                return new StreamMessageImpl((StreamMessage)message);
            }
            if (message instanceof TextMessage) {
                return new TextMessageImpl((TextMessage)message);
            }
            return new HdrMessageImpl(message);
        }
        catch (IOException iOException) {
            throw JMSUtilities.jmsExceptionThrowable(JMSClientExceptionLogger.logErrorConvertingForeignMessageLoggable().getMessage(), iOException);
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.checkClosed();
        this.messageIdsDisabled = bl;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.messageIdsDisabled;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkClosed();
        this.messageTimestampsDisabled = bl;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.messageTimestampsDisabled;
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.checkClosed();
        if (n == 2 || n == 1) {
            this.deliveryMode = n;
        } else if (n == -1) {
            this.deliveryMode = 2;
        } else {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidDeliveryModeLoggable());
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        this.checkClosed();
        if (n >= 0 && n <= 9) {
            this.priority = n;
        } else if (n == -1) {
            this.priority = 4;
        } else {
            throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logInvalidPriorityLoggable());
        }
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public long getTimeToDeliver() throws JMSException {
        this.checkClosed();
        return this.getTimeToDeliverInternal();
    }

    private long getTimeToDeliverInternal() {
        return this.timeToDeliver == -1L ? this.session.getConnection().getTimeToDeliver() : this.timeToDeliver;
    }

    public void setTimeToDeliver(long l) throws JMSException {
        this.checkClosed();
        if (l < -1L) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidTimeToDeliverLoggable().getMessage());
        }
        this.timeToDeliver = l;
    }

    public int getRedeliveryLimit() throws JMSException {
        this.checkClosed();
        return this.redeliveryLimit;
    }

    public void setRedeliveryLimit(int n) throws JMSException {
        this.checkClosed();
        if (n < -1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimitLoggable().getMessage());
        }
        this.redeliveryLimit = n;
    }

    public long getSendTimeout() throws JMSException {
        this.checkClosed();
        return this.sendTimeout;
    }

    public void setSendTimeout(long l) throws JMSException {
        this.checkClosed();
        if (l < 0L) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidSendTimeoutLoggable().getMessage());
        }
        this.sendTimeout = l;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkClosed();
        this.timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        JMSID jMSID;
        JMSProducer jMSProducer = this;
        synchronized (jMSProducer) {
            JMSProducer jMSProducer2;
            if (this.isClosed()) {
                return;
            }
            JMSProducer jMSProducer3 = jMSProducer2 = this.wlProducerImpl == null ? this : this.wlProducerImpl.getConnectionStateLock();
            synchronized (jMSProducer3) {
                jMSID = this.producerId;
                this.producerId = null;
            }
        }
        this.session.producerClose(jMSID);
    }

    boolean hasTemporaryDestination() {
        DestinationImpl destinationImpl = this.destination;
        return destinationImpl != null && (destinationImpl.getType() == 4 || destinationImpl.getType() == 8);
    }

    JMSSession getSession() {
        return this.session;
    }

    public String toString() {
        return this.session.getConnection().getRuntimeMBeanName() + "." + this.session.getRuntimeMBeanName() + "." + this.getRuntimeMBeanName();
    }

    private void checkClosed() throws JMSException {
        if (this.isClosed()) {
            JMSProducer jMSProducer;
            JMSProducer jMSProducer2 = jMSProducer = this.wlProducerImpl == null ? this : this.wlProducerImpl.getConnectionStateLock();
            synchronized (jMSProducer2) {
                if (this.isReconnectControllerClosed()) {
                    throw new AlreadyClosedException(JMSClientExceptionLogger.logClosedProducerLoggable());
                }
                throw new LostServerException(JMSClientExceptionLogger.logLostServerConnectionLoggable());
            }
        }
    }

    public final void publicCheckClosed() throws JMSException {
        this.checkClosed();
    }

    public int invoke(Request request) {
        return Integer.MAX_VALUE;
    }

    public void setUnitOfOrder(String string) throws JMSException {
        this.checkClosed();
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        this.unitOfOrderName = string;
    }

    public void setUnitOfOrder() throws JMSException {
        this.setUnitOfOrder(this.session.getJMSID().toString());
    }

    public String getUnitOfOrder() throws JMSException {
        this.checkClosed();
        return this.unitOfOrderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object toFEProducer(Destination destination, Message message, MessageImpl messageImpl, int n, long l, int n2, long l2, boolean bl, CompletionListener completionListener) throws JMSException {
        Object object;
        block32: {
            Object var20_27;
            block31: {
                int n3;
                JMSDispatcher jMSDispatcher = this.session.getConnection().getFrontEndDispatcher();
                if (ONEWAYSENDENABLED) {
                    this.oneWaySendMode = oneWaySendModeConf;
                    this.oneWayWindowSize = oneWayWindowSizeConf;
                }
                boolean bl2 = (this.oneWaySendMode == 1 || this.oneWaySendMode == 2 && ((DestinationImpl)destination).isTopic()) && !(destination instanceof DistributedDestinationImpl) && this.getUnitOfOrder() == null && messageImpl.getJMSDeliveryMode() == 1 && !((DestinationImpl)destination).isStale();
                bl2 = bl2 && ((DestinationImpl)destination).getDispatcherId().isSameServer(jMSDispatcher.getId());
                JMSProducerSendResponse jMSProducerSendResponse = null;
                boolean bl3 = false;
                FEProducerSendRequest fEProducerSendRequest = new FEProducerSendRequest(this.producerId, messageImpl, this.destination == null ? (DestinationImpl)destination : null, this.sendTimeout, this.compressionThreshold, completionListener, this, message, n, l, n2, l2, bl);
                if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                    JMSDebug.JMSMessagePath.debug("CLIENT/JMSProducer (id: " + this.producerId + ") : " + "Dispatching message to FRONTEND/FEProducer" + " for destination: " + destination);
                }
                if (!this.session.isTransacted() && this.session.userTransactionsEnabled()) {
                    n3 = completionListener == null ? 0 : 4;
                } else if (this.session.isTransacted() || !bl2) {
                    if (this.session.isTransacted()) {
                        this.session.setPendingWork(true);
                    }
                    n3 = completionListener == null ? 1 : 5;
                } else {
                    boolean bl4 = this.flowControlEnabled;
                    if (bl4) {
                        this.flowControlEnabled = false;
                    }
                    if (this.count == Integer.MAX_VALUE) {
                        this.count = 0;
                    }
                    if (++this.count % this.oneWayWindowSize == 1 || this.oneWayWindowSize <= 1 || this.totalConsecutiveOneWaySendMessageSize > ONEWAYSENDCONSECUTIVEMESSAGELIMIT) {
                        this.totalConsecutiveOneWaySendMessageSize = 0;
                        n3 = completionListener == null ? 2 : 5;
                    } else {
                        object = messageImpl.getId();
                        boolean bl5 = bl3 = object != null;
                        if (object == null) {
                            object = JMSMessageId.create();
                        }
                        jMSProducerSendResponse = new JMSProducerSendResponse((JMSMessageId)object);
                        jMSProducerSendResponse.set90StyleMessageId();
                        jMSProducerSendResponse.setDeliveryMode(1);
                        jMSProducerSendResponse.setPriority(n2);
                        jMSProducerSendResponse.setTimeToLive(l2);
                        jMSProducerSendResponse.setTimeToDeliver(l);
                        jMSProducerSendResponse.setMessage(messageImpl);
                        jMSProducerSendResponse.setRequest(fEProducerSendRequest);
                        fEProducerSendRequest.setNoResponse(true);
                        messageImpl.setId((JMSMessageId)object);
                        if (messageImpl.getDeliveryTime() > 0L) {
                            jMSProducerSendResponse.setTimeToDeliver(messageImpl.getDeliveryTime());
                        }
                        n3 = 3;
                    }
                }
                messageImpl.setSerializeDestination(false);
                try {
                    try {
                        Response response;
                        switch (n3) {
                            case 0: {
                                response = jMSDispatcher.dispatchSyncTran(fEProducerSendRequest);
                                break;
                            }
                            case 1: {
                                response = jMSDispatcher.dispatchSyncNoTran(fEProducerSendRequest);
                                break;
                            }
                            case 2: {
                                response = jMSDispatcher.dispatchSyncNoTranWithId(fEProducerSendRequest, this.getJMSID().getCounter());
                                break;
                            }
                            case 3: {
                                fEProducerSendRequest.setResult(jMSProducerSendResponse);
                                jMSDispatcher.dispatchNoReplyWithId(fEProducerSendRequest, this.getJMSID().getCounter());
                                this.totalConsecutiveOneWaySendMessageSize += fEProducerSendRequest.getDataLen();
                                response = jMSProducerSendResponse;
                                break;
                            }
                            case 4: {
                                jMSDispatcher.dispatchAsync(fEProducerSendRequest);
                                object = null;
                                Object var23_20 = null;
                                messageImpl.setSerializeDestination(true);
                                return object;
                            }
                            case 5: {
                                object = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
                                try {
                                    jMSDispatcher.dispatchAsync(fEProducerSendRequest);
                                    Object var21_24 = null;
                                    if (object != null) {
                                        TransactionHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)object);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var21_25 = null;
                                    if (object == null) throw throwable;
                                    TransactionHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)object);
                                    throw throwable;
                                }
                                var20_27 = null;
                                break block31;
                            }
                            default: {
                                response = null;
                            }
                        }
                        this.wrappedSendReturn((JMSProducerSendResponse)response, destination, message, messageImpl, n, l, n2, l2, bl);
                        if (completionListener != null) {
                            fEProducerSendRequest.onCompletion(response);
                        }
                        object = response;
                        break block32;
                    }
                    catch (Exception exception) {
                        if (n3 == 3 && !bl3) {
                            messageImpl.setId(null);
                        }
                        if (!(exception instanceof JMSException)) throw new weblogic.jms.common.JMSException(JMSClientExceptionLogger.logErrorSendingMessageLoggable(), (Throwable)exception);
                        throw (JMSException)exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var23_23 = null;
                    messageImpl.setSerializeDestination(true);
                    throw throwable;
                }
            }
            Object var23_21 = null;
            messageImpl.setSerializeDestination(true);
            return var20_27;
        }
        Object var23_22 = null;
        messageImpl.setSerializeDestination(true);
        return object;
    }

    public void completeAsyncSend(Object object, FEProducerSendRequest fEProducerSendRequest, DestinationImpl destinationImpl, Message message, MessageImpl messageImpl, int n, long l, int n2, long l2, boolean bl, CompletionListener completionListener) {
        JMSProducerSendResponse jMSProducerSendResponse;
        try {
            fEProducerSendRequest.getMessage().setSerializeDestination(true);
            jMSProducerSendResponse = (JMSProducerSendResponse)object;
            this.wrappedSendReturn(jMSProducerSendResponse, destinationImpl, message, messageImpl, n, l, n2, l2, bl);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
            return;
        }
        jMSProducerSendResponse.setMessage(message);
        jMSProducerSendResponse.setAsyncFlowControlTime(this.asyncSendFlowControlTime);
        completionListener.onCompletion(jMSProducerSendResponse);
    }

    public void forward(Destination destination, Message message) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.forwardInternal(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void forward(Message message) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.forwardInternal(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void forward(Message message, int n, int n2, long l) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logNeedDestinationLoggable().getMessage());
        }
        this.forwardInternal(this.destination, message, n, n2, l);
    }

    public void forward(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestination2Loggable().getMessage());
        }
        this.forwardInternal(destination, message, n, n2, l);
    }

    private final void updateFlowControl(JMSProducerSendResponse jMSProducerSendResponse) {
        if (!this.flowControlEnabled || jMSProducerSendResponse == null) {
            return;
        }
        if (jMSProducerSendResponse.getNeedsFlowControl()) {
            this.needsFlowControl = true;
            if (jMSProducerSendResponse.getFlowControlTime() == -1L) {
                if (this.flowRateCurrent > (double)this.flowMaximum) {
                    this.flowRateCurrent = this.flowMaximum;
                }
                if (this.currentTime - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent > (double)this.flowMinimum) {
                    this.flowRateCurrent *= this.flowDecrease;
                    if (this.flowRateCurrent < (double)this.flowMinimum) {
                        this.flowRateCurrent = this.flowMinimum;
                    }
                    this.lastTimeChanged = this.currentTime;
                    this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
                }
            } else {
                this.backOffTime = jMSProducerSendResponse.getFlowControlTime();
            }
            this.lastTimeLeave = this.currentTime;
        } else {
            this.needsFlowControl = false;
            if (this.currentTime - this.lastTimeChanged >= this.flowInterval && this.flowRateCurrent < (double)this.flowMaximum) {
                this.flowRateCurrent += (double)this.flowIncrease;
                this.lastTimeChanged = this.currentTime;
                this.backOffTime = (long)(1000.0 / this.flowRateCurrent);
            }
        }
    }

    private final void doFlowControl() {
        long l = this.getFlowControlSleepTime();
        if (l == 0L) {
            return;
        }
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final long getFlowControlSleepTime() {
        if (!this.flowControlEnabled) {
            return 0L;
        }
        this.currentTime = System.currentTimeMillis();
        this.elapsedTime = this.currentTime - this.lastTimeLeave;
        long l = 0L;
        if (this.flowControlEnabled && (this.needsFlowControl || this.flowRateCurrent <= (double)this.flowMaximum) && this.elapsedTime <= this.backOffTime) {
            l = this.backOffTime - this.elapsedTime;
            this.currentTime = System.currentTimeMillis() + l;
        }
        return l;
    }

    public void setSequence(String string) throws JMSException {
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        this.sequenceName = string;
    }

    public String getSequence() throws JMSException {
        return this.sequenceName;
    }

    public void reserveUnitOfOrderWithSequence() throws JMSException {
        this.processSequenceInternal(196608, this.destination, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void reserveSequence(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        this.processSequenceInternal(196608, destination, n, n2, l);
    }

    public void releaseSequenceAndUnitOfOrder(boolean bl) throws JMSException {
        int n = bl ? 65536 : 131072;
        this.processSequenceInternal(n, this.destination, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void releaseSequenceAndUnitOfOrder(Destination destination, Message message, int n, int n2, long l, boolean bl) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logCannotOverrideDestinationLoggable().getMessage());
        }
        int n3 = bl ? 65536 : 131072;
        this.processSequenceInternal(n3, destination, n, n2, l);
    }

    private void processSequenceInternal(int n, Destination destination, int n2, int n3, long l) throws JMSException {
        if (this.peerInfo.getMajor() < 9) {
            throw new UnsupportedOperationException(JMSClientExceptionLogger.logUnsupportedLoggable().getMessage());
        }
        if (this.sequenceName == null) {
            throw new UnsupportedOperationException("null sequence not permitted");
        }
        HdrMessageImpl hdrMessageImpl = new HdrMessageImpl();
        hdrMessageImpl.setSAFSequenceName(this.sequenceName);
        hdrMessageImpl.setControlOpcode(n);
        this.deliveryInternal(destination, hdrMessageImpl, n2, n3, l, false, null);
    }

    void setWlProducerImpl(WLProducerImpl wLProducerImpl) {
        this.wlProducerImpl = wLProducerImpl;
    }

    void setDestinationFlags(byte by) {
        this.destinationFlags = by;
    }

    public void sendAsync(Message message, CompletionListener completionListener) {
        try {
            this.sendWithListener(completionListener, message);
        }
        catch (JMSException jMSException) {
            completionListener.onException(jMSException);
        }
    }

    public void sendAsync(Message message, int n, int n2, long l, CompletionListener completionListener) {
        try {
            this.sendWithListener(completionListener, message, n, n2, l);
        }
        catch (JMSException jMSException) {
            completionListener.onException(jMSException);
        }
    }

    public void sendAsync(Destination destination, Message message, CompletionListener completionListener) {
        try {
            this.sendWithListener(completionListener, destination, message);
        }
        catch (JMSException jMSException) {
            completionListener.onException(jMSException);
        }
    }

    public void sendAsync(Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) {
        try {
            this.sendWithListener(completionListener, destination, message, n, n2, l);
        }
        catch (JMSException jMSException) {
            completionListener.onException(jMSException);
        }
    }

    static {
        try {
            if (System.getProperty("weblogic.jms.client.onewaysendconfigs") != null) {
                ONEWAYSENDENABLED = true;
                String string = System.getProperty("weblogic.jms.client.onewaysendconfigs");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.hasMoreTokens()) {
                    oneWaySendModeConf = JMSConnection.convertOneWaySendMode(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    oneWayWindowSizeConf = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    ONEWAYSENDCONSECUTIVEMESSAGELIMIT = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

