/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.naming.Context;
import javax.transaction.xa.XAResource;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.Reconnectable;
import weblogic.jms.client.XASessionInternal;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public final class JMSXASession
extends JMSSession
implements XASessionInternal,
Reconnectable,
Cloneable {
    private static final String TX_HELPER_CLASS = "weblogic.transaction.TxHelper";
    private final boolean originalTransacted;

    protected JMSXASession(JMSConnection jMSConnection, boolean bl, boolean bl2) throws JMSException {
        super(jMSConnection, false, 2, bl2);
        this.setUserTransactionsEnabled(true);
        this.originalTransacted = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.originalTransacted;
    }

    public void commit() throws JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new weblogic.jms.common.IllegalStateException(JMSClientExceptionLogger.logNoTransactionLoggable());
        }
        throw new TransactionInProgressException(JMSClientExceptionLogger.logErrorCommittingSessionLoggable().getMessage());
    }

    public void rollback() throws JMSException {
        if (TransactionHelper.getTransactionHelper().getTransaction() == null) {
            throw new weblogic.jms.common.IllegalStateException(JMSClientExceptionLogger.logNoTransaction2Loggable());
        }
        throw new TransactionInProgressException(JMSClientExceptionLogger.logErrorRollingBackSessionLoggable().getMessage());
    }

    public XAResource getXAResource() {
        if (!KernelStatus.isServer()) {
            throw new IllegalStateException(JMSClientExceptionLogger.logOnlyFromServerLoggable().getMessage());
        }
        try {
            Class<?> clazz = Class.forName(TX_HELPER_CLASS);
            Method method = clazz.getMethod("getServerInterposedTransactionManager", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object == null) {
                return null;
            }
            method = object.getClass().getMethod("getXAResource", new Class[0]);
            return (XAResource)method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public XAResource getXAResource(Context context, String string) {
        try {
            Class<?> clazz = Class.forName(TX_HELPER_CLASS);
            Method method = clazz.getMethod("getClientInterposedTransactionManager", Context.class, String.class);
            Object object = method.invoke(null, context, string);
            if (object == null) {
                return null;
            }
            method = object.getClass().getMethod("getXAResource", new Class[0]);
            return (XAResource)method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public QueueSession getQueueSession() {
        return (QueueSession)this.getSession();
    }

    public TopicSession getTopicSession() {
        return (TopicSession)this.getSession();
    }

    public Session getSession() {
        return this;
    }
}

