/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.util.Enumeration;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSContext;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.extensions.WLConnection;

public class WLConnectionImpl
extends ReconnectController
implements ConnectionInternal {
    private final Object reconnectLock = new Object();
    private JMSConnectionFactory jmsConnectionFactory;
    private int reconnectPolicy;
    private long reconnectBlockingMillis;
    private long totalReconnectPeriodMillis;
    private long lastReconnectTimer;
    private long firstReconnectTime;
    private JMSContext connectionEstablishContext;

    public WLConnectionImpl(JMSConnectionFactory jMSConnectionFactory, JMSConnection jMSConnection) {
        super(null, jMSConnection);
        this.jmsConnectionFactory = jMSConnectionFactory;
        this.connectionEstablishContext = new JMSContext();
    }

    protected ReconnectController getParent() {
        return this;
    }

    protected WLConnectionImpl getWLConnectionImpl() {
        return this;
    }

    protected JMSConnectionFactory getJmsConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    protected JMSConnection getPhysicalJMSConnection() {
        return (JMSConnection)this.getPhysical();
    }

    Object getConnectionStateLock() {
        return this.reconnectLock;
    }

    protected JMSContext getConnectionEstablishContext() {
        return this.connectionEstablishContext;
    }

    void setConnectionEstablishContext(JMSContext jMSContext) {
        this.connectionEstablishContext = jMSContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsumerReconnectInfo computeConsumerReconnectInfo() {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            int n = 11;
            if (this.mergeCloseAndReconnect(n) == 0) {
                return null;
            }
        }
        object = new ConsumerReconnectInfo();
        ((ConsumerReconnectInfo)object).setClientDispatcherId(JMSDispatcherManager.getLocalDispatcher().getId());
        ((ConsumerReconnectInfo)object).setClientJMSID(JMSID.create());
        ((ConsumerReconnectInfo)object).setDelayServerClose(90000L);
        return object;
    }

    int mergeCloseAndReconnect(int n) {
        int n2 = this.getState();
        if (n2 != -1280 && n2 != -2304 && WLConnectionImpl.reconnectPolicyHas(n, this.getReconnectPolicyInternal())) {
            return this.getReconnectPolicyInternal();
        }
        return 0;
    }

    static boolean reconnectPolicyHas(int n, int n2) {
        return (n & n2) == n && n != 0;
    }

    boolean rememberReconnectState(JMSConnection jMSConnection, int n) {
        if (this.getPhysical() != jMSConnection) {
            return false;
        }
        int n2 = this.getState();
        if (0 == n2 || 1028 == n2) {
            String string;
            this.jmsConnectionFactory = this.jmsConnectionFactory;
            boolean bl = jMSConnection.getClientIDInternal() == null;
            int n3 = bl ? 1 : 9;
            int n4 = this.mergeCloseAndReconnect(n3);
            if (n4 == 0) {
                string = this.getLastProblem() == null ? this.missingBits(n4, n3) : null;
            } else if (jMSConnection.hasTemporaryDestination()) {
                n4 = 0;
                string = "connection used temporary destinations";
            } else {
                string = null;
            }
            if (n4 != 0 && jMSConnection.getPreDisconnectState() == null) {
                try {
                    jMSConnection.getReconnectState(n4);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    jMSConnection.recurseSetNoRetry(this);
                    throw new AssertionError((Object)cloneNotSupportedException);
                }
                this.setRecursiveStateNotify(n);
                return true;
            }
            if (this.getLastProblem() == null) {
                this.setLastProblem(new JMSException(string));
            }
        }
        jMSConnection.setPreDisconnectState(null);
        jMSConnection.recurseSetNoRetry(this);
        return false;
    }

    String missingBits(int n, int n2) {
        String string = "";
        String string2 = "Cannot reconnect, missing";
        if ((1 & n2) > (1 & n)) {
            string2 = string2 + string + " ConnectionReconnect";
            string = ", and";
        }
        if ((2 & n2) > (2 & n)) {
            string2 = string2 + string + " SessionReconnect";
            string = ", and";
        }
        if ((8 & n2) > (8 & n)) {
            string2 = string2 + string + " ConsumerReconnect";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processReconnectTimer(JMSConnection jMSConnection) {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            jMSConnection.clearTimerInfo();
            String string = this.getPhysical() != jMSConnection ? "WLConnectionImpl Debug ignoring reconnect, match " + this.getPhysical() + " !=" + jMSConnection : (this.getState() != 1280 && this.getState() != 512 ? "WLConnectionImpl Debug ignoring reconnect, state " + this.getStringState(this.getState()) : (jMSConnection.getPreDisconnectState() == null ? "null predisconnect state in " + this.getStringState(this.getState()) : null));
            if (string != null) {
                if (TODOREMOVEDebug) {
                    System.err.println(string);
                }
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug(string);
                }
                return;
            }
            this.setupReconnectSchedule(this.getPhysicalJMSConnection(), 1536);
        }
        jMSConnection.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectComplete(JMSConnection jMSConnection, JMSConnection jMSConnection2, Throwable throwable) {
        try {
            Object object = this.getConnectionStateLock();
            synchronized (object) {
                if (jMSConnection == this.getPhysical()) {
                    try {
                        int n = this.getState();
                        switch (n) {
                            case -2304: 
                            case -1280: 
                            case 0: 
                            case 512: 
                            case 1028: 
                            case 1040: 
                            case 1280: {
                                break;
                            }
                            case 1536: {
                                this.setLastProblem(throwable);
                                if (throwable == null && jMSConnection2 != null) {
                                    jMSConnection.postCreateReplacement();
                                    jMSConnection2.copyExceptionContext(jMSConnection);
                                    jMSConnection2 = null;
                                    this.setRecursiveStateNotify(0);
                                    break;
                                }
                                if (jMSConnection2 != this.getPhysical()) break;
                                jMSConnection2 = null;
                                break;
                            }
                            default: {
                                this.wrongState(n);
                            }
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var7_7 = null;
                        if (this.getState() == 1536) {
                            this.setRecursiveStateNotify(512);
                            jMSConnection.scheduleReconnectTimer();
                        }
                        throw throwable2;
                    }
                    if (this.getState() == 1536) {
                        this.setRecursiveStateNotify(512);
                        jMSConnection.scheduleReconnectTimer();
                    }
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable3) {
            Object var10_11 = null;
            try {
                if (jMSConnection2 != null) {
                    jMSConnection2.close();
                }
            }
            catch (javax.jms.JMSException jMSException) {
                // empty catch block
            }
            throw throwable3;
        }
        try {
            if (jMSConnection2 != null) {
                jMSConnection2.close();
            }
        }
        catch (javax.jms.JMSException jMSException) {}
    }

    private JMSConnection getJMSConnection() {
        return (JMSConnection)this.getPhysicalWaitForState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconnectPolicy(String string) throws IllegalArgumentException {
        int n = WLConnectionImpl.validateAndConvertReconnectPolicy(string);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.reconnectPolicy = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReconnectPolicy() {
        int n;
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            n = this.getReconnectPolicyInternal();
        }
        return WLConnectionImpl.convertReconnectPolicy(n);
    }

    int getReconnectPolicyInternal() {
        return this.reconnectPolicy;
    }

    public static int validateAndConvertReconnectPolicy(String string) throws IllegalArgumentException {
        if (JMSConstants.RECONNECT_POLICY_NONE.equals(string)) {
            return 0;
        }
        if (!JMSConnection.isT3Client()) {
            throw new IllegalArgumentException("only t3 client supports reconnect");
        }
        if (JMSConstants.RECONNECT_POLICY_PRODUCER.equals(string)) {
            return 7;
        }
        if (JMSConstants.RECONNECT_POLICY_ALL.equals(string)) {
            return 15;
        }
        throw new IllegalArgumentException("Unrecognized ReconnectPolicy " + string);
    }

    static String convertReconnectPolicy(int n) throws IllegalArgumentException {
        switch (n) {
            case 7: {
                return JMSConstants.RECONNECT_POLICY_PRODUCER;
            }
            case 0: {
                return JMSConstants.RECONNECT_POLICY_NONE;
            }
            case 15: {
                return JMSConstants.RECONNECT_POLICY_ALL;
            }
        }
        throw new IllegalArgumentException("Unrecognized ReconnectPolicy " + n);
    }

    long getFirstReconnectTime() {
        return this.firstReconnectTime;
    }

    long getLastReconnectTimer() {
        return this.lastReconnectTimer;
    }

    void clearLastReconnectTimer() {
        this.lastReconnectTimer = 0L;
    }

    void updateFirstReconnectTime() {
        this.firstReconnectTime = System.currentTimeMillis();
    }

    void updateLastReconnectTimer() {
        long l = this.getWLConnectionImpl().getTotalReconnectPeriodMillis();
        if (l == -1L) {
            this.lastReconnectTimer = Long.MAX_VALUE;
        } else {
            try {
                this.lastReconnectTimer = System.currentTimeMillis() + l;
            }
            catch (RuntimeException runtimeException) {
                this.lastReconnectTimer = Long.MAX_VALUE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconnectBlockingMillis(long l) throws IllegalArgumentException {
        WLConnectionImpl.validateReconnectMillis(l);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.reconnectBlockingMillis = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReconnectBlockingMillis() {
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            return this.getReconnectBlockingInternal();
        }
    }

    long getReconnectBlockingInternal() {
        return this.reconnectBlockingMillis;
    }

    public static void validateReconnectMillis(long l) throws IllegalArgumentException {
        if (l < -1L) {
            throw new IllegalArgumentException("values less than -1 (infinite blocking time) are illegal");
        }
    }

    public long getTotalReconnectPeriodMillis() {
        return this.totalReconnectPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalReconnectPeriodMillis(long l) {
        WLConnectionImpl.validateReconnectMillis(l);
        Object object = this.getConnectionStateLock();
        synchronized (object) {
            this.totalReconnectPeriodMillis = l;
        }
    }

    public final JMSDispatcher getFrontEndDispatcher() throws javax.jms.JMSException {
        return this.getJMSConnection().getFrontEndDispatcher();
    }

    public JMSID getJMSID() {
        return this.getJMSConnection().getJMSID();
    }

    public PeerInfo getFEPeerInfo() {
        return this.getJMSConnection().getFEPeerInfo();
    }

    public final void setAllowCloseInOnMessage(boolean bl) {
        this.getJMSConnection().setAllowCloseInOnMessage(bl);
    }

    public final boolean getUserTransactionsEnabled() {
        return this.getJMSConnection().getUserTransactionsEnabled();
    }

    public boolean isXAServerEnabled() {
        return this.getJMSConnection().isXAServerEnabled();
    }

    public String getWLSServerName() {
        return this.getJMSConnection().getWLSServerName();
    }

    public String getRuntimeMBeanName() {
        return this.getJMSConnection().getRuntimeMBeanName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return this.getJMSConnection().getParentInfo();
    }

    public void setDispatchPolicy(String string) {
        this.getJMSConnection().setDispatchPolicy(string);
    }

    public void setAcknowledgePolicy(int n) {
        this.getJMSConnection().setAcknowledgePolicy(n);
    }

    public int getAcknowledgePolicy() {
        return this.getJMSConnection().getAcknowledgePolicy();
    }

    public String getJMSVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getJMSVersion();
    }

    public int getJMSMajorVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getJMSMajorVersion();
    }

    public int getJMSMinorVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getJMSMinorVersion();
    }

    public String getJMSProviderName() throws javax.jms.JMSException {
        return this.getJMSConnection().getJMSProviderName();
    }

    public String getProviderVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getProviderVersion();
    }

    public int getProviderMajorVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getProviderMajorVersion();
    }

    public int getProviderMinorVersion() throws javax.jms.JMSException {
        return this.getJMSConnection().getProviderMinorVersion();
    }

    public Enumeration getJMSXPropertyNames() throws javax.jms.JMSException {
        return this.getJMSConnection().getJMSXPropertyNames();
    }

    public Session createSession(boolean bl, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createSession(bl, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createSession(bl, n);
        }
    }

    public String getClientID() throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.getClientID();
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).getClientID();
        }
    }

    public static int validateAndConvertClientIdPolicy(String string) throws IllegalArgumentException {
        if (WLConnection.CLIENT_ID_POLICY_RESTRICTED.equals(string)) {
            return 0;
        }
        if (WLConnection.CLIENT_ID_POLICY_UNRESTRICTED.equals(string)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized clientIdPolicy " + string);
    }

    public static String convertClientIdPolicy(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return WLConnection.CLIENT_ID_POLICY_RESTRICTED;
            }
            case 1: {
                return WLConnection.CLIENT_ID_POLICY_UNRESTRICTED;
            }
        }
        throw new IllegalArgumentException("Unrecognized clientIdPolicy " + n);
    }

    public String getClientIDPolicy() {
        return this.getJMSConnection().getClientIDPolicy();
    }

    public void setClientID(String string, String string2) throws javax.jms.JMSException, IllegalArgumentException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        if (this.getFEPeerInfo().compareTo(PeerInfo.VERSION_1033) < 0) {
            throw new javax.jms.JMSException("Unsupported Operation. Only " + PeerInfo.VERSION_1033.getVersionAsString() + " and later supports this feature");
        }
        try {
            jMSConnection.setClientID(string, string2);
        }
        catch (JMSException jMSException) {
            this.computeJMSConnection(l, jMSConnection, jMSException).setClientID(string, string2);
        }
    }

    public void setClientID(String string) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            jMSConnection.setClientID(string);
        }
        catch (JMSException jMSException) {
            this.computeJMSConnection(l, jMSConnection, jMSException).setClientID(string);
        }
    }

    public String getSubscriptionSharingPolicy() {
        return this.getJMSConnection().getSubscriptionSharingPolicy();
    }

    public void setSubscriptionSharingPolicy(String string) throws javax.jms.JMSException, IllegalArgumentException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        if (this.getFEPeerInfo().compareTo(PeerInfo.VERSION_1033) < 0) {
            throw new javax.jms.JMSException("Unsupported Operation. Only " + PeerInfo.VERSION_1033.getVersionAsString() + " and later supports this feature");
        }
        try {
            jMSConnection.setSubscriptionSharingPolicy(string);
        }
        catch (JMSException jMSException) {
            this.computeJMSConnection(l, jMSConnection, jMSException).setSubscriptionSharingPolicy(string);
        }
    }

    public static int getSubscriptionSharingPolicyAsInt(String string) {
        if (string.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE)) {
            return 0;
        }
        if (string.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + string);
    }

    public static String getSubscriptionSharingPolicyAsString(int n) {
        switch (n) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + n);
    }

    public ConnectionMetaData getMetaData() throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.getMetaData();
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).getMetaData();
        }
    }

    public ExceptionListener getExceptionListener() throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.getExceptionListener();
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).getExceptionListener();
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            jMSConnection.setExceptionListener(exceptionListener);
        }
        catch (JMSException jMSException) {
            this.computeJMSConnection(l, jMSConnection, jMSException).setExceptionListener(exceptionListener);
        }
    }

    public void start() throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            jMSConnection.start();
        }
        catch (JMSException jMSException) {
            this.computeJMSConnection(l, jMSConnection, jMSException).start();
        }
    }

    public void stop() throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            jMSConnection.stop();
        }
        catch (JMSException jMSException) {
            if (jMSConnection.isConnected()) {
                this.computeJMSConnection(l, jMSConnection, jMSException).stop();
            }
            throw jMSException;
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createConnectionConsumer(destination, string, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createConnectionConsumer(destination, string, serverSessionPool, n);
        }
    }

    public QueueSession createQueueSession(boolean bl, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createQueueSession(bl, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createQueueSession(bl, n);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createConnectionConsumer(queue, string, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createConnectionConsumer(queue, string, serverSessionPool, n);
        }
    }

    public TopicSession createTopicSession(boolean bl, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createTopicSession(bl, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createTopicSession(bl, n);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createConnectionConsumer(topic, string, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createConnectionConsumer(topic, string, serverSessionPool, n);
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws javax.jms.JMSException {
        long l = System.currentTimeMillis();
        JMSConnection jMSConnection = this.getPhysicalJMSConnection();
        try {
            return jMSConnection.createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
        }
        catch (JMSException jMSException) {
            return this.computeJMSConnection(l, jMSConnection, jMSException).createDurableConnectionConsumer(topic, string, string2, serverSessionPool, n);
        }
    }
}

