/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.client.ProducerInternal;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLSessionImpl;
import weblogic.messaging.dispatcher.CompletionListener;

public class WLProducerImpl
extends ReconnectController
implements ProducerInternal {
    private WLSessionImpl parent;

    public WLProducerImpl(JMSProducer jMSProducer, WLSessionImpl wLSessionImpl) {
        super(wLSessionImpl, jMSProducer);
        this.parent = wLSessionImpl;
    }

    protected ReconnectController getParent() {
        return this.parent;
    }

    Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    private JMSProducer getPhysicalJMSProducer() {
        return (JMSProducer)this.getPhysical();
    }

    private JMSProducer checkClosedReconnectGetProducer(long l, JMSProducer jMSProducer) throws JMSException {
        return (JMSProducer)this.checkClosedReconnect(l, jMSProducer);
    }

    private JMSProducer checkClosedReconnectGetProducer() throws JMSException {
        return this.checkClosedReconnectGetProducer(System.currentTimeMillis(), (JMSProducer)this.getPhysical());
    }

    public int getCompressionThreshold() throws JMSException {
        return ((JMSProducer)this.getPhysicalWaitForState()).getCompressionThreshold();
    }

    public String getWLSServerName() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getWLSServerName();
    }

    public String getRuntimeMBeanName() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getRuntimeMBeanName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return ((JMSProducer)this.getPhysicalWaitForState()).getParentInfo();
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        this.send((Destination)queue, message, n, n2, l);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        this.send(message, n, n2, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send(topic, message);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        this.send(topic, message, n, n2, l);
    }

    public void setSequence(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setSequence(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setSequence(string);
        }
    }

    public String getSequence() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getSequence();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getSequence();
        }
    }

    public void reserveUnitOfOrderWithSequence() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.reserveUnitOfOrderWithSequence();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).reserveUnitOfOrderWithSequence();
        }
    }

    public void reserveSequence(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.reserveSequence(destination, message, n, n2, l4);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.reserveSequence(destination, message, n, n2, l);
        }
    }

    public void releaseSequenceAndUnitOfOrder(boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.releaseSequenceAndUnitOfOrder(bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).releaseSequenceAndUnitOfOrder(bl);
        }
    }

    public void releaseSequenceAndUnitOfOrder(Destination destination, Message message, int n, int n2, long l, boolean bl) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.releaseSequenceAndUnitOfOrder(destination, message, n, n2, l4, bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.releaseSequenceAndUnitOfOrder(destination, message, n, n2, l, bl);
        }
    }

    public long getTimeToDeliver() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getTimeToDeliver();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getTimeToDeliver();
        }
    }

    public void setTimeToDeliver(long l) throws JMSException {
        long l2 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setTimeToDeliver(l);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l2, jMSProducer, jMSException).setTimeToDeliver(l);
        }
    }

    public int getRedeliveryLimit() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getRedeliveryLimit();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getRedeliveryLimit();
        }
    }

    public void setRedeliveryLimit(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setRedeliveryLimit(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setRedeliveryLimit(n);
        }
    }

    public long getSendTimeout() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getSendTimeout();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getSendTimeout();
        }
    }

    public void setSendTimeout(long l) throws JMSException {
        long l2 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setSendTimeout(l);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l2, jMSProducer, jMSException).setSendTimeout(l);
        }
    }

    public String getUnitOfOrder() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getUnitOfOrder();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getUnitOfOrder();
        }
    }

    public void setUnitOfOrder(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setUnitOfOrder(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setUnitOfOrder(string);
        }
    }

    public void setUnitOfOrder() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setUnitOfOrder();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setUnitOfOrder();
        }
    }

    public void forward(Message message, int n, int n2, long l) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.forward(message, n, n2, l4);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.forward(message, n, n2, l);
        }
    }

    public void forward(Message message) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.forward(message);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).forward(message);
        }
    }

    public void forward(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.forward(destination, message, n, n2, l4);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.forward(destination, message, n, n2, l);
        }
    }

    public void forward(Destination destination, Message message) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.forward(destination, message);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).forward(destination, message);
        }
    }

    public void setCompressionThreshold(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setCompressionThreshold(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setCompressionThreshold(n);
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setDisableMessageID(bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setDisableMessageID(bl);
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getDisableMessageID();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getDisableMessageID();
        }
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setDisableMessageTimestamp(bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setDisableMessageTimestamp(bl);
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getDisableMessageTimestamp();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getDisableMessageTimestamp();
        }
    }

    public void setDeliveryMode(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setDeliveryMode(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setDeliveryMode(n);
        }
    }

    public int getDeliveryMode() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getDeliveryMode();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getDeliveryMode();
        }
    }

    public void setPriority(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setPriority(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l, jMSProducer, jMSException).setPriority(n);
        }
    }

    public int getPriority() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getPriority();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getPriority();
        }
    }

    public void setTimeToLive(long l) throws JMSException {
        long l2 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.setTimeToLive(l);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.idempotentJMSProducer(l2, jMSProducer, jMSException).setTimeToLive(l);
        }
    }

    public long getTimeToLive() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getTimeToLive();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getTimeToLive();
        }
    }

    public Destination getDestination() throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            return jMSProducer.getDestination();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.idempotentJMSProducer(l, jMSProducer, jMSException).getDestination();
        }
    }

    public void send(Message message) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.send(message);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).send(message);
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.send(message, n, n2, l4);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.send(message, n, n2, l);
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        long l = System.currentTimeMillis();
        JMSProducer jMSProducer = this.checkClosedReconnectGetProducer();
        try {
            jMSProducer.send(destination, message);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.nonIdempotentJMSProducer(l, jMSProducer, jMSException).send(destination, message);
        }
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        long l2;
        long l3 = System.currentTimeMillis();
        JMSProducer jMSProducer = this.getPhysicalJMSProducer();
        JMSProducer jMSProducer2 = this.checkClosedReconnectGetProducer(l3, jMSProducer);
        long l4 = l;
        if (jMSProducer != jMSProducer2 && l > 0L && (l2 = System.currentTimeMillis() - l3) < l) {
            l4 = l - l2;
        }
        try {
            jMSProducer2.send(destination, message, n, n2, l4);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            long l5;
            jMSProducer2 = this.nonIdempotentJMSProducer(l3, jMSProducer2, jMSException);
            if (jMSProducer != jMSProducer2 && l > 0L && (l5 = System.currentTimeMillis() - l3) < l) {
                l -= l5;
            }
            jMSProducer2.send(destination, message, n, n2, l);
        }
    }

    public void sendAsync(Message message, CompletionListener completionListener) {
        this.getPhysicalJMSProducer().sendAsync(message, completionListener);
    }

    public void sendAsync(Message message, int n, int n2, long l, CompletionListener completionListener) {
        this.getPhysicalJMSProducer().sendAsync(message, n, n2, l, completionListener);
    }

    public void sendAsync(Destination destination, Message message, CompletionListener completionListener) {
        this.getPhysicalJMSProducer().sendAsync(destination, message, completionListener);
    }

    public void sendAsync(Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) {
        this.getPhysicalJMSProducer().sendAsync(destination, message, n, n2, l, completionListener);
    }
}

