/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.client;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import org.w3c.dom.Document;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.ClientRuntimeInfo;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSSession;
import weblogic.jms.client.MMessageListener;
import weblogic.jms.client.ReconnectController;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.client.WLProducerImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLAcknowledgeInfo;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.extensions.XMLMessage;
import weblogic.messaging.dispatcher.CompletionListener;

public class WLSessionImpl
extends ReconnectController
implements SessionInternal,
WLAsyncSession {
    private WLConnectionImpl parent;

    public WLSessionImpl(JMSSession jMSSession, WLConnectionImpl wLConnectionImpl) {
        super(wLConnectionImpl, jMSSession);
        this.parent = wLConnectionImpl;
    }

    protected ReconnectController getParent() {
        return this.parent;
    }

    protected Object getConnectionStateLock() {
        return this.parent.getConnectionStateLock();
    }

    protected WLConnectionImpl getWLConnectionImpl() {
        return this.parent.getWLConnectionImpl();
    }

    protected JMSConnection getPhysicalJMSConnection() {
        return this.parent.getPhysicalJMSConnection();
    }

    protected JMSSession getJMSSessionWaitForState() {
        return (JMSSession)this.getPhysicalWaitForState();
    }

    protected JMSSession getPhysicalJMSSession() {
        return (JMSSession)this.getPhysical();
    }

    public void acknowledge() throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.throwForAckRefreshedSessionRules();
        jMSSession.acknowledge();
    }

    public void commit() throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        if (jMSSession.checkRefreshedWithPendingWork()) {
            throw new TransactionRolledBackException(JMSClientExceptionLogger.logLostServerConnectionLoggable().getMessage(), "ReservedRollbackOnly");
        }
        jMSSession.commit();
    }

    public void recover() throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.checkRefreshedWithPendingWork();
        jMSSession.recover();
    }

    public void rollback() throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.checkRefreshedWithPendingWork();
        jMSSession.rollback();
    }

    public void run() {
        this.getPhysicalJMSSession().run();
    }

    public void acknowledge(Message message) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.throwForAckRefreshedSessionRules();
        jMSSession.acknowledge(message);
    }

    public void acknowledge(WLAcknowledgeInfo wLAcknowledgeInfo) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.throwForAckRefreshedSessionRules();
        jMSSession.acknowledge(wLAcknowledgeInfo);
    }

    public long getLastSequenceNumber() {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        return jMSSession.getLastSequenceNumber();
    }

    public void setMMessageListener(MMessageListener mMessageListener) {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.setMMessageListener(mMessageListener);
    }

    public void close(long l) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.close(l);
    }

    public void commit(long l) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.commit(l);
    }

    public int rollback(long l) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.rollback(l);
        return jMSSession.getPipelineGenerationFromProxy();
    }

    public int recover(long l) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.recover(l);
        return jMSSession.getPipelineGenerationFromProxy();
    }

    public void removePendingWTMessage(long l) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.removePendingWTMessage(l, true);
    }

    public int getPipelineGenerationFromProxy() throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        return jMSSession.getPipelineGenerationFromProxy();
    }

    public void acknowledge(Message message, int n, boolean bl) throws JMSException {
        JMSSession jMSSession = this.getPhysicalJMSSession();
        jMSSession.throwForAckRefreshedSessionRules();
        jMSSession.acknowledge((MessageImpl)message, n, bl);
    }

    public void pushMessage(MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        this.getPhysicalJMSSession().pushMessage(messageImpl, jMSPushEntry);
    }

    public void checkSAFClosed() throws JMSException {
        this.getPhysicalJMSSession().checkSAFClosed();
    }

    public int consumersCount() {
        return this.getJMSSessionWaitForState().consumersCount();
    }

    public int producersCount() {
        return this.getJMSSessionWaitForState().producersCount();
    }

    public String getWLSServerName() {
        return this.getJMSSessionWaitForState().getWLSServerName();
    }

    public String getRuntimeMBeanName() {
        return this.getJMSSessionWaitForState().getRuntimeMBeanName();
    }

    public ClientRuntimeInfo getParentInfo() {
        return this.getJMSSessionWaitForState().getParentInfo();
    }

    public JMSID getJMSID() {
        return this.getJMSSessionWaitForState().getJMSID();
    }

    public void setPipelineGeneration(int n) {
        this.getJMSSessionWaitForState().setPipelineGeneration(n);
    }

    public XMLMessage createXMLMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createXMLMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createXMLMessage();
        }
    }

    public XMLMessage createXMLMessage(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createXMLMessage(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createXMLMessage(string);
        }
    }

    public XMLMessage createXMLMessage(Document document) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createXMLMessage(document);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createXMLMessage(document);
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.setExceptionListener(exceptionListener);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).setExceptionListener(exceptionListener);
        }
    }

    public int getMessagesMaximum() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getMessagesMaximum();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getMessagesMaximum();
        }
    }

    public void setMessagesMaximum(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.setMessagesMaximum(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).setMessagesMaximum(n);
        }
    }

    public int getOverrunPolicy() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getOverrunPolicy();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getOverrunPolicy();
        }
    }

    public void setOverrunPolicy(int n) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.setOverrunPolicy(n);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).setOverrunPolicy(n);
        }
    }

    public long getRedeliveryDelay() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getRedeliveryDelay();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getRedeliveryDelay();
        }
    }

    public void setRedeliveryDelay(long l) throws JMSException {
        long l2 = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.setRedeliveryDelay(l);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l2, jMSSession, jMSException).setRedeliveryDelay(l);
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createBytesMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createBytesMessage();
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createMapMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createMapMessage();
        }
    }

    public Message createMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createMessage();
        }
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createObjectMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createObjectMessage();
        }
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createObjectMessage(serializable);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createObjectMessage(serializable);
        }
    }

    public StreamMessage createStreamMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createStreamMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createStreamMessage();
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createTextMessage();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createTextMessage();
        }
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createTextMessage(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createTextMessage(string);
        }
    }

    public boolean getTransacted() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getTransacted();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getTransacted();
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getAcknowledgeMode();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getAcknowledgeMode();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.getMessageListener();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).getMessageListener();
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.setMessageListener(messageListener);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).setMessageListener(messageListener);
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createProducer(destination);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createProducer(destination);
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createConsumer(destination);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createConsumer(destination);
        }
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createConsumer(destination, string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createConsumer(destination, string);
        }
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createConsumer(destination, string, bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createConsumer(destination, string, bl);
        }
    }

    public Queue createQueue(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createQueue(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createQueue(string);
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createReceiver(queue);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createReceiver(queue);
        }
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createReceiver(queue, string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createReceiver(queue, string);
        }
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createSender(queue);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createSender(queue);
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createBrowser(queue);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createBrowser(queue);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createBrowser(queue, string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createBrowser(queue, string);
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createTemporaryQueue();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createTemporaryQueue();
        }
    }

    public Topic createTopic(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createTopic(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createTopic(string);
        }
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createSubscriber(topic);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createSubscriber(topic);
        }
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createSubscriber(topic, string, bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createSubscriber(topic, string, bl);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createDurableSubscriber(topic, string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createDurableSubscriber(topic, string);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createDurableSubscriber(topic, string, string2, bl);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createDurableSubscriber(topic, string, string2, bl);
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createPublisher(topic);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createPublisher(topic);
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            return jMSSession.createTemporaryTopic();
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            return this.computeJMSSession(l, jMSSession, jMSException).createTemporaryTopic();
        }
    }

    public void unsubscribe(String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.unsubscribe(string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).unsubscribe(string);
        }
    }

    public void unsubscribe(Topic topic, String string) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.unsubscribe(topic, string);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).unsubscribe(topic, string);
        }
    }

    public void associateTransaction(Message message) throws JMSException {
        long l = System.currentTimeMillis();
        JMSSession jMSSession = this.getPhysicalJMSSession();
        try {
            jMSSession.associateTransaction(message);
        }
        catch (weblogic.jms.common.JMSException jMSException) {
            this.computeJMSSession(l, jMSSession, jMSException).associateTransaction(message);
        }
    }

    public void acknowledgeAsync(WLAcknowledgeInfo wLAcknowledgeInfo, CompletionListener completionListener) {
        this.getPhysicalJMSSession().acknowledgeAsync(wLAcknowledgeInfo, completionListener);
    }

    public void sendAsync(MessageProducer messageProducer, Message message, CompletionListener completionListener) {
        ((WLProducerImpl)messageProducer).sendAsync(message, completionListener);
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, Message message, int n, int n2, long l, CompletionListener completionListener) {
        ((WLProducerImpl)wLMessageProducer).sendAsync(message, n, n2, l, completionListener);
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, Destination destination, Message message, CompletionListener completionListener) {
        ((WLProducerImpl)wLMessageProducer).sendAsync(destination, message, completionListener);
    }

    public void sendAsync(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) {
        ((WLProducerImpl)wLMessageProducer).sendAsync(destination, message, n, n2, l, completionListener);
    }

    public void receiveAsync(MessageConsumer messageConsumer, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveAsync(completionListener);
    }

    public void receiveAsync(MessageConsumer messageConsumer, long l, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveAsync(l, completionListener);
    }

    public void receiveNoWaitAsync(MessageConsumer messageConsumer, CompletionListener completionListener) {
        ((WLConsumerImpl)messageConsumer).receiveNoWaitAsync(completionListener);
    }
}

