/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.utils.io.DataIO;

public final class BufferDataInputStream
extends BufferInputStream
implements ObjectInput {
    private byte[] buf;
    private int pos;
    private int mark = 0;
    private final int offset;
    private int count;
    private final ObjectIOBypass objectIOBypass;
    private static final int VERSION = 1234;

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
        this.offset = 0;
        this.objectIOBypass = objectIOBypass;
    }

    public BufferDataInputStream(ObjectIOBypass objectIOBypass, byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.offset = n;
        this.objectIOBypass = objectIOBypass;
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public void unput() {
        --this.pos;
    }

    public int size() {
        return this.count;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.offset;
    }

    public int pos() {
        return this.pos;
    }

    void gotoPos(int n) throws IOException {
        this.pos = n;
    }

    public synchronized void close() throws IOException {
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos + n2 > this.count) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = Math.min(this.count - this.pos, n);
        this.pos += n2;
        return n2;
    }

    public final Object readObject() throws IOException, ClassNotFoundException {
        int n = this.readInt();
        if (n != 1234) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logUnknownStreamVersionLoggable(n).getMessage());
        }
        if (this.objectIOBypass == null) {
            throw new StreamCorruptedException(JMSClientExceptionLogger.logRawObjectErrorLoggable().getMessage());
        }
        return this.objectIOBypass.readObject(this);
    }

    public final boolean readBoolean() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] != 0;
    }

    public final byte readByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    public final int readUnsignedByte() throws IOException {
        if (this.pos == this.count) {
            throw new EOFException();
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public final short readShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((short)(this.buf[this.pos] & 0xFF) << 8) + ((short)(this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (short)n;
    }

    public final int readUnsignedShort() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return n;
    }

    public final char readChar() throws IOException {
        if (this.pos + 2 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (char)n;
    }

    final int peekInt(int n) throws IOException {
        int n2 = this.pos + n;
        if (n2 + 4 > this.count) {
            return -42;
        }
        return ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
    }

    public final int readInt() throws IOException {
        if (this.pos + 4 > this.count) {
            throw new EOFException();
        }
        int n = ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
        this.pos += 4;
        return n;
    }

    public final long readLong() throws IOException {
        if (this.pos + 8 > this.count) {
            throw new EOFException();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        throw new IOException(JMSClientExceptionLogger.logNotImplementedLoggable().getMessage());
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final String readUTF32() throws IOException {
        return BufferDataInputStream.readUTF32(this);
    }

    public final String readUTF8() throws IOException {
        return DataIO.readUTF8(this);
    }

    public static String readUTF32(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        block5: while (n2 < n) {
            int n3 = dataInput.readByte() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = dataInput.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = dataInput.readByte();
                    byte by2 = dataInput.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(stringBuffer);
    }
}

