/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CDSListProvider;
import weblogic.jms.common.CDSRouter;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipCancelRequest;
import weblogic.jms.common.DDMembershipPushRequest;
import weblogic.jms.common.DDMembershipRequest;
import weblogic.jms.common.DDMembershipResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.CrossDomainManager;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.work.WorkManagerFactory;

public final class CDSLocalProxy
implements Invocable,
JMSPeerGoneListener,
CDSListProvider {
    private static final CDSLocalProxy singleton;
    private final HashMap listenerDispatcherMap = new HashMap();
    private transient int refCount;

    public static CDSLocalProxy getSingleton() {
        return singleton;
    }

    public void unregisterListener(CDSListListener cDSListListener) {
        WorkManagerFactory.getInstance().getSystem().schedule(new UnregisterListenerThread(cDSListListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLDList(CDSListListener cDSListListener, List list) {
        Object object;
        ListenerDispatcher listenerDispatcher = null;
        Object object2 = list;
        synchronized (object2) {
            object = list.listIterator();
            while (object.hasNext()) {
                listenerDispatcher = (ListenerDispatcher)object.next();
                if (listenerDispatcher.getListener() != cDSListListener) continue;
                object.remove();
                break;
            }
        }
        if (listenerDispatcher == null) {
            return;
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("unregisterListener: " + cDSListListener + ". Removing the correponding DD with JNDI name: " + cDSListListener.getJNDIName());
        }
        object2 = listenerDispatcher.getDispatcher();
        JMSDispatcherManager.exportLocalDispatcher();
        object = JMSDispatcherManager.getLocalDispatcherWrapper();
        DDMembershipCancelRequest dDMembershipCancelRequest = new DDMembershipCancelRequest(cDSListListener.getJNDIName(), (DispatcherWrapper)object);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("unregisterListener: " + cDSListListener + ". sending cancel request to remote side for " + cDSListListener.getJNDIName());
        }
        Exception exception = null;
        try {
            CrossDomainSecurityManager.doAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(cDSListListener), new PrivilegedExceptionAction((JMSDispatcher)object2, dDMembershipCancelRequest){
                final /* synthetic */ JMSDispatcher val$dispatcher;
                final /* synthetic */ DDMembershipCancelRequest val$ddMembershipCancelRequest;
                {
                    this.val$dispatcher = jMSDispatcher;
                    this.val$ddMembershipCancelRequest = dDMembershipCancelRequest;
                }

                public Object run() throws javax.jms.JMSException {
                    this.val$dispatcher.dispatchNoReply(this.val$ddMembershipCancelRequest);
                    return null;
                }
            });
        }
        catch (javax.jms.JMSException jMSException) {
            exception = jMSException;
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (exception != null && JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Exception in dispatching DDMembershipCancelRequest for " + cDSListListener.getJNDIName(), exception);
        }
    }

    public DDMemberInformation[] registerListener(final CDSListListener cDSListListener) throws javax.jms.JMSException {
        Object object;
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("registerListener(): Creating remote dispatcher for " + cDSListListener.getJNDIName());
        }
        Exception exception = null;
        JMSDispatcher jMSDispatcher = null;
        javax.jms.JMSException jMSException = null;
        try {
            object = cDSListListener.getContext();
            jMSDispatcher = (JMSDispatcher)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(cDSListListener), new PrivilegedExceptionAction((Context)object){
                final /* synthetic */ Context val$listenerCtx;
                {
                    this.val$listenerCtx = context;
                }

                public Object run() throws javax.jms.JMSException {
                    return CDSLocalProxy.this.getRemoteDispatcher(cDSListListener, this.val$listenerCtx);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
            if (exception instanceof javax.jms.JMSException) {
                jMSException = (javax.jms.JMSException)exception;
            }
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (jMSException != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in getting remote dispatcher for registeration of DDMembership change for " + cDSListListener.getJNDIName(), jMSException);
            }
            throw jMSException;
        }
        if (exception != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Failed to get the remote dispatcher for " + cDSListListener.getJNDIName(), exception);
            }
            throw new JMSException(exception.getMessage(), (Throwable)exception);
        }
        object = new ListenerDispatcher(cDSListListener, jMSDispatcher);
        JMSDispatcherManager.exportLocalDispatcher();
        DispatcherWrapper dispatcherWrapper = JMSDispatcherManager.getLocalDispatcherWrapper();
        final DDMembershipRequest dDMembershipRequest = new DDMembershipRequest(cDSListListener.getDistributedDestinationImpl().getName(), cDSListListener.getJNDIName(), dispatcherWrapper);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("registerListener(): Creating remote dispatcher for " + cDSListListener.getJNDIName());
        }
        DDMembershipResponse dDMembershipResponse = null;
        final JMSDispatcher jMSDispatcher2 = jMSDispatcher;
        try {
            dDMembershipResponse = (DDMembershipResponse)CrossDomainSecurityManager.runAs(CrossDomainSecurityManager.getCrossDomainSecurityUtil().getSubjectFromListener(cDSListListener), new PrivilegedExceptionAction(){

                public Object run() throws javax.jms.JMSException {
                    return jMSDispatcher2.dispatchSyncNoTran(dDMembershipRequest);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            exception = privilegedActionException.getException();
        }
        catch (NamingException namingException) {
            exception = namingException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (exception != null) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in registering listener for " + cDSListListener.getJNDIName(), exception);
            }
            throw new JMSException(exception);
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDD(): Got back the DDMembershipResponse with " + dDMembershipResponse.getDDMemberInformation());
        }
        this.addToLDMapList((ListenerDispatcher)object);
        return dDMembershipResponse.getDDMemberInformation();
    }

    private synchronized List getLDList(String string) {
        return (List)this.listenerDispatcherMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLDMapList(ListenerDispatcher listenerDispatcher) {
        String string = listenerDispatcher.getListener().getJNDIName();
        CDSLocalProxy cDSLocalProxy = this;
        synchronized (cDSLocalProxy) {
            LinkedList<ListenerDispatcher> linkedList = (LinkedList<ListenerDispatcher>)this.listenerDispatcherMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<ListenerDispatcher>();
                this.listenerDispatcherMap.put(string, linkedList);
            }
            LinkedList<ListenerDispatcher> linkedList2 = linkedList;
            synchronized (linkedList2) {
                linkedList.add(listenerDispatcher);
            }
        }
    }

    private JMSDispatcher getRemoteDispatcher(CDSListListener cDSListListener, Context context) throws javax.jms.JMSException {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.getRemoteDispatcher is called. id = " + cDSListListener.getDistributedDestinationImpl().getDispatcherId().getDetail());
        }
        try {
            JMSDispatcher jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(context, cDSListListener.getDistributedDestinationImpl().getDispatcherId());
            jMSDispatcher.addDispatcherPeerGoneListener(this);
            return jMSDispatcher;
        }
        catch (DispatcherException dispatcherException) {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Exception in register Listener for " + cDSListListener.getJNDIName(), dispatcherException);
            }
            throw new JMSException(dispatcherException.getMessage(), (Throwable)dispatcherException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listChange(String string, DispatcherWrapper dispatcherWrapper, DDMemberInformation[] dDMemberInformationArray) {
        List list = this.getLDList(string);
        if (list == null) {
            return;
        }
        List list2 = list;
        synchronized (list2) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ListenerDispatcher listenerDispatcher = (ListenerDispatcher)listIterator.next();
                CDSListListener cDSListListener = listenerDispatcher.getListener();
                Dispatcher dispatcher = ((DispatcherAdapter)listenerDispatcher.getDispatcher()).getDelegate();
                if (!dispatcher.getId().equals(dispatcherWrapper.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain(dispatcher, dispatcherWrapper)) continue;
                cDSListListener.listChange(dDMemberInformationArray);
            }
        }
    }

    private int processDDMembershipPushRequest(DDMembershipPushRequest dDMembershipPushRequest) throws javax.jms.JMSException {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("processDDMembershipPushRequest(): Informing the membership change locally for DD JNDIName " + dDMembershipPushRequest.getDDJndiName());
        }
        this.listChange(dDMembershipPushRequest.getDDJndiName(), dDMembershipPushRequest.getDispatcherWrapper(), dDMembershipPushRequest.getMemberList());
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processDDMembershipCancelRequest(DDMembershipCancelRequest dDMembershipCancelRequest) {
        List list = this.getLDList(dDMembershipCancelRequest.getDDJndiName());
        if (list == null) {
            return Integer.MAX_VALUE;
        }
        List list2 = list;
        synchronized (list2) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ListenerDispatcher listenerDispatcher = (ListenerDispatcher)listIterator.next();
                Dispatcher dispatcher = ((DispatcherAdapter)listenerDispatcher.getDispatcher()).getDelegate();
                DispatcherWrapper dispatcherWrapper = dDMembershipCancelRequest.getDispatcherWrapper();
                if (!listenerDispatcher.getListener().getJNDIName().equals(dDMembershipCancelRequest.getDDJndiName()) || !dispatcher.getId().equals(dispatcherWrapper.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain(dispatcher, dispatcherWrapper)) continue;
                listenerDispatcher.getListener().distributedDestinationGone(dDMembershipCancelRequest.getDispatcherWrapper().getId());
                listIterator.remove();
            }
        }
        return Integer.MAX_VALUE;
    }

    public int invoke(Request request) throws Throwable {
        DispatcherWrapper dispatcherWrapper = null;
        switch (request.getMethodId()) {
            case 18711: {
                DDMembershipPushRequest dDMembershipPushRequest = (DDMembershipPushRequest)request;
                dispatcherWrapper = dDMembershipPushRequest.getDispatcherWrapper();
                CrossDomainSecurityManager.getCrossDomainSecurityUtil().checkRole(dispatcherWrapper.getRemoteDispatcher(), request);
                return this.processDDMembershipPushRequest(dDMembershipPushRequest);
            }
            case 18967: {
                DDMembershipCancelRequest dDMembershipCancelRequest = (DDMembershipCancelRequest)request;
                dispatcherWrapper = dDMembershipCancelRequest.getDispatcherWrapper();
                CrossDomainSecurityManager.getCrossDomainSecurityUtil().checkRole(dispatcherWrapper.getRemoteDispatcher(), request);
                return this.processDDMembershipCancelRequest(dDMembershipCancelRequest);
            }
        }
        throw new JMSException("No such method " + request.getMethodId());
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return null;
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("CDSLocalProxy.jmsPeerGone()");
        }
        this.peerGone(dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peerGone(Dispatcher dispatcher) {
        Object object;
        LinkedList<ListenerDispatcher> linkedList = new LinkedList<ListenerDispatcher>();
        Iterator iterator = null;
        Object object2 = this;
        synchronized (object2) {
            iterator = ((HashMap)this.listenerDispatcherMap.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            object = object2 = (List)iterator.next();
            synchronized (object) {
                ListIterator listIterator = object2.listIterator();
                while (listIterator.hasNext()) {
                    ListenerDispatcher listenerDispatcher = (ListenerDispatcher)listIterator.next();
                    Dispatcher dispatcher2 = ((DispatcherAdapter)listenerDispatcher.getDispatcher()).getDelegate();
                    if (!dispatcher2.getId().equals(dispatcher.getId()) || !CrossDomainManager.getCrossDomainUtil().isSameDomain(dispatcher2, dispatcher)) continue;
                    if (JMSDebug.JMSCDS.isDebugEnabled()) {
                        JMSDebug.JMSCDS.debug("peerGone(): Listener " + listenerDispatcher.getListener() + " for DD with JNDI Name of " + listenerDispatcher.getListener().getJNDIName());
                    }
                    listIterator.remove();
                    linkedList.add(listenerDispatcher);
                }
            }
        }
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (ListenerDispatcher)object2.next();
            ((ListenerDispatcher)object).getListener().distributedDestinationGone(dispatcher.getId());
            object2.remove();
        }
    }

    static {
        block3: {
            singleton = new CDSLocalProxy();
            try {
                if (!KernelStatus.isServer()) {
                    InvocableManagerDelegate.delegate.addManager(23, CDSRouter.getSingleton());
                }
            }
            catch (Exception exception) {
                if (!JMSDebug.JMSCDS.isDebugEnabled()) break block3;
                JMSDebug.JMSCDS.debug("Failed to register CDSRouter with dispatcher manager. Exception = " + exception);
            }
        }
    }

    private class UnregisterListenerThread
    implements Runnable {
        CDSListListener listener;

        private UnregisterListenerThread(CDSListListener cDSListListener) {
            this.listener = cDSListListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = CDSLocalProxy.this.getLDList(this.listener.getJNDIName());
            if (list != null) {
                CDSLocalProxy.this.removeFromLDList(this.listener, list);
                CDSLocalProxy cDSLocalProxy = CDSLocalProxy.this;
                synchronized (cDSLocalProxy) {
                    List list2 = list;
                    synchronized (list2) {
                        if (list.size() == 0) {
                            CDSLocalProxy.this.listenerDispatcherMap.remove(this.listener.getJNDIName());
                        }
                    }
                }
            }
        }
    }

    private static final class ListenerDispatcher {
        private CDSListListener listener;
        private JMSDispatcher dispatcher;

        public ListenerDispatcher(CDSListListener cDSListListener, JMSDispatcher jMSDispatcher) {
            this.listener = cDSListListener;
            this.dispatcher = jMSDispatcher;
        }

        public CDSListListener getListener() {
            return this.listener;
        }

        public JMSDispatcher getDispatcher() {
            return this.dispatcher;
        }
    }
}

