/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;
import weblogic.messaging.dispatcher.DispatcherId;

public final class ConsumerReconnectInfo
implements Externalizable,
Cloneable {
    static final long serialVersionUID = -2345606540693435552L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int _HAS_CLIENT_JMSID = 256;
    private static final int _HAS_SERVER_ID = 512;
    private static final int _HAS_CLIENT_DISPATCHER = 1024;
    private static final int _HAS_SERVER_DISPATCHER = 2048;
    private static final int _HAS_LAST_EXPOSED_MSG_ID = 4096;
    private static final int _HAS_DELAY_SERVER_CLOSE = 8192;
    private static final int _HAS_INVOKABLE_ID = 16384;
    private static final int _HAS_LAST_ACK_MSG_ID = 32768;
    private JMSID clientJMSID;
    private JMSID serverDestId;
    private JMSID invokableID;
    private DispatcherId clientDispatcherId;
    private DispatcherId serverDispatcherId;
    private long delayServerClose;
    private JMSMessageId lastExposedMsgId;
    private JMSMessageId lastAckMsgId;

    public DispatcherId getClientDispatcherId() {
        return this.clientDispatcherId;
    }

    public void setClientDispatcherId(DispatcherId dispatcherId) {
        this.clientDispatcherId = dispatcherId;
    }

    public JMSID getClientJMSID() {
        return this.clientJMSID;
    }

    public void setClientJMSID(JMSID jMSID) {
        this.clientJMSID = jMSID;
    }

    public long getDelayServerClose() {
        return this.delayServerClose;
    }

    public void setDelayServerClose(long l) {
        this.delayServerClose = l;
    }

    public JMSID getInvokableID() {
        return this.invokableID;
    }

    public void setInvokableID(JMSID jMSID) {
        this.invokableID = jMSID;
    }

    public JMSMessageId getLastAckMsgId() {
        return this.lastAckMsgId;
    }

    public void setLastAckMsgId(JMSMessageId jMSMessageId) {
        this.lastAckMsgId = jMSMessageId;
    }

    public JMSMessageId getLastExposedMsgId() {
        return this.lastExposedMsgId;
    }

    public void setLastExposedMsgId(JMSMessageId jMSMessageId) {
        this.lastExposedMsgId = jMSMessageId;
    }

    public JMSID getServerDestId() {
        return this.serverDestId;
    }

    public void setServerDestId(JMSID jMSID) {
        this.serverDestId = jMSID;
    }

    public DispatcherId getServerDispatcherId() {
        return this.serverDispatcherId;
    }

    public void setServerDispatcherId(DispatcherId dispatcherId) {
        this.serverDispatcherId = dispatcherId;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ConsumerReconnectInfo getClone() {
        try {
            return (ConsumerReconnectInfo)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return "(ConsumerReconnectInfo <clientDispatcherId " + this.clientDispatcherId + "> <clientJMSID " + this.clientJMSID + "> <lastExposedMsgId " + this.lastExposedMsgId + "> <lastAckMsgId " + this.lastAckMsgId + "> <serverDestId " + this.serverDestId + "> <serverDispatcherId " + this.serverDispatcherId + "> <delayServerClose " + this.delayServerClose + ">)";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.clientJMSID != null) {
            n |= 0x100;
        }
        if (this.serverDestId != null) {
            n |= 0x200;
        }
        if (this.clientDispatcherId != null) {
            n |= 0x400;
        }
        if (this.serverDispatcherId != null) {
            n |= 0x800;
        }
        if (this.lastExposedMsgId != null) {
            n |= 0x1000;
        }
        if (this.lastAckMsgId != null) {
            n |= 0x8000;
        }
        if (this.delayServerClose != 0L) {
            n |= 0x2000;
        }
        if (this.invokableID != null) {
            n |= 0x4000;
        }
        objectOutput.writeInt(n);
        if (this.delayServerClose != 0L) {
            objectOutput.writeLong(this.delayServerClose);
        }
        if (this.lastAckMsgId != null) {
            this.lastAckMsgId.writeExternal(objectOutput);
        }
        if (this.lastExposedMsgId != null) {
            this.lastExposedMsgId.writeExternal(objectOutput);
        }
        if (this.clientJMSID != null) {
            this.clientJMSID.writeExternal(objectOutput);
        }
        if (this.serverDestId != null) {
            this.serverDestId.writeExternal(objectOutput);
        }
        if (this.clientDispatcherId != null) {
            this.clientDispatcherId.writeExternal(objectOutput);
        }
        if (this.serverDispatcherId != null) {
            this.serverDispatcherId.writeExternal(objectOutput);
        }
        if (this.invokableID != null) {
            this.invokableID.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 0x2000) != 0) {
            this.delayServerClose = objectInput.readLong();
        }
        if ((n & 0x8000) != 0) {
            this.lastAckMsgId = new JMSMessageId();
            this.lastAckMsgId.readExternal(objectInput);
        }
        if ((n & 0x1000) != 0) {
            this.lastExposedMsgId = new JMSMessageId();
            this.lastExposedMsgId.readExternal(objectInput);
        }
        if ((n & 0x100) != 0) {
            this.clientJMSID = new JMSID();
            this.clientJMSID.readExternal(objectInput);
        }
        if ((n & 0x200) != 0) {
            this.serverDestId = new JMSID();
            this.serverDestId.readExternal(objectInput);
        }
        if ((n & 0x400) != 0) {
            this.clientDispatcherId = new DispatcherId();
            this.clientDispatcherId.readExternal(objectInput);
        }
        if ((n & 0x800) != 0) {
            this.serverDispatcherId = new DispatcherId();
            this.serverDispatcherId.readExternal(objectInput);
        }
        if ((n & 0x4000) != 0) {
            this.invokableID = new JMSID();
            this.invokableID.readExternal(objectInput);
        }
    }
}

