/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.dispatcher.VoidResponse;

public class DDMembershipPushRequest
extends Request
implements Externalizable {
    private static final int EXTVERSIONDIABLO = 1;
    private static final int VERSION_MASK = 255;
    private static final int _HAS_MEMBER_LIST = 256;
    private String ddConfigName;
    private String ddJndiName;
    private DDMemberInformation[] memberList;
    private DispatcherWrapper dispatcherWrapper;

    public DDMembershipPushRequest(String string, String string2, DDMemberInformation[] dDMemberInformationArray, DispatcherWrapper dispatcherWrapper) {
        super(null, 18711);
        this.ddConfigName = string;
        this.ddJndiName = string2;
        this.memberList = dDMemberInformationArray;
        this.dispatcherWrapper = dispatcherWrapper;
        if (string == null) {
            throw new Error(" Call BEA Support. DDMembershipPushRequest.ddConfigName = null");
        }
        if (string2 == null) {
            throw new Error(" Call BEA Support. DDMembershipPushRequest.ddJndiName = null");
        }
    }

    public DispatcherWrapper getDispatcherWrapper() {
        return this.dispatcherWrapper;
    }

    public String getDDConfigName() {
        return this.ddConfigName;
    }

    public String getDDJndiName() {
        return this.ddJndiName;
    }

    public DDMemberInformation[] getMemberList() {
        return this.memberList;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public DDMembershipPushRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 0;
        int n2 = 1;
        if (this.memberList != null && (n = this.memberList.length) != 0) {
            n2 |= 0x100;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        this.dispatcherWrapper.writeExternal(objectOutput);
        objectOutput.writeUTF(this.ddConfigName);
        objectOutput.writeUTF(this.ddJndiName);
        if (n != 0) {
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.memberList[i].writeExternal(objectOutput);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.dispatcherWrapper = new DispatcherWrapper();
        this.dispatcherWrapper.readExternal(objectInput);
        this.ddConfigName = objectInput.readUTF();
        this.ddJndiName = objectInput.readUTF();
        if ((n & 0x100) != 0) {
            int n3 = objectInput.readInt();
            this.memberList = new DDMemberInformation[n3];
            for (int i = 0; i < n3; ++i) {
                DDMemberInformation dDMemberInformation = new DDMemberInformation();
                dDMemberInformation.readExternal(objectInput);
                this.memberList[i] = dDMemberInformation;
            }
        }
    }
}

