/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.ObjectInput;
import javax.jms.JMSException;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.InvalidDestinationException;

public abstract class Destination
implements javax.jms.Destination {
    static final byte NULLDESTINATIONIMPL = 0;
    static final byte DESTINATIONIMPL = 1;
    static final byte DISTRIBUTEDDESTINATIONIMPL = 2;
    static final byte FUTUREDESTINATIONIMPL1 = 3;
    static final byte FUTUREDESTINATIONIMPL2 = 4;
    static final byte FUTUREDESTINATIONIMPL3 = 5;
    static final byte FUTUREDESTINATIONIMPL4 = 6;
    static final byte FUTUREDESTINATIONIMPL5 = 7;
    public static final byte _IFDESTCANNOTBENULL = 1;
    public static final byte _IFMUSTBEQUEUE = 2;
    public static final byte _IFMUSTBETOPIC = 4;

    public static int getDestinationType(Destination destination, int n) {
        if (destination == null) {
            return 0;
        }
        byte by = destination.getDestinationInstanceType();
        return by << n;
    }

    protected abstract byte getDestinationInstanceType();

    public static boolean equalsForDS(Destination destination, Destination destination2) {
        byte by;
        byte by2 = destination.getDestinationInstanceType();
        if (by2 != (by = destination2.getDestinationInstanceType())) {
            return false;
        }
        switch (by2) {
            case 1: {
                return destination.equals(destination2);
            }
            case 2: {
                return ((DistributedDestinationImpl)destination).same(((DistributedDestinationImpl)destination2).getName());
            }
        }
        return false;
    }

    public static DestinationImpl createDestination(byte by, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        DestinationImpl destinationImpl = null;
        switch (by) {
            case 0: {
                return destinationImpl;
            }
            case 1: {
                destinationImpl = new DestinationImpl();
                destinationImpl.readExternal(objectInput);
                return destinationImpl;
            }
            case 2: {
                destinationImpl = new DistributedDestinationImpl();
                destinationImpl.readExternal(objectInput);
                return destinationImpl;
            }
        }
        throw new IOException(JMSClientExceptionLogger.logInternalMarshallingErrorLoggable(by).getMessage());
    }

    public static final void checkDestinationType(javax.jms.Destination destination, byte by) throws JMSException {
        if (destination == null) {
            if ((by & 1) != 0) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logDestinationNullLoggable().getMessage());
            }
        } else {
            if (!(destination instanceof DestinationImpl)) {
                throw new InvalidDestinationException(JMSClientExceptionLogger.logForeignDestination3Loggable(destination.toString()).getMessage());
            }
            if (by != 0) {
                if ((by & 2) != 0) {
                    if (!((DestinationImpl)destination).isQueue()) {
                        throw new InvalidDestinationException(JMSClientExceptionLogger.logDestinationMustBeQueueLoggable(destination.toString()).getMessage());
                    }
                } else if ((by & 4) != 0 && !((DestinationImpl)destination).isTopic()) {
                    throw new InvalidDestinationException(JMSClientExceptionLogger.logDestinationMustBeTopicLoggable(destination.toString()).getMessage());
                }
            }
        }
    }
}

