/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.store.common.PersistentStoreOutputStream;

public final class DistributedDestinationImpl
extends DestinationImpl
implements InteropWriteReplaceable,
Externalizable {
    private static final int DDVERSION1 = 1;
    static final long serialVersionUID = 6099783323740404732L;
    private static final int BE_DESTINATION_NOT_TEMPORARY = 1;
    private int weight = 1;
    private int loadBalancePolicy;
    private int messageForwardingPolicy;
    private String ddJNDIName;
    private String distributedConfigMbeanName;
    private boolean hasStore;
    private boolean stale;
    private boolean serverAffinityEnabled = true;
    private boolean isQueueForward;
    private boolean isLocal = false;
    private boolean isConsumptionPaused;
    private boolean isInsertionPaused;
    private boolean isProductionPaused;
    private int nonSystemSubscriberConsumers;
    private int order;
    private static final int _DDVERSIONMASK = 3840;
    private static final int _DDVERSIONSHIFT = 8;
    private static final int _ISFORWARDING_POLICY_PARTITIONED = 1;
    private static final int _HASDDJNDINAME = 2;
    private static final int _HASSTORE = 4;
    private static final int _HASNONSYSSUBCNT = 8;
    private static final int _ISDURABLE = 16;
    private static final int _ISBOUNDBYINTERNALNAME = 32;
    private static final int _ISQUEUEFORWARD = 64;
    private static final int _ISSERVERAFFINITY = 128;
    private static final int _DONOTUSE_RESERVED = 4096;

    public DistributedDestinationImpl() {
    }

    public DistributedDestinationImpl(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5, String string6, JMSServerId jMSServerId, JMSID jMSID, DispatcherId dispatcherId, boolean bl, String string7, String string8, boolean bl2) {
        super(n, string, string5, string3, string4, jMSServerId, jMSID, string8, string7);
        this.ddJNDIName = string6;
        this.distributedConfigMbeanName = string2;
        this.loadBalancePolicy = n2;
        this.messageForwardingPolicy = n3;
        this.dispatcherId = dispatcherId;
        this.hasStore = bl;
        this.isLocal = bl2;
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug(" ------- Distributed Destination ------------------------------\n name            = " + this.getMemberName() + "\n" + " serverName      = " + this.getServerName() + "\n" + " distributedConfigMbeanName = " + this.distributedConfigMbeanName + "\n" + " ddJNDIName      = " + this.ddJNDIName + "\n" + " --------------------------------------------------------------\n");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getName();
    }

    public int getLoadBalancingPolicy() {
        return this.loadBalancePolicy;
    }

    public int getMessageForwardingPolicy() {
        return this.messageForwardingPolicy;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public synchronized int getOrder() {
        return this.order;
    }

    public synchronized void setOrder(int n) {
        this.order = n;
    }

    public boolean isPersistent() {
        return this.hasStore;
    }

    public byte getDestinationInstanceType() {
        return 2;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setStale(boolean bl) {
        this.stale = bl;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setQueueForward(boolean bl) {
        this.isQueueForward = bl;
    }

    public boolean isQueueForward() {
        return this.isQueueForward;
    }

    public void setNonSystemSubscriberConsumers(int n) {
        this.nonSystemSubscriberConsumers = n;
    }

    public int getNonSystemSubscriberConsumers() {
        return this.nonSystemSubscriberConsumers;
    }

    public boolean hasConsumer() {
        return this.nonSystemSubscriberConsumers > 0;
    }

    public String getInstanceName() {
        return this.getName();
    }

    public String getCreateDestinationArgument() {
        String string = this.distributedConfigMbeanName;
        if (string.startsWith("/")) {
            string = string.substring(2, string.length() - 1).intern();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return object.equals(this.getInstanceName());
        }
        return super.equals(object);
    }

    public boolean same(String string) {
        return string.equals(this.getName());
    }

    public String getDDJNDIName() {
        return this.ddJNDIName;
    }

    public String getGlobalJNDIName() {
        return this.ddJNDIName;
    }

    public String getName() {
        return this.distributedConfigMbeanName;
    }

    public void setName(String string) {
        this.distributedConfigMbeanName = string;
    }

    String getDestinationName() {
        return this.distributedConfigMbeanName;
    }

    public boolean isConsumptionPaused() {
        return this.isConsumptionPaused;
    }

    public void setIsConsumptionPaused(boolean bl) {
        this.isConsumptionPaused = bl;
    }

    public boolean isInsertionPaused() {
        return this.isInsertionPaused;
    }

    public void setIsInsertionPaused(boolean bl) {
        this.isInsertionPaused = bl;
    }

    public boolean isProductionPaused() {
        return this.isProductionPaused;
    }

    public void setIsProductionPaused(boolean bl) {
        this.isProductionPaused = bl;
    }

    public String debugString() {
        if (!JMSDebug.JMSCommon.isDebugEnabled()) {
            return "Distributed Destination Impl";
        }
        return new String(this.getInstanceName() + " " + this.getMemberName() + " | pers-" + this.isPersistent() + " | cons-" + this.hasConsumer() + " | weit-" + this.getWeight() + " | locl-" + this.isLocal());
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (peerInfo.compareTo(PeerInfo.VERSION_60) < 0) {
            throw new IOException(JMSClientExceptionLogger.logInvalidPeerLoggable(1).getMessage());
        }
        if (peerInfo.compareTo(PeerInfo.VERSION_70) < 0) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("\n   *** Peer > 6 & < 7 WriteReplace DDImpl with DImpl ***\n      serverName = " + this.getServerName() + "      qname      = " + this.distributedConfigMbeanName);
            }
            return new DestinationImpl(this.type, this.getServerName(), this.distributedConfigMbeanName, this.getApplicationName(), this.getModuleName(), this.backEndId, this.destinationId);
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("\n   *** Peer > 7 WriteReplace return this ***\n");
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        PeerInfo peerInfo;
        if (objectOutput instanceof PersistentStoreOutputStream) {
            this.writeDestinationImpl(objectOutput, this.distributedConfigMbeanName);
            return;
        }
        PeerInfo peerInfo2 = peerInfo = objectOutput instanceof PeerInfoable ? ((PeerInfoable)((Object)objectOutput)).getPeerInfo() : null;
        if (peerInfo != null && !((object = this.interopWriteReplace(peerInfo)) instanceof DistributedDestinationImpl)) {
            this.writeDestinationImpl(objectOutput);
            return;
        }
        this.writeDistributedDestinationImpl(objectOutput, peerInfo);
    }

    private void writeDistributedDestinationImpl(ObjectOutput objectOutput, PeerInfo peerInfo) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 1;
        n2 |= n3 << 8;
        n2 |= 0x20;
        n2 |= 0x10;
        if (this.ddJNDIName != null) {
            n2 |= 2;
        }
        if (this.hasStore) {
            n2 |= 4;
        }
        if (this.serverAffinityEnabled) {
            n2 |= 0x80;
        }
        if ((n = this.nonSystemSubscriberConsumers) != 0) {
            n2 |= 8;
        }
        if (this.isQueueForward) {
            n2 |= 0x40;
        }
        n2 |= 0x1000;
        if (this.messageForwardingPolicy == 0) {
            n2 |= 1;
        }
        objectOutput.writeShort(n2);
        this.writeDestinationImpl(objectOutput);
        if (objectOutput instanceof WLObjectOutput) {
            ((WLObjectOutput)objectOutput).writeAbbrevString(this.distributedConfigMbeanName);
            if ((n2 & 2) != 0) {
                ((WLObjectOutput)objectOutput).writeAbbrevString(this.ddJNDIName);
            }
        } else {
            objectOutput.writeUTF(this.distributedConfigMbeanName);
            if ((n2 & 2) != 0) {
                objectOutput.writeUTF(this.ddJNDIName);
            }
        }
        objectOutput.writeInt(this.loadBalancePolicy);
        objectOutput.writeInt(this.weight);
        if (n != 0) {
            objectOutput.writeLong(n);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = 0;
        short s2 = objectInput.readShort();
        if ((s2 & 0x1000) == 0) {
            s = s2;
        } else {
            byte by = (byte)((s2 & 0xF00) >>> 8 & 0xFF);
            if (by != 1) {
                throw JMSUtilities.versionIOException(by, 1, 1);
            }
            s = objectInput.readShort();
        }
        this.readDestinationImpl(objectInput, s);
        JMSDispatcher jMSDispatcher = JMSDispatcherManager.getLocalDispatcher();
        this.isLocal = jMSDispatcher.getId().equals(this.dispatcherId);
        if ((s2 & 0x1000) == 0) {
            this.distributedConfigMbeanName = super.getDestinationName();
            return;
        }
        if (objectInput instanceof WLObjectInput) {
            this.distributedConfigMbeanName = ((WLObjectInput)objectInput).readAbbrevString();
            if ((s2 & 2) != 0) {
                this.ddJNDIName = ((WLObjectInput)objectInput).readAbbrevString();
            }
        } else {
            this.distributedConfigMbeanName = objectInput.readUTF();
            if ((s2 & 2) != 0) {
                this.ddJNDIName = objectInput.readUTF();
            }
        }
        this.loadBalancePolicy = objectInput.readInt();
        this.messageForwardingPolicy = (s2 & 1) != 0 ? 0 : 1;
        this.weight = objectInput.readInt();
        if ((s2 & 4) != 0) {
            this.hasStore = true;
        }
        this.serverAffinityEnabled = (s2 & 0x80) != 0;
        if ((s2 & 0x48) != 0) {
            if ((s2 & 8) != 0) {
                this.nonSystemSubscriberConsumers = (int)objectInput.readLong();
            }
            if ((s2 & 0x40) != 0) {
                this.isQueueForward = true;
            }
        }
    }
}

