/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class JMSBrowserCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = 4858043004642723716L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSID browserId;

    public JMSBrowserCreateResponse(JMSID jMSID) {
        this.browserId = jMSID;
    }

    public JMSID getBrowserId() {
        return this.browserId;
    }

    public JMSBrowserCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        this.browserId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.browserId = new JMSID();
        this.browserId.readExternal(objectInput);
    }
}

