/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.ConnectionConsumer;
import weblogic.jms.client.JMSConnectionConsumer;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class JMSConnectionConsumerCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = -3526422355578670715L;
    private static final byte EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private ConnectionConsumer connectionConsumer;

    public JMSConnectionConsumerCreateResponse(ConnectionConsumer connectionConsumer) {
        this.connectionConsumer = connectionConsumer;
    }

    public final ConnectionConsumer getConnectionConsumer() {
        return this.connectionConsumer;
    }

    public final void setConnectionConsumer(ConnectionConsumer connectionConsumer) {
        this.connectionConsumer = connectionConsumer;
    }

    public JMSConnectionConsumerCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        ((JMSConnectionConsumer)this.connectionConsumer).writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.connectionConsumer = new JMSConnectionConsumer();
        ((JMSConnectionConsumer)this.connectionConsumer).readExternal(objectInput);
    }
}

