/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.messaging.dispatcher.DispatcherId;

public final class JMSServerId
implements Externalizable,
Comparable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    static final long serialVersionUID = 7779784416562889644L;
    private JMSID id;
    private DispatcherId dispatcherId = null;

    public JMSServerId(JMSID jMSID, DispatcherId dispatcherId) {
        this.id = jMSID;
        this.dispatcherId = dispatcherId;
    }

    public String toString() {
        return this.id.toString() + ":" + this.dispatcherId.toString();
    }

    public JMSServerId(JMSServerId jMSServerId) {
        this.id = jMSServerId.getId();
        this.dispatcherId = jMSServerId.getDispatcherId();
    }

    public JMSID getId() {
        return this.id;
    }

    public DispatcherId getDispatcherId() {
        return this.dispatcherId;
    }

    public long getTimestamp() {
        return this.id.getTimestamp();
    }

    public int getSeed() {
        return this.id.getSeed();
    }

    public JMSServerId() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(2);
        this.id.writeExternal(objectOutput);
        this.dispatcherId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        this.id = new JMSID();
        this.id.readExternal(objectInput);
        if (by == 1) {
            this.consumeJVMID(objectInput);
        } else {
            this.dispatcherId = new DispatcherId();
            this.dispatcherId.readExternal(objectInput);
        }
    }

    private void consumeJVMID(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        try {
            Class<?> clazz = Class.forName("weblogic.rjvm.JVMID");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("readExternal", ObjectInput.class);
            method.invoke(obj, objectInput);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new AssertionError((Object)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (!this.id.equals(((JMSServerId)object).getId())) {
            return false;
        }
        return this.dispatcherId.equals(((JMSServerId)object).getDispatcherId());
    }

    public int compareTo(Object object) {
        JMSServerId jMSServerId = (JMSServerId)object;
        int n = this.id.compareTo(jMSServerId.id);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return this.dispatcherId.compareTo(jMSServerId.dispatcherId);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.dispatcherId.hashCode();
    }
}

