/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Message;
import weblogic.common.internal.PeerInfo;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.messaging.MessagingLogger;
import weblogic.utils.StringUtils;
import weblogic.utils.io.DataIO;

public final class JMSUtilities {
    public static final String RESERVED_ROLLBACK_ONLY = "ReservedRollbackOnly";
    private static final short TYPENULL = 99;
    private static final short TYPESTRING = 102;
    private static final short TYPEBOOLEAN = 103;
    private static final short TYPEINTEGER = 104;
    private static final short TYPELONG = 105;
    private static final short TYPEBYTE = 106;
    private static final short TYPESHORT = 107;
    private static final short TYPEFLOAT = 108;
    private static final short TYPEDOUBLE = 109;
    private static final short TYPECHARACTER = 110;
    private static final short TYPEBYTEARRAY = 111;
    private static final short TYPEBIGSTRING = 112;

    private JMSUtilities() {
    }

    public static javax.jms.JMSException jmsException(String string, Exception exception) {
        return JMSUtilities.jmsExceptionThrowable(string, exception);
    }

    public static javax.jms.JMSException jmsExceptionThrowable(String string, Throwable throwable) {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug(string, throwable);
        }
        if (throwable instanceof javax.jms.JMSException) {
            return (javax.jms.JMSException)throwable;
        }
        JMSException jMSException = new JMSException(string, throwable);
        return jMSException;
    }

    public static javax.jms.JMSException throwJMSOrRuntimeException(Throwable throwable) throws javax.jms.JMSException {
        if (throwable instanceof javax.jms.JMSException) {
            throw (javax.jms.JMSException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new JMSException(throwable.getMessage(), throwable);
    }

    public static StreamCorruptedException versionIOException(int n, int n2, int n3) {
        return new StreamCorruptedException(MessagingLogger.logUnsupportedClassVersionLoggable(n, n2, n3).getMessage());
    }

    public static boolean getTracing(Message message) {
        return true;
    }

    public static void setTracing(Message message, boolean bl) {
        try {
            message.setBooleanProperty("tracing", bl);
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
    }

    private static boolean getDropNulls(PeerInfo peerInfo) {
        if (peerInfo == null) {
            return true;
        }
        return peerInfo.compareTo(PeerInfo.VERSION_612) <= 0;
    }

    private static int getEntryCount(Map map, boolean bl) {
        if (bl) {
            int n = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                ++n;
            }
            return n;
        }
        return map.size();
    }

    static final int writeBasicMap(DataOutput dataOutput, Map map, PeerInfo peerInfo) throws IOException {
        boolean bl = JMSUtilities.getDropNulls(peerInfo);
        dataOutput.writeInt(JMSUtilities.getEntryCount(map, bl));
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (bl && entry.getValue() == null) continue;
            n += JMSUtilities.writeBasicType(dataOutput, entry.getKey());
            n += JMSUtilities.writeBasicType(dataOutput, entry.getValue());
        }
        return n;
    }

    static final int writeBigStringBasicMap(ObjectOutput objectOutput, Map map, PeerInfo peerInfo, boolean bl) throws IOException {
        boolean bl2 = JMSUtilities.getDropNulls(peerInfo);
        boolean bl3 = false;
        if (peerInfo != null) {
            bl3 = bl && peerInfo.compareTo(PeerInfo.VERSION_701) >= 0;
        }
        objectOutput.writeInt(JMSUtilities.getEntryCount(map, bl2));
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (bl2 && entry.getValue() == null) continue;
            if (bl3) {
                n += JMSUtilities.writeBigStringBasicType(objectOutput, entry.getKey());
                n += JMSUtilities.writeBigStringBasicType(objectOutput, entry.getValue());
                continue;
            }
            n += JMSUtilities.writeBasicType(objectOutput, entry.getKey());
            n += JMSUtilities.writeBasicType(objectOutput, entry.getValue());
        }
        return n;
    }

    static final HashMap readBasicMap(DataInput dataInput) throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = dataInput.readInt();
        while (n-- > 0) {
            Object object = JMSUtilities.readBasicType(dataInput);
            Object object2 = JMSUtilities.readBasicType(dataInput);
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    static final HashMap readBigStringBasicMap(ObjectInput objectInput) throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = objectInput.readInt();
        while (n-- > 0) {
            Object object = JMSUtilities.readBigStringBasicType(objectInput);
            Object object2 = JMSUtilities.readBigStringBasicType(objectInput);
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    private static int writeBigStringBasicType(ObjectOutput objectOutput, Object object) throws IOException {
        if (object != null && object instanceof String) {
            String string = (String)object;
            int n = StringUtils.getUTFLength(string);
            if (n <= Short.MAX_VALUE) {
                objectOutput.writeShort(102);
                JMSUtilities.writeUTF(objectOutput, string, n);
            } else {
                objectOutput.writeShort(112);
                objectOutput.writeObject(string);
            }
            return 4 + (string.length() << 2);
        }
        return JMSUtilities.writeBasicType(objectOutput, object);
    }

    private static int writeBasicType(DataOutput dataOutput, Object object) throws IOException {
        if (object == null) {
            dataOutput.writeShort(99);
            return 2;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = StringUtils.getUTFLength(string);
            if (n > Short.MAX_VALUE) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((string.length() << 2) + 50);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(string);
                objectOutputStream.close();
                return JMSUtilities.writeBasicType(dataOutput, byteArrayOutputStream.toByteArray());
            }
            dataOutput.writeShort(102);
            JMSUtilities.writeUTF(dataOutput, string, n);
            return 4 + (string.length() << 2);
        }
        if (object instanceof Integer) {
            dataOutput.writeShort(104);
            dataOutput.writeInt((Integer)object);
            return 6;
        }
        if (object instanceof Long) {
            dataOutput.writeShort(105);
            dataOutput.writeLong((Long)object);
            return 10;
        }
        if (object instanceof byte[]) {
            dataOutput.writeShort(111);
            dataOutput.writeInt(((byte[])object).length);
            dataOutput.write((byte[])object);
            return 6 + ((byte[])object).length;
        }
        if (object instanceof Boolean) {
            dataOutput.writeShort(103);
            dataOutput.writeBoolean((Boolean)object);
            return 3;
        }
        if (object instanceof Byte) {
            dataOutput.writeShort(106);
            dataOutput.writeByte(((Byte)object).byteValue());
            return 3;
        }
        if (object instanceof Short) {
            dataOutput.writeShort(107);
            dataOutput.writeShort(((Short)object).shortValue());
            return 4;
        }
        if (object instanceof Float) {
            dataOutput.writeShort(108);
            dataOutput.writeFloat(((Float)object).floatValue());
            return 6;
        }
        if (object instanceof Double) {
            dataOutput.writeShort(109);
            dataOutput.writeDouble((Double)object);
            return 10;
        }
        if (object instanceof Character) {
            dataOutput.writeShort(110);
            dataOutput.writeChar(((Character)object).charValue());
            return 4;
        }
        throw new StreamCorruptedException(JMSClientExceptionLogger.logSimpleObjectLoggable(object.getClass().getName()).getMessage());
    }

    private static Object readBigStringBasicType(ObjectInput objectInput) throws IOException {
        short s = objectInput.readShort();
        if (s == 112) {
            try {
                return (String)objectInput.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }
        return JMSUtilities.readBasicType(objectInput, s);
    }

    private static Object readBasicType(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        return JMSUtilities.readBasicType(dataInput, s);
    }

    private static Object readBasicType(DataInput dataInput, short s) throws IOException {
        switch (s) {
            case 99: {
                return null;
            }
            case 102: {
                return DataInputStream.readUTF(dataInput);
            }
            case 103: {
                return dataInput.readBoolean();
            }
            case 104: {
                return new Integer(dataInput.readInt());
            }
            case 105: {
                return new Long(dataInput.readLong());
            }
            case 106: {
                return new Byte(dataInput.readByte());
            }
            case 111: {
                byte[] byArray = new byte[dataInput.readInt()];
                dataInput.readFully(byArray);
                return byArray;
            }
            case 107: {
                return new Short(dataInput.readShort());
            }
            case 108: {
                return new Float(dataInput.readFloat());
            }
            case 109: {
                return new Double(dataInput.readDouble());
            }
            case 110: {
                return new Character(dataInput.readChar());
            }
        }
        throw new StreamCorruptedException(JMSClientExceptionLogger.logUnrecognizedClassCodeLoggable(s).getMessage());
    }

    private static void writeUTF(DataOutput dataOutput, String string, int n) throws IOException {
        if (n > Short.MAX_VALUE) {
            throw new UTFDataFormatException();
        }
        dataOutput.writeShort(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            DataIO.writeUTFChar(dataOutput, string.charAt(i));
        }
    }
}

