/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.MessageImpl;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;
import weblogic.workarea.utils.WorkContextInputAdapter;
import weblogic.workarea.utils.WorkContextOutputAdapter;

public class JMSWorkContextHelper {
    private static final boolean DEBUG = false;
    private static WorkContextHelper helper = WorkContextHelper.getWorkContextHelper();

    public static void infectMessage(MessageImpl messageImpl) {
        WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
        if (workContextMapInterceptor != null) {
            messageImpl.setWorkContext(workContextMapInterceptor.copyThreadContexts(48));
        }
    }

    public static void infectThread(MessageImpl messageImpl) {
        Object object = messageImpl.getWorkContext();
        if (object != null) {
            WorkContextHelper.getWorkContextHelper().setLocalInterceptor((WorkContextMapInterceptor)object);
        }
    }

    public static void disinfectThread() {
        WorkContextHelper.getWorkContextHelper().setLocalInterceptor(null);
    }

    static void writeWorkContext(Object object, ObjectOutput objectOutput) throws IOException {
        WorkContextMapInterceptor workContextMapInterceptor = (WorkContextMapInterceptor)object;
        if (objectOutput instanceof WorkContextOutput) {
            workContextMapInterceptor.sendRequest((WorkContextOutput)((Object)objectOutput), 48);
        } else {
            workContextMapInterceptor.sendRequest(new WorkContextOutputAdapter(objectOutput), 48);
        }
    }

    static Object readWorkContext(ObjectInput objectInput) throws IOException {
        WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().createInterceptor();
        if (objectInput instanceof WorkContextInput) {
            workContextMapInterceptor.receiveRequest((WorkContextInput)((Object)objectInput));
        } else {
            workContextMapInterceptor.receiveRequest(new WorkContextInputAdapter(objectInput));
        }
        return workContextMapInterceptor;
    }

    private static void p(String string) {
        System.out.println("<JMSWorkContextHelper>: " + string);
    }
}

