/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.MessageImpl;

public class MessageReference {
    private MessageImpl message;
    private long sequenceNumber;
    private int deliveryCount = 1;
    private MessageReference prev;
    private MessageReference next;

    public MessageReference(MessageImpl messageImpl) {
        this.message = messageImpl;
        this.deliveryCount = messageImpl.getDeliveryCount();
    }

    public MessageReference(MessageReference messageReference) {
        this.message = messageReference.message;
        this.deliveryCount = messageReference.deliveryCount;
    }

    public final void setMessage(MessageImpl messageImpl) {
        this.message = messageImpl;
    }

    public final MessageImpl getMessage() {
        return this.message;
    }

    public final void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setPrev(MessageReference messageReference) {
        this.prev = messageReference;
    }

    public final MessageReference getPrev() {
        return this.prev;
    }

    public final void setNext(MessageReference messageReference) {
        this.next = messageReference;
    }

    public final MessageReference getNext() {
        return this.next;
    }

    public final int getDeliveryCount() {
        return this.deliveryCount;
    }

    public final void incrementDeliveryCount() {
        if (this.deliveryCount != -1) {
            ++this.deliveryCount;
        }
    }

    public final boolean getRedelivered() {
        return this.deliveryCount != 1;
    }

    public final void setDeliveryCount(int n) {
        this.deliveryCount = n;
    }

    public void prepareForCache() {
        if (this.message != null) {
            this.message.setMessageReference(null);
        }
        this.message = null;
        this.sequenceNumber = 0L;
        this.deliveryCount = 1;
        this.prev = null;
        this.next = null;
    }

    public final void reset(MessageImpl messageImpl) {
        this.message = messageImpl;
        this.deliveryCount = messageImpl.getJMSRedelivered() ? -1 : 1;
    }

    public String toString() {
        return "(mRef id=" + this.message.getId() + ")";
    }
}

