/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.ObjectMessage;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.kernel.KernelStatus;
import weblogic.store.PersistentStoreException;
import weblogic.store.TestStoreException;
import weblogic.utils.io.Replacer;

public final class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Externalizable,
TestStoreException {
    private static final byte EXTVERSION = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -1035306457762201546L;
    private transient Serializable object;
    PayloadStream payload;
    private static final Replacer REPLACER = ObjectMessageImpl.getReplacer();
    private static final String REMOTE_OBJECT_REPLACER_CLASS_NAME = "weblogic.rmi.utils.io.RemoteObjectReplacer";
    private static boolean testStoreExceptionEnabled;
    public static final String DEBUG_STORE_PROPERTY = "JMS_BEA_DEBUG_STORE_EXCEPTION";

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(ObjectMessage objectMessage) throws javax.jms.JMSException {
        this(objectMessage, null, null);
    }

    public ObjectMessageImpl(ObjectMessage objectMessage, Destination destination, Destination destination2) throws javax.jms.JMSException {
        super(objectMessage, destination, destination2);
        this.setObject(objectMessage.getObject());
    }

    public byte getType() {
        return 4;
    }

    public static boolean isTestStoreExceptionEnabled() {
        return testStoreExceptionEnabled;
    }

    public void setObject(Serializable serializable) throws javax.jms.JMSException {
        this.setObject(serializable, null);
    }

    public void setObject(Serializable serializable, PeerInfo peerInfo) throws javax.jms.JMSException {
        this.writeMode();
        try {
            BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
            ObjectOutputStream2 objectOutputStream2 = null;
            objectOutputStream2 = peerInfo == null ? new ObjectOutputStream2(bufferOutputStream) : new ObjectOutputStreamPeerInfoable(bufferOutputStream, peerInfo);
            if (!objectOutputStream2.canReplace()) {
                serializable = (Serializable)objectOutputStream2.replaceObject(serializable);
            }
            objectOutputStream2.writeObject(serializable);
            objectOutputStream2.flush();
            this.payload = (PayloadStream)bufferOutputStream.moveToPayload();
            this.object = null;
        }
        catch (Exception exception) {
            throw new JMSException(JMSClientExceptionLogger.logSerializationErrorLoggable().getMessage(), (Throwable)exception);
        }
    }

    public Serializable getObject() throws javax.jms.JMSException {
        this.decompressMessageBody();
        if (this.object == null && this.payload != null) {
            try {
                ObjectInputStream2 objectInputStream2 = new ObjectInputStream2(this.payload.getInputStream());
                this.object = (Serializable)objectInputStream2.readObject();
                if (!objectInputStream2.canResolve()) {
                    this.object = (Serializable)objectInputStream2.resolveObject(this.object);
                }
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializeIOLoggable().getMessage(), (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializeCNFELoggable().getMessage(), (Throwable)classNotFoundException);
            }
        }
        return this.object;
    }

    public void nullBody() {
        this.object = null;
        this.payload = null;
    }

    public String toString() {
        try {
            return "ObjectMessage[" + this.getJMSMessageID() + "," + this.getObject() + "]";
        }
        catch (javax.jms.JMSException jMSException) {
            return "ObjectMessage[" + this.getJMSMessageID() + "]";
        }
    }

    private static Replacer getReplacer() {
        try {
            Class<?> clazz = Class.forName(REMOTE_OBJECT_REPLACER_CLASS_NAME);
            Method method = clazz.getMethod("getReplacer", new Class[0]);
            return (Replacer)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public PersistentStoreException getTestException() {
        try {
            Serializable serializable;
            if (ObjectMessageImpl.isTestStoreExceptionEnabled() && this.propertyExists(DEBUG_STORE_PROPERTY) && (serializable = this.getObject()) instanceof PersistentStoreException) {
                return (PersistentStoreException)serializable;
            }
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
        return null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Payload payload;
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
        } else {
            objectOutput2 = objectOutput;
        }
        if (!this.isCompressed() && this.payload == null) {
            payload = PayloadFactoryImpl.createOutputStream();
            ObjectOutputStream2 objectOutputStream2 = new ObjectOutputStream2((OutputStream)((Object)payload));
            objectOutputStream2.writeObject(this.object);
            objectOutputStream2.flush();
            this.payload = (PayloadStream)((BufferOutputStream)payload).moveToPayload();
        }
        int n2 = this.getVersion(objectOutput2) >= 30 ? (int)((byte)(2 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : 1;
        objectOutput2.writeByte(n2);
        if (this.isCompressed()) {
            if (n2 == 1) {
                payload = (PayloadStream)this.decompress();
                payload.writeLengthAndData(objectOutput2);
            } else {
                this.flushCompressedMessageBody(objectOutput2);
            }
        } else if ((n2 & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(objectOutput2, this.payload);
        } else {
            this.payload.writeLengthAndData(objectOutput2);
        }
    }

    public final void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.cleanupCompressedMessageBody();
            throw throwable;
        }
        this.cleanupCompressedMessageBody();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0x7F);
        if (by2 < 1 || by2 > 2) {
            throw JMSUtilities.versionIOException(by2, 1, 2);
        }
        if ((by & 0xFFFFFF80) != 0) {
            this.readExternalCompressedMessageBody(objectInput);
        } else {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
        }
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        this.copy(objectMessageImpl);
        try {
            if (this.payload == null && this.object != null) {
                BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
                ObjectOutputStream2 objectOutputStream2 = new ObjectOutputStream2(bufferOutputStream);
                objectOutputStream2.writeObject(this.object);
                objectOutputStream2.flush();
                objectMessageImpl.payload = (PayloadStream)bufferOutputStream.moveToPayload();
            } else if (this.payload != null) {
                objectMessageImpl.payload = this.payload.copyPayloadWithoutSharedStream();
                this.payloadCopyOnWrite = true;
                objectMessageImpl.payloadCopyOnWrite = true;
            } else {
                objectMessageImpl.payload = null;
            }
            objectMessageImpl.object = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        objectMessageImpl.setBodyWritable(false);
        objectMessageImpl.setPropertiesWritable(false);
        return objectMessageImpl;
    }

    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    public PayloadStream getPayload() {
        return this.payload;
    }

    public byte[] getBodyBytes() throws javax.jms.JMSException {
        if (this.payload == null) {
            return new byte[0];
        }
        PayloadStream payloadStream = this.payload;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            payloadStream.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
    }

    public void setBodyBytes(PayloadStream payloadStream) {
        this.payload = payloadStream;
        this.object = null;
    }

    public PayloadStream getMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return this.payload;
        }
        try {
            return (PayloadStream)this.decompress();
        }
        catch (IOException iOException) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
        }
    }

    static {
        try {
            String string = System.getProperty("weblogic.store.qa.StoreTest");
            if (string != null) {
                String string2 = "true";
                testStoreExceptionEnabled = string2.equalsIgnoreCase(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    final class ObjectOutputStreamPeerInfoable
    extends ObjectOutputStream2
    implements PeerInfoable {
        private PeerInfo peerInfo;

        ObjectOutputStreamPeerInfoable(OutputStream outputStream, PeerInfo peerInfo) throws IOException, StreamCorruptedException {
            super(outputStream);
            this.peerInfo = peerInfo;
        }

        public PeerInfo getPeerInfo() {
            return this.peerInfo;
        }
    }

    class ObjectOutputStream2
    extends ObjectOutputStream
    implements WLObjectOutput {
        private boolean canReplace;

        ObjectOutputStream2(OutputStream outputStream) throws IOException, StreamCorruptedException {
            super(outputStream);
            this.canReplace = true;
            if (KernelStatus.isApplet()) {
                this.canReplace = false;
            } else {
                this.enableReplaceObject(true);
            }
        }

        boolean canReplace() {
            return this.canReplace;
        }

        protected Object replaceObject(Object object) throws IOException {
            if (REPLACER != null) {
                return REPLACER.replaceObject(object);
            }
            return object;
        }

        public final void writeObjectWL(Object object) throws IOException {
            this.writeObject(object);
        }

        public final void writeString(String string) throws IOException {
            this.writeObject(string);
        }

        public final void writeDate(Date date) throws IOException {
            this.writeObject(date);
        }

        public final void writeArrayList(ArrayList arrayList) throws IOException {
            this.writeObject(arrayList);
        }

        public final void writeProperties(Properties properties) throws IOException {
            this.writeObject(properties);
        }

        public final void writeBytes(byte[] byArray) throws IOException {
            this.writeObject(byArray);
        }

        public final void writeBytes(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.writeObject(byArray2);
        }

        public final void writeArrayOfObjects(Object[] objectArray) throws IOException {
            this.writeObject(objectArray);
        }

        public final void writeAbbrevString(String string) throws IOException {
            this.writeObject(string);
        }

        public final void writeImmutable(Object object) throws IOException {
            this.writeObject(object);
        }
    }

    final class ObjectInputStream2
    extends ObjectInputStream
    implements WLObjectInput {
        private boolean canResolve;

        ObjectInputStream2(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
            this.canResolve = true;
            if (KernelStatus.isApplet()) {
                this.canResolve = false;
            } else {
                this.enableResolveObject(true);
            }
        }

        boolean canResolve() {
            return this.canResolve;
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (KernelStatus.isApplet()) {
                return Class.forName(objectStreamClass.getName());
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return Class.forName(objectStreamClass.getName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(objectStreamClass);
            }
        }

        protected Object resolveObject(Object object) throws IOException {
            if (REPLACER != null) {
                return REPLACER.resolveObject(object);
            }
            return object;
        }

        public final Object readObjectWL() throws IOException, ClassNotFoundException {
            return this.readObject();
        }

        public final String readString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final Date readDate() throws IOException {
            try {
                return (Date)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final ArrayList readArrayList() throws IOException, ClassNotFoundException {
            return (ArrayList)this.readObject();
        }

        public final Properties readProperties() throws IOException {
            try {
                return (Properties)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final byte[] readBytes() throws IOException {
            try {
                return (byte[])this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final Object[] readArrayOfObjects() throws IOException, ClassNotFoundException {
            return (Object[])this.readObject();
        }

        public final String readAbbrevString() throws IOException {
            try {
                return (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        public final Object readImmutable() throws IOException, ClassNotFoundException {
            return this.readObject();
        }
    }
}

