/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import weblogic.jms.common.SecHelper;

public final class PasswordStore {
    private long currentHandle = Long.MIN_VALUE;
    private HashMap store = new HashMap();
    private char[] key;
    private static final char[] DEFAULT_KEY = new char[]{'B', 'E', 'A', '0', '1'};

    public PasswordStore() {
        this(DEFAULT_KEY);
    }

    public PasswordStore(char[] cArray) {
        if (cArray == null || cArray.length <= 0) {
            cArray = DEFAULT_KEY;
        }
        this.key = new char[cArray.length];
        System.arraycopy(cArray, 0, this.key, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object storePassword(Object object) throws GeneralSecurityException {
        Object object2;
        StoreData storeData;
        if (object == null) {
            storeData = new StoreData(2, object);
        } else if (object instanceof String) {
            object2 = SecHelper.encryptString(this.key, (String)object);
            storeData = new StoreData(0, object2);
        } else if (object instanceof char[]) {
            object2 = SecHelper.encryptPassword(this.key, (char[])object);
            storeData = new StoreData(1, object2);
        } else {
            storeData = new StoreData(2, object);
        }
        object2 = this.store;
        synchronized (object2) {
            Long l = new Long(this.currentHandle++);
            this.store.put(l, storeData);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrievePassword(Object object) throws GeneralSecurityException, IOException {
        StoreData storeData;
        if (object == null) {
            return null;
        }
        if (!(object instanceof Long)) {
            throw new GeneralSecurityException("Invalid handle type: " + object.getClass().getName());
        }
        Long l = (Long)object;
        HashMap hashMap = this.store;
        synchronized (hashMap) {
            if (!this.store.containsKey(l)) {
                return null;
            }
            storeData = (StoreData)this.store.get(l);
        }
        if (storeData.getType() == 1) {
            return SecHelper.decryptString(this.key, (String)storeData.getData());
        }
        if (storeData.getType() == 0) {
            return new String(SecHelper.decryptString(this.key, (String)storeData.getData()));
        }
        return storeData.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePassword(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Long)) {
            return;
        }
        HashMap hashMap = this.store;
        synchronized (hashMap) {
            this.store.remove(object);
        }
    }

    private static class StoreData {
        private static final int TYPE_STRING = 0;
        private static final int TYPE_CHARARRAY = 1;
        private static final int TYPE_OTHER = 2;
        private int type;
        private Object data;

        private StoreData(int n, Object object) {
            this.type = n;
            this.data = object;
        }

        private int getType() {
            return this.type;
        }

        private Object getData() {
            return this.data;
        }
    }
}

