/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageEOFException;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;

public final class StreamMessageImpl
extends MessageImpl
implements StreamMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = 7748687583664395357L;
    private static final byte UNKNOWN_TYPECODE = 0;
    private static final byte BOOLEAN_TYPE = 1;
    private static final byte BYTE_TYPE = 2;
    private static final byte CHAR_TYPE = 3;
    private static final byte DOUBLE_TYPE = 4;
    private static final byte FLOAT_TYPE = 5;
    private static final byte INT_TYPE = 6;
    private static final byte LONG_TYPE = 7;
    private static final byte SHORT_TYPE = 8;
    private static final byte STRING_UTF_TYPE = 9;
    private static final byte STRING_UTF32_TYPE = 10;
    private static final byte BYTES_TYPE = 11;
    private static final byte NULL_TYPE = 12;
    private static final String[] TYPE_CODE_STRINGS = new String[]{"invalid type code", "boolean", "byte", "char", "double", "float", "integer", "long", "short", "String", "String", "byte array", "null object"};
    private static final String ERROR_MSG_SEGMENT = ". Previous attempt to read bytes from the stream message is not complete. As per the JMS standard, if the readBytes method does not return the value -1, a subsequent readBytes call must be made in order to ensure that there are no more bytes left to be read in. For more information, see the JMS API doc for the method readBytes in interface StreamMessage";
    private boolean readingByteArray;
    private int available_bytes;
    private transient PayloadStream payload;
    private transient boolean copyOnWrite;
    private transient BufferOutputStream bos;
    private transient BufferInputStream bis;

    public StreamMessageImpl() {
    }

    public StreamMessageImpl(StreamMessage streamMessage) throws IOException, javax.jms.JMSException {
        this(streamMessage, null, null);
    }

    public StreamMessageImpl(StreamMessage streamMessage, Destination destination, Destination destination2) throws IOException, javax.jms.JMSException {
        super(streamMessage, destination, destination2);
        if (!(streamMessage instanceof StreamMessageImpl)) {
            streamMessage.reset();
        }
        try {
            while (true) {
                this.writeObject(streamMessage.readObject());
            }
        }
        catch (javax.jms.MessageEOFException messageEOFException) {
            this.reset();
            this.setPropertiesWritable(false);
            return;
        }
    }

    public byte getType() {
        return 5;
    }

    public void nullBody() {
        this.payload = null;
        this.copyOnWrite = false;
        this.bis = null;
        this.bos = null;
        this.readingByteArray = false;
        this.available_bytes = 0;
    }

    private void putTypeBack() throws IOException {
        if (!this.readingByteArray) {
            this.bis.unput();
        }
    }

    private String readPastEnd() {
        return JMSClientExceptionLogger.logReadPastEndLoggable().getMessage();
    }

    private String readPastEnd3(int n) {
        return JMSClientExceptionLogger.logReadPastEnd3Loggable(n).getMessage();
    }

    private String streamReadError() {
        return JMSClientExceptionLogger.logStreamReadErrorLoggable().getMessage();
    }

    private String streamReadError(int n) {
        return JMSClientExceptionLogger.logReadErrorLoggable(n).getMessage();
    }

    private String streamWriteError() {
        return JMSClientExceptionLogger.logStreamWriteErrorLoggable().getMessage();
    }

    private String streamWriteError(int n) {
        return JMSClientExceptionLogger.logWriteErrorLoggable(n).getMessage();
    }

    private String streamConversionError(String string, String string2) {
        return JMSClientExceptionLogger.logConversionErrorLoggable(string, string2).getMessage();
    }

    private byte readType() throws javax.jms.JMSException {
        this.decompressMessageBody();
        this.checkReadable();
        if (this.readingByteArray) {
            return 11;
        }
        try {
            return this.bis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(0), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(0), (Throwable)iOException);
        }
    }

    private void writeType(byte by) throws javax.jms.JMSException {
        this.checkWritable();
        try {
            this.bos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException(JMSClientExceptionLogger.logStreamWriteErrorLoggable().getMessage(), (Throwable)iOException);
        }
    }

    public boolean readBoolean() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return this.bis.readBoolean();
                }
                case 9: 
                case 10: {
                    return Boolean.valueOf(this.readStringInternal(by));
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(1)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(10), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(10), (Throwable)iOException);
        }
    }

    public byte readByte() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bis.readByte();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Byte.parseByte(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(2)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(20), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(20), (Throwable)iOException);
        }
    }

    public short readShort() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Short.parseShort(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(8)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(40), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(40), (Throwable)iOException);
        }
    }

    public char readChar() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 3: {
                    return this.bis.readChar();
                }
                case 12: {
                    this.putTypeBack();
                    throw new NullPointerException();
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(3)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(60), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(60), (Throwable)iOException);
        }
    }

    public int readInt() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 6: {
                    return this.bis.readInt();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Integer.parseInt(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(6)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(70), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(70), (Throwable)iOException);
        }
    }

    public long readLong() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 2: {
                    return this.bis.readByte();
                }
                case 8: {
                    return this.bis.readShort();
                }
                case 6: {
                    return this.bis.readInt();
                }
                case 7: {
                    return this.bis.readLong();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Long.parseLong(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(7)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(80), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(80), (Throwable)iOException);
        }
    }

    public float readFloat() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 5: {
                    return this.bis.readFloat();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Float.parseFloat(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(5)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(90), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(90), (Throwable)iOException);
        }
    }

    public double readDouble() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 5: {
                    return this.bis.readFloat();
                }
                case 4: {
                    return this.bis.readDouble();
                }
                case 9: 
                case 10: {
                    int n = this.bis.pos();
                    try {
                        return Double.parseDouble(this.readStringInternal(by));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bis.gotoPos(n);
                        this.bis.unput();
                        throw numberFormatException;
                    }
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(4)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd3(100), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(100), (Throwable)iOException);
        }
    }

    public String readString() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return String.valueOf(this.bis.readBoolean());
                }
                case 2: {
                    return String.valueOf(this.bis.readByte());
                }
                case 8: {
                    return String.valueOf(this.bis.readShort());
                }
                case 3: {
                    return String.valueOf(this.bis.readChar());
                }
                case 6: {
                    return String.valueOf(this.bis.readInt());
                }
                case 7: {
                    return String.valueOf(this.bis.readLong());
                }
                case 5: {
                    return String.valueOf(this.bis.readFloat());
                }
                case 4: {
                    return String.valueOf(this.bis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(by);
                }
                case 10: {
                    return this.readStringInternal(by);
                }
                case 12: {
                    return null;
                }
            }
            this.putTypeBack();
            String string = "";
            if (this.readingByteArray) {
                string = ERROR_MSG_SEGMENT;
            }
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(9)) + string);
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd(), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(), (Throwable)iOException);
        }
    }

    public int readBytes(byte[] byArray) throws javax.jms.JMSException {
        int n = -1;
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            if (!this.readingByteArray) {
                byte by = this.readType();
                if (by != 11) {
                    if (by == 12) {
                        return -1;
                    }
                    this.bis.unput();
                    throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), this.typeCodeToString(11)));
                }
                this.available_bytes = this.bis.readInt();
                if (this.available_bytes == 0) {
                    return 0;
                }
                this.readingByteArray = true;
            }
            if (this.available_bytes == 0) {
                this.readingByteArray = false;
                return -1;
            }
            if (byArray.length > this.available_bytes) {
                n = this.bis.read(byArray, 0, this.available_bytes);
                this.readingByteArray = false;
            } else {
                n = this.bis.read(byArray, 0, byArray.length);
                this.available_bytes -= byArray.length;
            }
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd(), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(), (Throwable)iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JMSException(JMSClientExceptionLogger.logStreamReadErrorIndexLoggable().getMessage(), (Throwable)arrayIndexOutOfBoundsException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new JMSException(JMSClientExceptionLogger.logStreamReadErrorStoreLoggable().getMessage(), (Throwable)arrayStoreException);
        }
        return n;
    }

    public Object readObject() throws javax.jms.JMSException {
        byte by = this.readType();
        try {
            switch (by) {
                case 1: {
                    return new Boolean(this.bis.readBoolean());
                }
                case 2: {
                    return new Byte(this.bis.readByte());
                }
                case 8: {
                    return new Short(this.bis.readShort());
                }
                case 3: {
                    return new Character(this.bis.readChar());
                }
                case 6: {
                    return new Integer(this.bis.readInt());
                }
                case 7: {
                    return new Long(this.bis.readLong());
                }
                case 5: {
                    return new Float(this.bis.readFloat());
                }
                case 4: {
                    return new Double(this.bis.readDouble());
                }
                case 9: {
                    return this.readStringInternal(by);
                }
                case 10: {
                    return this.readStringInternal(by);
                }
                case 12: {
                    return null;
                }
                case 11: {
                    if (this.readingByteArray) {
                        throw new MessageFormatException("Can not read next data. Previous attempt to read bytes from the stream message is not complete. As per the JMS standard, if the readBytes method does not return the value -1, a subsequent readBytes call must be made in order to ensure that there are no more bytes left to be read in. For more information, see the JMS API doc for the method readBytes in interface StreamMessage");
                    }
                    int n = this.bis.readInt();
                    byte[] byArray = new byte[n];
                    int n2 = this.bis.read(byArray, 0, n);
                    if (n2 != n) {
                        throw new EOFException("");
                    }
                    return byArray;
                }
            }
            this.bis.unput();
            throw new MessageFormatException(this.streamConversionError(this.typeCodeToString(by), "Object"));
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(this.readPastEnd(), eOFException);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamReadError(), (Throwable)iOException);
        }
    }

    public void writeBoolean(boolean bl) throws javax.jms.JMSException {
        this.writeType((byte)1);
        try {
            this.bos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(10), (Throwable)iOException);
        }
    }

    public void writeByte(byte by) throws javax.jms.JMSException {
        this.writeType((byte)2);
        try {
            this.bos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(20), (Throwable)iOException);
        }
    }

    public void writeShort(short s) throws javax.jms.JMSException {
        this.writeType((byte)8);
        try {
            this.bos.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(30), (Throwable)iOException);
        }
    }

    public void writeChar(char c) throws javax.jms.JMSException {
        this.writeType((byte)3);
        try {
            this.bos.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(40), (Throwable)iOException);
        }
    }

    public void writeInt(int n) throws javax.jms.JMSException {
        this.writeType((byte)6);
        try {
            this.bos.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(50), (Throwable)iOException);
        }
    }

    public void writeLong(long l) throws javax.jms.JMSException {
        this.writeType((byte)7);
        try {
            this.bos.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(60), (Throwable)iOException);
        }
    }

    public void writeFloat(float f) throws javax.jms.JMSException {
        this.writeType((byte)5);
        try {
            this.bos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(70), (Throwable)iOException);
        }
    }

    public void writeDouble(double d) throws javax.jms.JMSException {
        this.writeType((byte)4);
        try {
            this.bos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(80), (Throwable)iOException);
        }
    }

    public void writeString(String string) throws javax.jms.JMSException {
        if (string == null) {
            this.writeType((byte)12);
        } else {
            try {
                this.writeStringInternal(string);
            }
            catch (IOException iOException) {
                throw new JMSException(this.streamWriteError(), (Throwable)iOException);
            }
        }
    }

    public void writeBytes(byte[] byArray) throws javax.jms.JMSException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.writeType((byte)11);
        try {
            this.bos.writeInt(n2);
            this.bos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new JMSException(this.streamWriteError(100), (Throwable)iOException);
        }
    }

    public void writeObject(Object object) throws javax.jms.JMSException {
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Number) {
            if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            }
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object == null) {
            this.writeType((byte)12);
        } else {
            throw new MessageFormatException("Invalid Type: " + object.getClass().getName());
        }
    }

    public void reset() throws javax.jms.JMSException {
        this.setBodyWritable(false);
        if (this.bis != null) {
            try {
                this.bis.reset();
            }
            catch (IOException iOException) {
                throw new JMSException(this.streamReadError(217), (Throwable)iOException);
            }
        } else if (this.bos != null) {
            this.payload = (PayloadStream)this.bos.moveToPayload();
            this.bos = null;
        }
        this.copyOnWrite = false;
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        StreamMessageImpl streamMessageImpl = new StreamMessageImpl();
        super.copy(streamMessageImpl);
        if (this.bos != null) {
            streamMessageImpl.payload = this.bos.copyPayloadWithoutSharedStream();
        } else if (this.payload != null) {
            streamMessageImpl.payload = this.payload.copyPayloadWithoutSharedStream();
        }
        this.copyOnWrite = true;
        streamMessageImpl.copyOnWrite = true;
        streamMessageImpl.setBodyWritable(false);
        streamMessageImpl.setPropertiesWritable(false);
        return streamMessageImpl;
    }

    private void checkWritable() throws javax.jms.JMSException {
        super.writeMode();
        if (this.bos == null) {
            this.bos = PayloadFactoryImpl.createOutputStream();
        } else if (this.copyOnWrite) {
            this.bos.copyBuffer();
            this.copyOnWrite = false;
        }
    }

    private void checkReadable() throws javax.jms.JMSException {
        super.readMode();
        if (this.payload == null) {
            throw new MessageEOFException(this.readPastEnd3(500));
        }
        if (this.bis == null) {
            try {
                this.bis = this.payload.getInputStream();
            }
            catch (IOException iOException) {
                throw new JMSException(this.streamReadError(510), (Throwable)iOException);
            }
        }
    }

    public String toString() {
        return "StreamMessage[" + this.getJMSMessageID() + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Payload payload;
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
        } else {
            objectOutput2 = objectOutput;
        }
        int n2 = this.getVersion(objectOutput2) >= 30 ? (int)((byte)(3 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : 2;
        objectOutput2.writeByte(n2);
        if (this.isCompressed()) {
            if (n2 == 2) {
                this.decompress().writeLengthAndData(objectOutput2);
            } else {
                this.flushCompressedMessageBody(objectOutput2);
            }
            return;
        }
        if (this.bos != null) {
            payload = this.bos;
        } else if (this.payload != null) {
            payload = this.payload;
        } else {
            objectOutput2.writeInt(0);
            return;
        }
        if ((n2 & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(objectOutput2, payload);
        } else {
            payload.writeLengthAndData(objectOutput2);
        }
    }

    public final void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.cleanupCompressedMessageBody();
            throw throwable;
        }
        this.cleanupCompressedMessageBody();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0x7F);
        if (by2 < 1 || by2 > 3) {
            throw JMSUtilities.versionIOException(by2, 1, 3);
        }
        switch (by2) {
            case 3: {
                if ((by & 0xFFFFFF80) != 0) {
                    this.readExternalCompressedMessageBody(objectInput);
                    break;
                }
            }
            case 2: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                break;
            }
            case 1: {
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                BufferInputStream bufferInputStream = this.payload.getInputStream();
                ObjectInputStream objectInputStream = new ObjectInputStream(bufferInputStream);
                this.setBodyWritable(true);
                this.setPropertiesWritable(true);
                try {
                    while (true) {
                        this.writeObject(objectInputStream.readObject());
                    }
                }
                catch (EOFException eOFException) {
                    try {
                        PayloadStream payloadStream;
                        this.reset();
                        this.setPropertiesWritable(false);
                        this.payload = payloadStream = this.payload.copyPayloadWithoutSharedStream();
                    }
                    catch (javax.jms.JMSException jMSException) {
                        JMSClientExceptionLogger.logStackTrace(jMSException);
                    }
                    break;
                }
                catch (MessageNotWriteableException messageNotWriteableException) {
                    JMSClientExceptionLogger.logStackTrace(messageNotWriteableException);
                    break;
                }
                catch (javax.jms.MessageFormatException messageFormatException) {
                    JMSClientExceptionLogger.logStackTrace(messageFormatException);
                    break;
                }
                catch (javax.jms.JMSException jMSException) {
                    JMSClientExceptionLogger.logStackTrace(jMSException);
                }
            }
        }
    }

    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        if (this.bos != null) {
            return this.bos.size();
        }
        this.bodySize = 0L;
        return 0L;
    }

    private String typeCodeToString(int n) {
        try {
            return TYPE_CODE_STRINGS[n];
        }
        catch (Throwable throwable) {
            return TYPE_CODE_STRINGS[0];
        }
    }

    private void writeStringInternal(String string) throws IOException, javax.jms.JMSException {
        if (string.length() > 20000) {
            this.writeType((byte)10);
            this.bos.writeUTF32(string);
        } else {
            this.writeType((byte)9);
            this.bos.writeUTF(string);
        }
    }

    private String readStringInternal(byte by) throws IOException {
        if (by == 10) {
            return this.bis.readUTF32();
        }
        return this.bis.readUTF();
    }

    private long getLen() {
        if (this.bos != null) {
            return this.bos.size();
        }
        if (this.payload != null) {
            return this.payload.getLength();
        }
        return 0L;
    }

    public long getBodyLength() throws javax.jms.JMSException {
        super.readMode();
        return this.getLen();
    }

    public byte[] getBodyBytes() throws javax.jms.JMSException {
        Payload payload;
        if (this.payload != null) {
            payload = this.payload;
        } else if (this.bos != null) {
            payload = this.bos;
        } else {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            payload.writeTo(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
    }

    public PayloadStream getPayload() throws javax.jms.JMSException {
        if (this.isCompressed()) {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
        }
        return this.payload;
    }

    public void setPayload(PayloadStream payloadStream) {
        if (this.payload != null || this.bis != null || this.bos != null || this.copyOnWrite) {
            throw new AssertionError();
        }
        try {
            this.writeMode();
        }
        catch (javax.jms.JMSException jMSException) {
            throw new AssertionError((Object)jMSException);
        }
        this.payload = payloadStream;
    }
}

