/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.TextMessage;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadText;
import weblogic.utils.io.StringInput;
import weblogic.utils.io.StringOutput;

public final class TextMessageImpl
extends MessageImpl
implements TextMessage,
Externalizable {
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = 5844425982189539558L;
    private String text;
    private PayloadText payload;
    private byte subflag;
    private static final boolean mydebug = false;

    public TextMessageImpl() {
    }

    public TextMessageImpl(TextMessage textMessage) throws javax.jms.JMSException {
        this(textMessage, null, null);
    }

    public TextMessageImpl(TextMessage textMessage, Destination destination, Destination destination2) throws javax.jms.JMSException {
        super(textMessage, destination, destination2);
        this.setText(textMessage.getText());
    }

    public byte getType() {
        return 6;
    }

    public TextMessageImpl(String string) {
        this.text = string;
    }

    public void setText(String string) throws javax.jms.JMSException {
        this.writeMode();
        this.payload = null;
        this.text = string;
    }

    public void setUTF8Buffer(PayloadText payloadText) {
        if (this.text != null) {
            throw new AssertionError();
        }
        this.payload = payloadText;
        this.subflag = (byte)2;
    }

    public String getText() throws javax.jms.JMSException {
        if (this.text != null) {
            return this.text;
        }
        this.decompressMessageBody();
        if (this.text != null) {
            return this.text;
        }
        if (this.payload != null) {
            try {
                if ((this.subflag & 2) != 0) {
                    this.text = this.payload.readUTF8();
                } else {
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.payload.getInputStream());
                    this.text = (String)objectInputStream.readObject();
                }
                this.payload = null;
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JMSException(classNotFoundException);
            }
        }
        return this.text;
    }

    private final String interopDecompressMessageBody() throws IOException {
        String string = null;
        try {
            string = this.interopMessageBody((PayloadText)this.decompress());
        }
        catch (IOException iOException) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        return string;
    }

    private final String interopMessageBody(PayloadText payloadText) throws IOException {
        if ((this.subflag & 2) != 0) {
            return payloadText.readUTF8();
        }
        String string = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(payloadText.getInputStream());
            string = (String)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(JMSClientExceptionLogger.logErrorInteropTextMessageLoggable().getMessage());
        }
        return string;
    }

    public final Object getMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            if (this.payload != null) {
                return this.payload;
            }
            return this.text;
        }
        if (this.text != null) {
            return this.text;
        }
        try {
            PayloadText payloadText = (PayloadText)this.decompress();
            if ((this.subflag & 2) != 0) {
                return payloadText;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(payloadText.getInputStream());
            return (String)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)classNotFoundException);
        }
    }

    public final void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            block7: {
                try {
                    this.payload = (PayloadText)this.decompress();
                    if ((this.subflag & 2) != 0) {
                        this.text = this.payload.readUTF8();
                        break block7;
                    }
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.payload.getInputStream());
                    this.text = (String)objectInputStream.readObject();
                }
                catch (IOException iOException) {
                    throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)classNotFoundException);
                }
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.cleanupCompressedMessageBody();
            throw throwable;
        }
        this.cleanupCompressedMessageBody();
    }

    public void nullBody() {
        this.text = null;
        this.payload = null;
    }

    public String toString() {
        return "TextMessage[" + this.getJMSMessageID() + ", " + (this.text == null ? "null" : (this.text.length() < 40 ? this.text : this.text.substring(0, 30) + "...")) + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        boolean bl = true;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
            bl = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getReadStringAsObject();
        } else {
            objectOutput2 = objectOutput;
        }
        byte by = this.getVersion(objectOutput2) >= 30 ? (byte)((byte)(3 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : (byte)2;
        objectOutput2.writeByte(by);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            this.debugWireProtocol(by, "TextMessageImpl.write");
        }
        if ((by & 0x7F) == 3) {
            if (this.isCompressed()) {
                objectOutput2.writeByte(this.subflag);
                this.flushCompressedMessageBody(objectOutput2);
            } else if ((by & 0xFFFFFF80) != 0) {
                if (this.text != null) {
                    objectOutput2.writeByte(4);
                    this.writeExternalCompressPayload(objectOutput2, PayloadFactoryImpl.convertObjectToPayload(this.text));
                } else {
                    objectOutput2.writeByte(2);
                    this.writeExternalCompressPayload(objectOutput2, this.payload);
                }
            } else if (this.text != null) {
                objectOutput2.writeBoolean(true);
                if (objectOutput2 instanceof StringOutput) {
                    objectOutput2.writeByte(2 | (bl ? 128 : 0));
                    ((StringOutput)((Object)objectOutput2)).writeUTF8(this.text);
                } else {
                    objectOutput2.writeByte(4);
                    objectOutput2.writeObject(this.text);
                }
            } else if (this.payload != null) {
                objectOutput2.writeBoolean(true);
                if (objectOutput2 instanceof StringOutput) {
                    objectOutput2.writeByte(2 | (bl ? 128 : 0));
                } else {
                    objectOutput2.writeByte(2);
                }
                this.payload.writeLengthAndData(objectOutput2);
            } else {
                objectOutput2.writeBoolean(false);
            }
        } else {
            String string = this.text != null && this.text.length() > 0 ? this.text : (this.payload != null ? this.interopMessageBody(this.payload) : (this.isCompressed() ? this.interopDecompressMessageBody() : null));
            if (string != null) {
                objectOutput2.writeBoolean(true);
                objectOutput2.writeObject(string);
            } else {
                objectOutput2.writeBoolean(false);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl = false;
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0x7F);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            this.debugWireProtocol(by, "TextMessageImpl.read ");
        }
        if (by2 == 1) {
            if (objectInput.readBoolean()) {
                this.text = objectInput.readUTF();
            }
            return;
        }
        if (by2 == 2) {
            if (objectInput.readBoolean()) {
                this.text = (String)objectInput.readObject();
            }
            return;
        }
        if (by2 != 3) {
            throw JMSUtilities.versionIOException(by2, 1, 3);
        }
        if ((by & 0xFFFFFF80) != 0) {
            this.subflag = objectInput.readByte();
            this.readExternalCompressedMessageBody(objectInput);
            return;
        }
        if (!objectInput.readBoolean()) {
            return;
        }
        byte by3 = objectInput.readByte();
        if ((by3 & 2) != 0) {
            if (objectInput instanceof StringInput) {
                this.text = ((StringInput)((Object)objectInput)).readUTF8();
            } else {
                this.payload = (PayloadText)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                this.subflag = (byte)-126;
            }
        } else {
            this.text = (String)objectInput.readObject();
        }
    }

    private void debugWireProtocol(byte by, String string) {
        JMSDebug.JMSDispatcher.debug(string + " versionInt 0x" + Integer.toHexString(by).toUpperCase() + ((by & 0xFFFFFF80) != 0 ? " compress on" : " compress off"));
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        this.copy(textMessageImpl);
        textMessageImpl.text = this.text;
        if (this.payload != null) {
            textMessageImpl.payload = this.payload.copyPayloadWithoutSharedText();
        }
        textMessageImpl.subflag = this.subflag;
        textMessageImpl.setBodyWritable(false);
        textMessageImpl.setPropertiesWritable(false);
        return textMessageImpl;
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.isCompressed()) {
            this.bodySize = this.getCompressedMessageBodySize();
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        if (this.payload != null) {
            this.bodySize = this.payload.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }
}

