/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.CharArrayWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.jms.extensions.XMLMessage;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.utils.io.StringInput;
import weblogic.utils.io.StringOutput;
import weblogic.xml.dom.DOMDeserializer;
import weblogic.xml.dom.DOMSerializer;
import weblogic.xml.stax.bin.BinaryXMLStreamReader;
import weblogic.xml.stax.bin.BinaryXMLStreamWriter;

public final class XMLMessageImpl
extends MessageImpl
implements XMLMessage,
Externalizable {
    private static final long serialVersionUID = -7021112875012439613L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSIONMASK = 127;
    private static final boolean mydebug = false;
    private String text;
    private PayloadStream payloadToken;
    private PayloadText payloadText;
    private byte subflag = 0;
    private WeakReference selectedDocument;

    public XMLMessageImpl() {
    }

    public XMLMessageImpl(String string) {
        this.text = string;
    }

    public XMLMessageImpl(Document document) throws javax.jms.JMSException {
        this.setDocumentInternal(document);
    }

    public void setText(String string) throws javax.jms.JMSException {
        this.writeMode();
        this.text = string;
        this.payloadToken = null;
        this.payloadText = null;
    }

    public String getText() throws javax.jms.JMSException {
        this.decompressMessageBody();
        if (this.text != null) {
            return this.text;
        }
        if (this.payloadText != null) {
            try {
                this.text = this.payloadText.readUTF8();
                this.payloadText = null;
                return this.text;
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
        }
        Document document = null;
        if (this.payloadToken != null) {
            try {
                document = XMLMessageImpl.detokenize(this.payloadToken);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw XMLMessageImpl.serializationJMSException(parserConfigurationException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw XMLMessageImpl.serializationJMSException(xMLStreamException);
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
        }
        if (document != null) {
            try {
                this.text = XMLMessageImpl.serialize(document);
            }
            catch (TransformerException transformerException) {
                throw XMLMessageImpl.serializationJMSException(transformerException);
            }
            return this.text;
        }
        return null;
    }

    public synchronized void setDocument(Document document) throws javax.jms.JMSException {
        this.writeMode();
        this.text = null;
        this.payloadText = null;
        this.setDocumentInternal(document);
    }

    private void setDocumentInternal(Document document) throws javax.jms.JMSException {
        try {
            this.payloadToken = document == null ? null : XMLMessageImpl.tokenize(document);
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLMessageImpl.serializationJMSException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
    }

    public Document getDocument() throws javax.jms.JMSException {
        this.decompressMessageBody();
        if (this.payloadToken != null) {
            try {
                return XMLMessageImpl.detokenize(this.payloadToken);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw XMLMessageImpl.deserializationJMSException(parserConfigurationException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw XMLMessageImpl.deserializationJMSException(xMLStreamException);
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
        }
        if (this.payloadText != null) {
            try {
                this.text = this.payloadText.readUTF8();
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
            this.payloadText = null;
        }
        if (this.text != null) {
            try {
                return XMLMessageImpl.deserialize(this.text);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw XMLMessageImpl.deserializationJMSException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw XMLMessageImpl.deserializationJMSException(sAXException);
            }
            catch (IOException iOException) {
                throw XMLMessageImpl.deserializationJMSException(iOException);
            }
        }
        return null;
    }

    public byte getType() {
        return 7;
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        XMLMessageImpl xMLMessageImpl = new XMLMessageImpl();
        this.copy(xMLMessageImpl);
        xMLMessageImpl.text = this.text;
        if (this.payloadToken != null) {
            xMLMessageImpl.payloadToken = this.payloadToken.copyPayloadWithoutSharedStream();
        }
        if (this.payloadText != null) {
            xMLMessageImpl.payloadText = this.payloadText.copyPayloadWithoutSharedText();
        }
        xMLMessageImpl.subflag = this.subflag;
        return xMLMessageImpl;
    }

    public static Document deserialize(String string) throws ParserConfigurationException, SAXException, IOException {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("XMLMessageImpl.parse(): message: " + string);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(string)));
    }

    private static String serialize(Document document) throws TransformerException {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("XMLMessageImpl.serialize(): " + document);
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(charArrayWriter);
        transformer.transform(dOMSource, streamResult);
        return charArrayWriter.toString();
    }

    private static PayloadStream tokenize(Document document) throws XMLStreamException, IOException {
        BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
        BinaryXMLStreamWriter binaryXMLStreamWriter = new BinaryXMLStreamWriter(bufferOutputStream);
        DOMSerializer.serialize(document, binaryXMLStreamWriter);
        return (PayloadStream)bufferOutputStream.moveToPayload();
    }

    private static Document detokenize(PayloadStream payloadStream) throws XMLStreamException, ParserConfigurationException, IOException {
        BufferInputStream bufferInputStream = payloadStream.getInputStream();
        BinaryXMLStreamReader binaryXMLStreamReader = new BinaryXMLStreamReader(bufferInputStream);
        return (Document)DOMDeserializer.deserialize(binaryXMLStreamReader);
    }

    public Object parse() throws Exception {
        Document document = null;
        if (this.selectedDocument != null) {
            document = (Document)this.selectedDocument.get();
        }
        if (document != null) {
            return document;
        }
        this.selectedDocument = null;
        document = this.getDocumentForSelection();
        if (document != null) {
            this.selectedDocument = new WeakReference<Document>(document);
        }
        return document;
    }

    public void nullBody() {
        this.text = null;
        this.payloadText = null;
        this.payloadToken = null;
    }

    private static javax.jms.JMSException serializationJMSException(Exception exception) {
        javax.jms.JMSException jMSException = new javax.jms.JMSException("failed to serialize message");
        jMSException.initCause(exception);
        return jMSException;
    }

    private static javax.jms.JMSException deserializationJMSException(Exception exception) {
        javax.jms.JMSException jMSException = new javax.jms.JMSException("failed to deserialize message");
        jMSException.initCause(exception);
        return jMSException;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XMLMessage[id=" + this.getJMSMessageID() + ",text=\n");
        try {
            stringBuffer.append(this.getText());
        }
        catch (javax.jms.JMSException jMSException) {
            stringBuffer.append(StackTraceUtilsClient.throwable2StackTrace(jMSException));
        }
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        boolean bl = true;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
            bl = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getReadStringAsObject();
        } else {
            objectOutput2 = objectOutput;
        }
        int n2 = objectOutput2 instanceof PeerInfoable ? (((PackageInfo)(object = ((PeerInfoable)((Object)objectOutput2)).getPeerInfo())).getMajor() >= 9 ? (int)((byte)(3 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : 2) : 3;
        objectOutput2.writeByte(n2);
        if ((n2 & 0x7F) == 3) {
            if (this.isCompressed()) {
                objectOutput2.writeByte(this.subflag);
                this.flushCompressedMessageBody(objectOutput2);
            } else if ((n2 & 0xFFFFFF80) != 0) {
                if (this.payloadToken != null) {
                    objectOutput2.writeByte(1);
                    this.writeExternalCompressPayload(objectOutput2, this.payloadToken);
                } else if (this.payloadText != null) {
                    objectOutput2.writeByte(2);
                    this.writeExternalCompressPayload(objectOutput2, this.payloadText);
                } else {
                    objectOutput2.writeByte(4);
                    this.writeExternalCompressPayload(objectOutput2, PayloadFactoryImpl.convertObjectToPayload(this.text));
                }
            } else if (this.payloadToken != null) {
                objectOutput2.writeBoolean(true);
                objectOutput2.writeByte(1);
                this.payloadToken.writeLengthAndData(objectOutput2);
            } else if (this.text != null && this.text.length() > 0) {
                objectOutput2.writeBoolean(true);
                if (objectOutput2 instanceof StringOutput) {
                    objectOutput2.writeByte(2 | (bl ? 128 : 0));
                    ((StringOutput)((Object)objectOutput2)).writeUTF8(this.text);
                } else {
                    objectOutput2.writeByte(4);
                    objectOutput2.writeObject(this.text);
                }
            } else if (this.payloadText != null) {
                objectOutput2.writeBoolean(true);
                objectOutput2.writeByte(2 | (bl ? 128 : 0));
                this.payloadText.writeLengthAndData(objectOutput2);
            } else {
                objectOutput2.writeBoolean(false);
            }
        } else {
            object = null;
            PayloadText payloadText = null;
            PayloadStream payloadStream = null;
            int n3 = 0;
            if (this.isCompressed()) {
                n3 = this.subflag;
            } else if (this.text != null) {
                object = this.text;
            } else if (this.payloadText != null) {
                payloadText = this.payloadText;
                n3 = 2;
            } else if (this.payloadToken != null) {
                payloadStream = this.payloadToken;
                n3 = 1;
            }
            if (object == null && (payloadText != null || payloadStream != null)) {
                if ((n3 & 2) != 0) {
                    object = this.payloadText.readUTF8();
                } else {
                    if ((n3 & 4) != 0) {
                        try {
                            BufferInputStream bufferInputStream = payloadText.getInputStream();
                            ObjectInputStream objectInputStream = new ObjectInputStream(bufferInputStream);
                            object = (String)objectInputStream.readObject();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            IOException iOException = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            iOException.initCause(classNotFoundException);
                            throw iOException;
                        }
                    }
                    if ((n3 & 1) != 0) {
                        Document document = null;
                        try {
                            document = XMLMessageImpl.detokenize(payloadStream);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            IOException iOException = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            iOException.initCause(parserConfigurationException);
                            throw iOException;
                        }
                        catch (XMLStreamException xMLStreamException) {
                            IOException iOException = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            iOException.initCause(xMLStreamException);
                            throw iOException;
                        }
                        try {
                            object = XMLMessageImpl.serialize(document);
                        }
                        catch (TransformerException transformerException) {
                            IOException iOException = new IOException(JMSClientExceptionLogger.logErrorInteropXMLMessageLoggable().getMessage());
                            iOException.initCause(transformerException);
                            throw iOException;
                        }
                    }
                }
            }
            if (object != null && ((String)object).length() > 0) {
                objectOutput2.writeBoolean(true);
                objectOutput2.writeObject(object);
            } else {
                objectOutput2.writeBoolean(false);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        switch (by & 0x7F) {
            case 1: {
                this.text = objectInput.readUTF();
                break;
            }
            case 2: {
                if (!objectInput.readBoolean()) break;
                this.text = (String)objectInput.readObject();
                break;
            }
            case 3: {
                if ((by & 0xFFFFFF80) != 0) {
                    this.subflag = objectInput.readByte();
                    this.readExternalCompressedMessageBody(objectInput);
                    break;
                }
                boolean bl = objectInput.readBoolean();
                if (!bl) break;
                byte by2 = objectInput.readByte();
                if ((by2 & 1) != 0) {
                    this.payloadToken = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                    break;
                }
                if ((by2 & 2) != 0) {
                    if (objectInput instanceof StringInput && (by2 & 0x80) != 0) {
                        this.text = ((StringInput)((Object)objectInput)).readUTF8();
                        break;
                    }
                    this.payloadText = (PayloadText)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
                    break;
                }
                if ((by2 & 4) == 0) break;
                this.text = (String)objectInput.readObject();
                break;
            }
            default: {
                throw JMSUtilities.versionIOException(by, 1, 3);
            }
        }
    }

    public long getPayloadSize() {
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        if (this.isCompressed()) {
            this.bodySize = this.getCompressedMessageBodySize();
            return this.bodySize;
        }
        if (this.text != null) {
            this.bodySize = this.text.length();
            return this.bodySize;
        }
        if (this.payloadToken != null) {
            this.bodySize = this.payloadToken.getLength();
            return this.bodySize;
        }
        if (this.payloadText != null) {
            this.bodySize = this.payloadText.getLength();
            return this.bodySize;
        }
        this.bodySize = 0L;
        return 0L;
    }

    public void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            Payload payload = this.decompress();
            if ((this.subflag & 2) != 0) {
                this.text = ((PayloadText)payload).readUTF8();
            } else if ((this.subflag & 4) != 0) {
                ObjectInputStream objectInputStream = new ObjectInputStream(payload.getInputStream());
                this.text = (String)objectInputStream.readObject();
            } else if ((this.subflag & 1) != 0) {
                this.payloadToken = (PayloadStream)payload;
            }
            this.cleanupCompressedMessageBody();
        }
        catch (IOException iOException) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)classNotFoundException);
        }
    }

    private Document getDocumentForSelection() throws javax.jms.JMSException {
        Document document = null;
        String string = this.text;
        PayloadStream payloadStream = this.payloadToken;
        PayloadText payloadText = this.payloadText;
        if (this.isCompressed()) {
            try {
                Payload payload = this.decompress();
                if ((this.subflag & 2) != 0) {
                    string = ((PayloadText)payload).readUTF8();
                } else if ((this.subflag & 4) != 0) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(payload.getInputStream());
                    string = (String)objectInputStream.readObject();
                } else if ((this.subflag & 1) != 0) {
                    payloadStream = (PayloadStream)payload;
                }
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDeserializeMessageBodyLoggable().getMessage(), (Throwable)classNotFoundException);
            }
        }
        if (payloadStream != null) {
            try {
                document = XMLMessageImpl.detokenize(payloadStream);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw XMLMessageImpl.deserializationJMSException(parserConfigurationException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw XMLMessageImpl.deserializationJMSException(xMLStreamException);
            }
            catch (IOException iOException) {
                throw XMLMessageImpl.deserializationJMSException(iOException);
            }
        }
        if (payloadText != null) {
            try {
                string = payloadText.readUTF8();
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
        }
        if (string != null) {
            try {
                document = XMLMessageImpl.deserialize(string);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw XMLMessageImpl.deserializationJMSException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw XMLMessageImpl.deserializationJMSException(sAXException);
            }
            catch (IOException iOException) {
                throw XMLMessageImpl.deserializationJMSException(iOException);
            }
        }
        return document;
    }
}

