/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.lang.reflect.Method;
import javax.naming.Context;
import weblogic.jms.JMSEnvironment;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.kernel.KernelStatus;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherImpl;
import weblogic.messaging.dispatcher.DispatcherManager;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class JMSDispatcherManager {
    private static final String JMS_REQUEST_QUEUE = "JmsDispatcher";
    private static final String JMS_ASYNC_REQUEST_QUEUE = "JmsAsyncQueue";
    public static final String PREFIX_SERVER_NAME = "weblogic.jms.S:";
    private static final String PREFIX_CLIENT_NAME = "weblogic.jms.C:";
    private static final String SERVER_OBJECT_HANDLER_CLASS_NAME = "weblogic.jms.dispatcher.DispatcherObjectHandler";
    private static final String CLIENT_OBJECT_HANDLER_CLASS_NAME = "weblogic.jms.dispatcher.ClientDispatcherObjectHandler";
    private static DispatcherAdapter localDispatcher;
    private static int exportCount;
    private static WorkManager jmsDispatcherWorkManager;
    private static WorkManager oneWayWorkManager;

    public static void initialize(String string, String string2, boolean bl) {
        if (localDispatcher == null) {
            Object object;
            int n;
            if (KernelStatus.isServer()) {
                if (bl) {
                    n = JMSDispatcherManager.getJMSThreadPoolSize();
                    if (n < 5) {
                        n = 5;
                    }
                } else {
                    n = 1;
                }
            } else if (JMSEnvironment.getJMSEnvironment().isThinClient()) {
                n = 0;
                object = null;
                try {
                    object = System.getProperty("weblogic.JMSThreadPoolSize");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (object != null) {
                    try {
                        n = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n < 5 && n > 0) {
                        n = 5;
                    }
                }
            } else {
                n = JMSDispatcherManager.getJMSThreadPoolSize();
            }
            jmsDispatcherWorkManager = bl ? WorkManagerFactory.getInstance().findOrCreate(JMS_REQUEST_QUEUE, -1, n, -1) : WorkManagerFactory.getInstance().findOrCreate(JMS_REQUEST_QUEUE, 100, n, -1);
            oneWayWorkManager = WorkManagerFactory.getInstance().findOrCreate(JMS_ASYNC_REQUEST_QUEUE, 100, 1, -1);
            object = DispatcherManager.createLocalDispatcher(string, string2, jmsDispatcherWorkManager, oneWayWorkManager, JMSEnvironment.getJMSEnvironment().isServer() ? SERVER_OBJECT_HANDLER_CLASS_NAME : CLIENT_OBJECT_HANDLER_CLASS_NAME);
            localDispatcher = new DispatcherAdapter((Dispatcher)object);
        }
    }

    private static int getJMSThreadPoolSize() {
        try {
            Class<?> clazz = Class.forName("weblogic.kernel.Kernel");
            Method method = clazz.getMethod("ensureInitialized", new Class[0]);
            method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getConfig", new Class[0]);
            Object object = method2.invoke(null, new Object[0]);
            Class<?> clazz2 = Class.forName("weblogic.management.configuration.KernelMBean");
            Method method3 = clazz2.getMethod("getJMSThreadPoolSize", new Class[0]);
            Object object2 = method3.invoke(object, new Object[0]);
            return (Integer)object2;
        }
        catch (Throwable throwable) {
            throw new Error("Call BEA Support ", throwable);
        }
    }

    public static String generateDispatcherName() {
        return PREFIX_CLIENT_NAME + DispatcherManager.getHostAddress() + ":" + Long.toString(System.currentTimeMillis() & 0xFFFFL, 36) + ":" + Long.toString(DispatcherManager.generateRandomLong(), 36);
    }

    static WorkManager getWorkManager() {
        return jmsDispatcherWorkManager;
    }

    public static JMSDispatcher getLocalDispatcher() {
        if (localDispatcher != null) {
            return localDispatcher;
        }
        String string = JMSDispatcherManager.generateDispatcherName();
        JMSDispatcherManager.initialize(string, null, false);
        return localDispatcher;
    }

    public static JMSDispatcher addDispatcherReference(DispatcherWrapper dispatcherWrapper) throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.addDispatcherReference(dispatcherWrapper);
        return new DispatcherAdapter(dispatcher);
    }

    public static JMSDispatcher dispatcherFind(DispatcherId dispatcherId) throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.dispatcherFind(dispatcherId);
        return new DispatcherAdapter(dispatcher);
    }

    public static void removeDispatcherReference(JMSDispatcher jMSDispatcher) {
        Dispatcher dispatcher = jMSDispatcher.getDelegate();
        DispatcherManager.removeDispatcherReference(dispatcher, false);
    }

    public static JMSDispatcher dispatcherFindOrCreate(Context context, DispatcherId dispatcherId) throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.dispatcherFindOrCreate(context, dispatcherId);
        return new DispatcherAdapter(dispatcher);
    }

    public static JMSDispatcher dispatcherFindOrCreate(DispatcherId dispatcherId) throws DispatcherException {
        Dispatcher dispatcher = DispatcherManager.dispatcherFindOrCreate(dispatcherId);
        return new DispatcherAdapter(dispatcher);
    }

    public static DispatcherWrapper getLocalDispatcherWrapper() {
        return new DispatcherWrapper((DispatcherImpl)JMSDispatcherManager.getLocalDispatcher().getDelegate());
    }

    public static synchronized void exportLocalDispatcher() {
        if (++exportCount == 1) {
            DispatcherManager.export(JMSDispatcherManager.getLocalDispatcher().getDelegate());
        }
    }

    public static synchronized void unexportLocalDispatcher() {
        if (--exportCount == 0) {
            DispatcherManager.unexport(JMSDispatcherManager.getLocalDispatcher().getDelegate());
        }
    }

    public static String getDispatcherJNDIName(DispatcherId dispatcherId) {
        return "weblogic.messaging.dispatcher.S:" + dispatcherId;
    }
}

