/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.Response;
import weblogic.rmi.extensions.AsyncResultListener;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.work.WorkManager;

public abstract class Request
extends weblogic.messaging.dispatcher.Request
implements Runnable,
AsyncResultListener,
Externalizable {
    static final long serialVersionUID = -3580248041850964617L;

    public Request(JMSID jMSID, int n) {
        super(jMSID, n, VoidResponse.THE_ONE, InvocableManagerDelegate.delegate.getInvocableManager());
    }

    protected Throwable getAppException(String string, Throwable throwable) {
        return new JMSException(string, throwable);
    }

    public synchronized Response getResult() throws javax.jms.JMSException {
        try {
            return super.getResult();
        }
        catch (Throwable throwable) {
            return Request.handleThrowable(throwable);
        }
    }

    protected WorkManager getDefaultWorkManager() {
        return JMSDispatcherManager.getWorkManager();
    }

    public synchronized Response useChildResult(Class clazz) throws javax.jms.JMSException {
        Response response = ((Request)super.getChild()).getResult();
        this.setResult(response);
        this.setState(Integer.MAX_VALUE);
        return response;
    }

    public static Response handleThrowable(Throwable throwable) throws javax.jms.JMSException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof javax.jms.JMSException) {
            throw (javax.jms.JMSException)StackTraceUtilsClient.getThrowableWithCause(throwable);
        }
        throw new JMSException(throwable.getMessage(), throwable);
    }

    public void dispatchAsync(JMSDispatcher jMSDispatcher, weblogic.messaging.dispatcher.Request request) throws DispatcherException {
        super.dispatchAsync(jMSDispatcher.getDelegate(), request);
    }

    public void run() {
        try {
            JMSDispatcherManager.getLocalDispatcher().dispatchAsync(this);
        }
        catch (DispatcherException dispatcherException) {
            // empty catch block
        }
    }

    public Request() {
        this.setAppInvocableManager(InvocableManagerDelegate.delegate.getInvocableManager());
        this.setAppVoidResponse(VoidResponse.THE_ONE);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput, new JMSID(), InvocableManagerDelegate.delegate.getInvocableManager());
    }
}

