/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.jms.common.CDS;
import weblogic.jms.common.CDSSecurityHandle;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipChangeEventImpl;
import weblogic.jms.common.DDMembershipChangeListener;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.extensions.DestinationAvailabilityListener;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.jms.extensions.DestinationDetailImpl;
import weblogic.jms.extensions.RegistrationHandle;
import weblogic.kernel.KernelStatus;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.work.InheritableThreadContext;

public class JMSDestinationAvailabilityHelper {
    private static final int REGISTRATION_MODE_DEFAULT = 0;
    private static final int REGISTRATION_MODE_LOCAL_ONLY = 1;
    private static final int REGISTRATION_MODE_ALL = 2;
    private static JMSDestinationAvailabilityHelper INSTANCE = new JMSDestinationAvailabilityHelper();
    private String currentServerName = null;
    private String currentClusterName = null;
    private String currentDomainName = null;
    private boolean isServer;
    private static boolean coreEngine = false;
    private static boolean initialized = false;
    private static final String DDHM_NAME = "weblogic.jms.common.JMSDestinationAvailabilityHelperManager";

    private JMSDestinationAvailabilityHelper() {
    }

    private void initialize() {
        try {
            if (KernelStatus.isServer() && !coreEngine) {
                Class<?> clazz = Class.forName("weblogic.jms.common.JMSManagementHelper");
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("getServerName", new Class[0]);
                this.currentServerName = (String)method.invoke(obj, new Object[0]);
                method = clazz.getMethod("getClusterName", new Class[0]);
                this.currentClusterName = (String)method.invoke(obj, new Object[0]);
                method = clazz.getMethod("getDomainName", new Class[0]);
                this.currentDomainName = (String)method.invoke(obj, new Object[0]);
            } else {
                this.currentServerName = "";
                CrossDomainSecurityManager.ensureSubjectManagerInitialized();
            }
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        initialized = true;
    }

    public static synchronized JMSDestinationAvailabilityHelper getInstance() {
        if (!initialized) {
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public RegistrationHandle register(Hashtable hashtable, String string, DestinationAvailabilityListener destinationAvailabilityListener) {
        return this.register(new PropertiesContextFactory(hashtable), string, destinationAvailabilityListener, 2);
    }

    private RegistrationHandle register(Hashtable hashtable, String string, DestinationAvailabilityListener destinationAvailabilityListener, int n) {
        return this.register(new PropertiesContextFactory(hashtable), string, destinationAvailabilityListener, n);
    }

    private RegistrationHandle register(ContextFactory contextFactory, String string, DestinationAvailabilityListener destinationAvailabilityListener, int n) {
        if (string == null) {
            throw new AssertionError((Object)"register(): destJNDIName cannot be null");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new AssertionError((Object)("register(): Invalid registration mode " + n));
        }
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Registering the listener " + destinationAvailabilityListener + " for destJNDIName=" + string);
        }
        DestinationAvailabilityListenerWrapper destinationAvailabilityListenerWrapper = new DestinationAvailabilityListenerWrapper(contextFactory, string, destinationAvailabilityListener, n);
        CDSSecurityHandle cDSSecurityHandle = CDS.getCDS().registerForDDMembershipInformation(destinationAvailabilityListenerWrapper);
        if (JMSDebug.JMSCDS.isDebugEnabled()) {
            JMSDebug.JMSCDS.debug("Successfully registered the listener " + destinationAvailabilityListener + " for destJNDIName=" + string);
        }
        contextFactory.setSecurityHandle(cDSSecurityHandle);
        return destinationAvailabilityListenerWrapper;
    }

    private boolean isLocalWLSServer(DDMemberInformation dDMemberInformation) {
        return this.currentDomainName != null && this.currentDomainName.equals(dDMemberInformation.getDDMemberDomainName()) && this.currentServerName != null && this.currentServerName.equals(dDMemberInformation.getDDMemberServerName());
    }

    private boolean isLocalCluster(DDMemberInformation dDMemberInformation) {
        return this.currentDomainName != null && this.currentDomainName.equals(dDMemberInformation.getDDMemberDomainName()) && this.currentClusterName != null && this.currentClusterName.equals(dDMemberInformation.getDDMemberClusterName());
    }

    private boolean isLocalServerDDMember(DDMemberInformation dDMemberInformation) {
        return this.currentServerName != null && this.currentServerName.equals(dDMemberInformation.getDDMemberServerName()) && this.currentClusterName.equals(dDMemberInformation.getDDMemberClusterName()) && this.currentDomainName.equals(dDMemberInformation.getDDMemberDomainName());
    }

    private boolean isRemoteClusterDDMember(DDMemberInformation dDMemberInformation) {
        return this.currentDomainName == null || this.currentClusterName == null || !this.currentClusterName.equals(dDMemberInformation.getDDMemberClusterName()) || !this.currentDomainName.equals(dDMemberInformation.getDDMemberDomainName());
    }

    private DDMemberInformation[] getLocalServerDDMembers(DDMemberInformation[] dDMemberInformationArray) {
        ArrayList<DDMemberInformation> arrayList = new ArrayList<DDMemberInformation>();
        if (dDMemberInformationArray != null) {
            for (int i = 0; i < dDMemberInformationArray.length; ++i) {
                if (!this.isLocalServerDDMember(dDMemberInformationArray[i])) continue;
                arrayList.add(dDMemberInformationArray[i]);
            }
        }
        if (arrayList.size() != 0) {
            return arrayList.toArray(new DDMemberInformation[arrayList.size()]);
        }
        return null;
    }

    private DDMemberInformation[] getRemoteClusterDDMembers(DDMemberInformation[] dDMemberInformationArray) {
        ArrayList<DDMemberInformation> arrayList = new ArrayList<DDMemberInformation>();
        if (dDMemberInformationArray != null) {
            for (int i = 0; i < dDMemberInformationArray.length; ++i) {
                if (!this.isRemoteClusterDDMember(dDMemberInformationArray[i])) continue;
                arrayList.add(dDMemberInformationArray[i]);
            }
        }
        if (arrayList.size() != 0) {
            return arrayList.toArray(new DDMemberInformation[arrayList.size()]);
        }
        return null;
    }

    private DDMemberInformation[] filterDDMembers(DestinationAvailabilityListenerWrapper destinationAvailabilityListenerWrapper, DDMemberInformation[] dDMemberInformationArray) {
        DDMemberInformation[] dDMemberInformationArray2 = null;
        assert (destinationAvailabilityListenerWrapper != null);
        if (!this.isServer) {
            return dDMemberInformationArray;
        }
        int n = destinationAvailabilityListenerWrapper.getMode();
        if (dDMemberInformationArray != null) {
            if (n == 0) {
                DDMemberInformation[] dDMemberInformationArray3 = this.getLocalServerDDMembers(dDMemberInformationArray);
                dDMemberInformationArray2 = dDMemberInformationArray3 != null ? dDMemberInformationArray3 : this.getRemoteClusterDDMembers(dDMemberInformationArray);
            } else if (n == 1) {
                DDMemberInformation[] dDMemberInformationArray4 = this.getLocalServerDDMembers(dDMemberInformationArray);
                if (dDMemberInformationArray4 != null) {
                    dDMemberInformationArray2 = dDMemberInformationArray4;
                }
            } else {
                dDMemberInformationArray2 = dDMemberInformationArray;
            }
        }
        return dDMemberInformationArray2;
    }

    private int getDestinationTypeAsInt(DDMemberInformation dDMemberInformation) {
        boolean bl = dDMemberInformation.isDD();
        String string = dDMemberInformation.getDDType();
        if (!string.equals("javax.jms.Queue") && !string.equals("javax.jms.Topic")) {
            throw new AssertionError((Object)"Unknown Destination Type");
        }
        boolean bl2 = string.equals("javax.jms.Queue");
        if (dDMemberInformation.getDestination() != null) {
            if (bl) {
                if (bl2) {
                    return 4;
                }
                if (dDMemberInformation.getForwardingPolicy() == 0) {
                    return 6;
                }
                return 5;
            }
            if (bl2) {
                return 0;
            }
            return 1;
        }
        if (bl2) {
            return 2;
        }
        return 3;
    }

    private DestinationDetail createDestinationDetailFromDDMemberInformation(DDMemberInformation dDMemberInformation) {
        int n = this.getDestinationTypeAsInt(dDMemberInformation);
        if (n != 2 && n != 3) {
            DestinationImpl destinationImpl = (DestinationImpl)dDMemberInformation.getDestination();
            return new DestinationDetailImpl(dDMemberInformation.getDDConfigName(), dDMemberInformation.getDDJNDIName(), this.getDestinationTypeAsInt(dDMemberInformation), dDMemberInformation.getMemberName(), dDMemberInformation.getDDMemberJndiName(), dDMemberInformation.getDDMemberLocalJndiName(), destinationImpl.getCreateDestinationArgument(), destinationImpl.isPre90() ? null : destinationImpl.getServerName(), destinationImpl.getPersistentStoreName(), destinationImpl, dDMemberInformation.getDDMemberServerName(), dDMemberInformation.getDDMemberMigratableTargetName(), this.isLocalWLSServer(dDMemberInformation), this.isLocalCluster(dDMemberInformation), dDMemberInformation.isAdvancedTopicSupported());
        }
        return new DestinationDetailImpl(dDMemberInformation.getDDConfigName(), dDMemberInformation.getDDJNDIName(), this.getDestinationTypeAsInt(dDMemberInformation), dDMemberInformation.getMemberName(), dDMemberInformation.getDDMemberJndiName(), dDMemberInformation.getDDMemberLocalJndiName(), null, null, null, null, dDMemberInformation.getDDMemberServerName(), dDMemberInformation.getDDMemberMigratableTargetName(), this.isLocalWLSServer(dDMemberInformation), this.isLocalCluster(dDMemberInformation), dDMemberInformation.isAdvancedTopicSupported());
    }

    private void printDDMemberInfo(DDMemberInformation[] dDMemberInformationArray) {
        if (dDMemberInformationArray == null) {
            return;
        }
        for (int i = 0; i < dDMemberInformationArray.length; ++i) {
            System.out.println("member[" + i + "]:" + dDMemberInformationArray[i].toString());
        }
    }

    static {
        try {
            Class.forName("com.bea.core.encryption.EncryptionService");
            coreEngine = true;
        }
        catch (Throwable throwable) {
            coreEngine = false;
        }
    }

    private static interface ContextFactory {
        public Context getJNDIContext() throws NamingException;

        public AbstractSubject getRegistrationSubject();

        public void close();

        public String getProviderURL();

        public void refreshCtx() throws NamingException;

        public void setSecurityHandle(CDSSecurityHandle var1);

        public Object lookup(String var1) throws NamingException;

        public AbstractSubject getRightJNDISubject();

        public AbstractSubject getRightJMSSubject();

        public AbstractSubject getOrigSubject();

        public boolean isOrigSubDowngraded();
    }

    private final class RefreshWaitLock {
        int waiters;
        NamingException ne;

        private RefreshWaitLock() {
        }

        private synchronized void complete(NamingException namingException) {
            this.ne = namingException;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }

        private synchronized boolean waitUntilComplete() throws NamingException {
            if (this.waiters == 0) {
                return false;
            }
            ++this.waiters;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.waiters;
            if (this.ne != null) {
                throw this.ne;
            }
            return true;
        }
    }

    private class PropertiesContextFactory
    implements ContextFactory {
        final Hashtable properties;
        AbstractSubject origSubject;
        AbstractSubject registrationSubject;
        Context ctx;
        CDSSecurityHandle secHandle;
        boolean origSubDowngraded = false;
        RefreshWaitLock refreshWaitLock = new RefreshWaitLock();
        InheritableThreadContext originalContext;

        PropertiesContextFactory(Hashtable hashtable) {
            this.properties = hashtable == null ? new Hashtable() : new Hashtable(hashtable);
            this.properties.put("weblogic.jndi.disableLoggingOfWarningMsg", "true");
            this.origSubject = CrossDomainSecurityManager.getCurrentSubject();
            if (this.origSubject == null || JMSDestinationAvailabilityHelper.this.isServer && CrossDomainSecurityManager.getCrossDomainSecurityUtil().isKernelIdentity(this.origSubject)) {
                this.origSubject = SubjectManager.getSubjectManager().getAnonymousSubject();
                this.origSubDowngraded = true;
            }
            this.originalContext = InheritableThreadContext.getContext();
        }

        public AbstractSubject getOrigSubject() {
            return this.origSubject;
        }

        public boolean isOrigSubDowngraded() {
            return this.origSubDowngraded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context getJNDIContext() throws NamingException {
            this.refreshCtx();
            PropertiesContextFactory propertiesContextFactory = this;
            synchronized (propertiesContextFactory) {
                return this.ctx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshCtx() throws NamingException {
            ClassLoader classLoader = this.originalContext.pushMultiThread();
            try {
                if (this.refreshWaitLock.waitUntilComplete()) {
                    Object var9_2 = null;
                    this.originalContext.popMultiThread(classLoader);
                    return;
                }
                NamingException namingException = null;
                InitialContext initialContext = null;
                AbstractSubject abstractSubject = null;
                try {
                    initialContext = this.properties == null ? new InitialContext() : new InitialContext(this.properties);
                    abstractSubject = CrossDomainSecurityManager.getCurrentSubject();
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                }
                catch (Throwable throwable) {
                    namingException = new NamingException(throwable.getMessage());
                    namingException.setRootCause(throwable);
                }
                PropertiesContextFactory propertiesContextFactory = this;
                synchronized (propertiesContextFactory) {
                    if (this.ctx != null) {
                        try {
                            this.ctx.close();
                        }
                        catch (NamingException namingException3) {
                            // empty catch block
                        }
                    }
                    this.ctx = initialContext;
                    if (namingException == null) {
                        this.registrationSubject = abstractSubject;
                    }
                }
                this.refreshWaitLock.complete(namingException);
                if (namingException != null) {
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                Object var9_4 = null;
                this.originalContext.popMultiThread(classLoader);
                throw throwable;
            }
            Object var9_3 = null;
            this.originalContext.popMultiThread(classLoader);
        }

        public synchronized AbstractSubject getRegistrationSubject() {
            return this.registrationSubject;
        }

        public synchronized void close() {
            try {
                if (this.ctx != null) {
                    this.ctx.close();
                }
                if (this.secHandle != null) {
                    this.secHandle.close();
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        public String getProviderURL() {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get("java.naming.provider.url");
        }

        public void setSecurityHandle(CDSSecurityHandle cDSSecurityHandle) {
            this.secHandle = cDSSecurityHandle;
        }

        private boolean hasRegistrationCredentials() {
            if (this.properties == null) {
                return false;
            }
            String string = (String)this.properties.get("java.naming.security.principal");
            return string != null;
        }

        public AbstractSubject getRightJNDISubject() {
            if (this.hasRegistrationCredentials()) {
                return this.getRegistrationSubject();
            }
            if (JMSDestinationAvailabilityHelper.this.isServer && this.secHandle.isRemoteDomain()) {
                return SubjectManager.getSubjectManager().getAnonymousSubject();
            }
            return this.origSubject;
        }

        public AbstractSubject getRightJMSSubject() {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Getting right jms subject: properties= " + this.properties);
            }
            AbstractSubject abstractSubject = this.getForeignSubject();
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("foreign subject= " + abstractSubject);
            }
            if (abstractSubject != null) {
                return abstractSubject;
            }
            if (this.hasRegistrationCredentials()) {
                if (!JMSDestinationAvailabilityHelper.this.isServer || !this.secHandle.isRemoteDomain() && !CrossDomainSecurityManager.getCrossDomainSecurityUtil().isKernelIdentity(this.registrationSubject)) {
                    return this.registrationSubject;
                }
                return SubjectManager.getSubjectManager().getAnonymousSubject();
            }
            return this.origSubject;
        }

        private AbstractSubject getForeignSubject() {
            if (JMSDebug.JMSCDS.isDebugEnabled()) {
                JMSDebug.JMSCDS.debug("Getting foreign subject isforeign= " + this.secHandle.isForeignJMSServer());
            }
            if (this.secHandle.isForeignJMSServer()) {
                return this.secHandle.getForeignSubject();
            }
            return null;
        }

        public Object lookup(final String string) throws NamingException {
            try {
                AbstractSubject abstractSubject = this.getRightJNDISubject();
                return CrossDomainSecurityManager.runAs(abstractSubject, new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        try {
                            return PropertiesContextFactory.this.ctx.lookup(string);
                        }
                        catch (NamingException namingException) {
                            if (namingException instanceof NameNotFoundException) {
                                throw namingException;
                            }
                            PropertiesContextFactory.this.refreshCtx();
                            return PropertiesContextFactory.this.ctx.lookup(string);
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof NamingException) {
                    throw (NamingException)exception;
                }
                NamingException namingException = new NamingException(exception.getMessage());
                throw namingException;
            }
        }
    }

    private final class DestinationAvailabilityListenerWrapper
    implements DDMembershipChangeListener,
    RegistrationHandle {
        private ContextFactory ctxFactory;
        private String destJNDIName;
        private DestinationAvailabilityListener listener;
        private int mode;
        InheritableThreadContext originalContext;

        public DestinationAvailabilityListenerWrapper(ContextFactory contextFactory, String string, DestinationAvailabilityListener destinationAvailabilityListener, int n) {
            this.ctxFactory = contextFactory;
            this.destJNDIName = string;
            this.listener = destinationAvailabilityListener;
            this.mode = n;
            this.originalContext = InheritableThreadContext.getContext();
        }

        public String getDDJNDIName() {
            return this.destJNDIName;
        }

        public DestinationAvailabilityListener getDestinationAvailabilityListener() {
            return this.listener;
        }

        public int getMode() {
            return this.mode;
        }

        public String getDestinationName() {
            return this.destJNDIName;
        }

        public String getProviderURL() {
            return this.ctxFactory.getProviderURL();
        }

        public InitialContext getInitialContext() throws NamingException {
            return (InitialContext)this.ctxFactory.getJNDIContext();
        }

        public AbstractSubject getSubject() {
            return this.ctxFactory.getRegistrationSubject();
        }

        public void onDDMembershipChange(DDMembershipChangeEventImpl dDMembershipChangeEventImpl) {
            DDMemberInformation[] dDMemberInformationArray;
            if (this.listener == null) {
                return;
            }
            DDMemberInformation[] dDMemberInformationArray2 = JMSDestinationAvailabilityHelper.this.filterDDMembers(this, dDMembershipChangeEventImpl.getRemovedDDMemberInformation());
            if (dDMemberInformationArray2 != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Valid Removed DDMembers info:");
                    JMSDestinationAvailabilityHelper.this.printDDMemberInfo(dDMemberInformationArray2);
                }
                int n = dDMemberInformationArray2.length;
                final DestinationDetail[] destinationDetailArray = new DestinationDetailImpl[n];
                for (int i = 0; i < n; ++i) {
                    destinationDetailArray[i] = JMSDestinationAvailabilityHelper.this.createDestinationDetailFromDDMemberInformation(dDMemberInformationArray2[i]);
                }
                this.callOutListener(new PrivilegedAction(){

                    public Object run() {
                        DestinationAvailabilityListenerWrapper.this.listener.onDestinationsUnavailable(DestinationAvailabilityListenerWrapper.this.destJNDIName, Arrays.asList(destinationDetailArray));
                        return null;
                    }
                });
            }
            if ((dDMemberInformationArray = JMSDestinationAvailabilityHelper.this.filterDDMembers(this, dDMembershipChangeEventImpl.getAddedDDMemberInformation())) != null) {
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Valid Added DDMembers info:");
                    JMSDestinationAvailabilityHelper.this.printDDMemberInfo(dDMemberInformationArray);
                }
                int n = dDMemberInformationArray.length;
                final DestinationDetail[] destinationDetailArray = new DestinationDetailImpl[n];
                for (int i = 0; i < n; ++i) {
                    destinationDetailArray[i] = JMSDestinationAvailabilityHelper.this.createDestinationDetailFromDDMemberInformation(dDMemberInformationArray[i]);
                }
                this.callOutListener(new PrivilegedAction(){

                    public Object run() {
                        DestinationAvailabilityListenerWrapper.this.listener.onDestinationsAvailable(DestinationAvailabilityListenerWrapper.this.destJNDIName, Arrays.asList(destinationDetailArray));
                        return null;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callOutListener(PrivilegedAction privilegedAction) {
            ClassLoader classLoader = this.originalContext.pushMultiThread();
            try {
                if (this.ctxFactory.isOrigSubDowngraded()) {
                    CrossDomainSecurityManager.runAs(this.ctxFactory.getOrigSubject(), privilegedAction);
                } else {
                    privilegedAction.run();
                }
                Object var4_3 = null;
                this.originalContext.popMultiThread(classLoader);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.originalContext.popMultiThread(classLoader);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            DestinationAvailabilityListenerWrapper destinationAvailabilityListenerWrapper = this;
            synchronized (destinationAvailabilityListenerWrapper) {
                if (this.listener == null) {
                    return;
                }
                CDS.getCDS().unregisterDDMembershipChangeListener(this);
                if (JMSDebug.JMSCDS.isDebugEnabled()) {
                    JMSDebug.JMSCDS.debug("Successfully unregistered the listener " + this.listener + " for destJNDIName=" + this.destJNDIName);
                }
                this.listener = null;
                this.ctxFactory.close();
            }
        }

        public void onFailure(final String string, final Exception exception) {
            if (this.listener == null) {
                return;
            }
            this.callOutListener(new PrivilegedAction(){

                public Object run() {
                    DestinationAvailabilityListenerWrapper.this.listener.onFailure(string, exception);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ConnectionFactory lookupConnectionFactory(String string) throws NamingException {
            ClassLoader classLoader = this.originalContext.pushMultiThread();
            try {
                ConnectionFactory connectionFactory = (ConnectionFactory)this.ctxFactory.lookup(string);
                Object var5_4 = null;
                this.originalContext.popMultiThread(classLoader);
                return connectionFactory;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.originalContext.popMultiThread(classLoader);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Destination lookupDestination(String string) throws NamingException {
            ClassLoader classLoader = this.originalContext.pushMultiThread();
            try {
                Destination destination = (Destination)this.ctxFactory.lookup(string);
                Object var5_4 = null;
                this.originalContext.popMultiThread(classLoader);
                return destination;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.originalContext.popMultiThread(classLoader);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object runAs(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
            ClassLoader classLoader = this.originalContext.pushMultiThread();
            try {
                Object object = CrossDomainSecurityManager.runAs(this.ctxFactory.getRightJMSSubject(), privilegedExceptionAction);
                Object var5_4 = null;
                this.originalContext.popMultiThread(classLoader);
                return object;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.originalContext.popMultiThread(classLoader);
                throw throwable;
            }
        }
    }
}

