/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessageFactory;
import weblogic.jms.extensions.XMLMessage;

public final class JMSMessageFactoryImpl
implements WLMessageFactory {
    private static WLMessageFactory messageFactory = null;

    public static final synchronized WLMessageFactory getFactory() {
        if (messageFactory == null) {
            messageFactory = new JMSMessageFactoryImpl();
        }
        return messageFactory;
    }

    JMSMessageFactoryImpl() {
    }

    public final Message createMessage() {
        return new HdrMessageImpl();
    }

    public final Message createMessage(Document document) throws DOMException, JMSException, IOException, ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName("weblogic.jms.common.XMLHelper");
            Method method = clazz.getMethod("createMessage", Document.class);
            return (Message)method.invoke(null, document);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof DOMException) {
                throw (DOMException)throwable;
            }
            if (throwable instanceof JMSException) {
                throw (JMSException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public final BytesMessage createBytesMessage() {
        return new BytesMessageImpl();
    }

    public final MapMessage createMapMessage() {
        return new MapMessageImpl();
    }

    public final ObjectMessage createObjectMessage() {
        return new ObjectMessageImpl();
    }

    public final ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setObject(serializable);
        return objectMessageImpl;
    }

    public final StreamMessage createStreamMessage() {
        return new StreamMessageImpl();
    }

    public final TextMessage createTextMessage() {
        return new TextMessageImpl();
    }

    public final TextMessage createTextMessage(String string) {
        return new TextMessageImpl(string);
    }

    public final TextMessage createTextMessage(StringBuffer stringBuffer) {
        return new TextMessageImpl(stringBuffer.toString());
    }

    public final XMLMessage createXMLMessage() {
        return new XMLMessageImpl();
    }

    public final XMLMessage createXMLMessage(String string) {
        return new XMLMessageImpl(string);
    }

    public final XMLMessage createXMLMessage(Document document) throws JMSException {
        return new XMLMessageImpl(document);
    }
}

