/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEConnectionSetClientIdRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -2181075251492512714L;
    private String clientId;
    private static final int EXTVERSION_PRE_1033 = 1;
    private static final int EXTVERSION_1033 = 2;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    public static final int CONTINUE = 1;
    private int clientIdPolicy = 0;
    private transient Object myFocascia;

    public FEConnectionSetClientIdRequest(JMSID jMSID, String string, int n) {
        super(jMSID, 1799);
        this.clientId = string;
        this.clientIdPolicy = n;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public void setFocascia(Object object) {
        this.myFocascia = object;
    }

    public Object getFocascia() {
        return this.myFocascia;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FEConnectionSetClientIdRequest() {
    }

    private byte getVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()).compareTo(PeerInfo.VERSION_1033) < 0) {
            return 1;
        }
        return 2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        byte by = this.getVersion(objectOutput);
        objectOutput.writeInt(by);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.clientId);
        if (by >= 2) {
            objectOutput.writeInt(this.clientIdPolicy);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && n2 != 2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        super.readExternal(objectInput);
        this.clientId = objectInput.readUTF();
        if (n2 >= 2) {
            this.clientIdPolicy = objectInput.readInt();
        }
    }
}

