/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEConsumerCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -1696547268688497887L;
    private long lastSequenceNumber;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int SEQUENCE_NUMBER_MASK = 256;

    public FEConsumerCloseRequest(JMSID jMSID, long l) {
        super(jMSID, 2570);
        this.lastSequenceNumber = l;
    }

    public long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FEConsumerCloseRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        if (this.lastSequenceNumber != 0L) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.lastSequenceNumber != 0L) {
            objectOutput.writeLong(this.lastSequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x100) != 0) {
            this.lastSequenceNumber = objectInput.readLong();
        }
    }
}

