/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.Response;

public final class FEConsumerReceiveRequest
extends Request
implements Externalizable,
CompletionListener {
    static final long serialVersionUID = 8859525699995436679L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TIMEOUT_MASK = 3840;
    private static final int TIMEOUT_NEVER = 256;
    private static final int TIMEOUT_NO_WAIT = 512;
    static final int START = 0;
    static final int CONTINUE = 1;
    private long timeout;
    private transient CompletionListener appListener;
    private transient ConsumerInternal consumerInternal;

    public FEConsumerReceiveRequest(JMSID jMSID, long l, CompletionListener completionListener, ConsumerInternal consumerInternal) {
        super(jMSID, 3338);
        this.timeout = l;
        if (completionListener != null) {
            this.consumerInternal = consumerInternal;
            this.appListener = completionListener;
            this.setListener(this);
        }
    }

    long getTimeout() {
        return this.timeout;
    }

    public int remoteSignature() {
        return 19;
    }

    public Response createResponse() {
        return new JMSConsumerReceiveResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Object object) {
        CompletionListener completionListener;
        FEConsumerReceiveRequest fEConsumerReceiveRequest = this;
        synchronized (fEConsumerReceiveRequest) {
            if (this.appListener == null) {
                return;
            }
            completionListener = this.appListener;
            this.appListener = null;
        }
        try {
            this.consumerInternal.getSession().proccessReceiveResponse(this.consumerInternal, object, completionListener);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        CompletionListener completionListener;
        FEConsumerReceiveRequest fEConsumerReceiveRequest = this;
        synchronized (fEConsumerReceiveRequest) {
            if (this.appListener == null) {
                return;
            }
            completionListener = this.appListener;
            this.appListener = null;
        }
        completionListener.onException(throwable);
    }

    public FEConsumerReceiveRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        if (this.timeout == Long.MAX_VALUE) {
            n |= 0x100;
        } else if (this.timeout == 0x7FFFFFFFFFFFFFFEL) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if ((n & 0xF00) == 0) {
            objectOutput.writeLong(this.timeout);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.timeout = (n & 0xF00) == 256 ? Long.MAX_VALUE : ((n & 0xF00) == 512 ? 0x7FFFFFFFFFFFFFFEL : objectInput.readLong());
    }
}

