/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.jms.Message;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.CompletionListener;
import weblogic.messaging.dispatcher.Response;

public final class FEProducerSendRequest
extends Request
implements CompletionListener,
Externalizable {
    static final long serialVersionUID = -6258361113844425358L;
    private static final int EXTVERSION61 = 1;
    private static final int EXTVERSION81 = 2;
    private static final int EXTVERSION902 = 4;
    private static final int EXTVERSION = 4;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_MASK = 65280;
    private static final int DESTINATION_MASK = 983040;
    private static final int TIMEOUT_MASK = 0x100000;
    private static final int NORESPONSE_MASK = 0x200000;
    public static final int CHECK_UNIT_OF_ORDER = 0x200000;
    private static final int MESSAGE_MASK_SHIFT = 8;
    private static final int DESTINATION_MASK_SHIFT = 16;
    static final int START = 0;
    static final int CONTINUE = 1;
    static final int TRY = 2;
    static final int RETRY = 3;
    static final int AFTER_START_IP = 4;
    static final int AFTER_POST_AUTH_IP = 5;
    static final int RETURN_FROM_START_IP = 6;
    static final int RETURN_FROM_POST_AUTH_IP = 7;
    static final int RELEASE_FANOUT = 8;
    private transient boolean infected;
    private MessageImpl message;
    private DestinationImpl destination;
    private long sendTimeout;
    private transient JMSDispatcher dispatcher;
    private transient Object failover;
    private transient int checkUnitOfOrder;
    private transient String pathServiceJndi;
    private transient Serializable uooKey;
    private transient boolean uooNoFailover;
    private transient int numberOfRetries;
    private transient FEProducerSendRequest[] subRequest;
    private transient String unitForRouting;
    private transient int dataLen;
    private transient Request backendRequest;
    private transient boolean noResponse = false;
    private int compressionThreshold = Integer.MAX_VALUE;
    private transient Object authenticatedSubject;
    private transient Message messageState;
    private transient int deliveryModeState;
    private transient long timeToDeliverState;
    private transient int priorityState;
    private transient long timeToLiveState;
    private transient boolean forwardingState;
    private transient CompletionListener appListener;
    private transient JMSProducer jmsProducer;
    private boolean pushPopSubject = false;

    public FEProducerSendRequest(JMSID jMSID, MessageImpl messageImpl, DestinationImpl destinationImpl, long l, int n, CompletionListener completionListener, JMSProducer jMSProducer, Message message, int n2, long l2, int n3, long l3, boolean bl) {
        this(jMSID, messageImpl, destinationImpl, l, n);
        if (completionListener != null) {
            this.appListener = completionListener;
            this.jmsProducer = jMSProducer;
            this.messageState = message;
            this.deliveryModeState = n2;
            this.timeToDeliverState = l2;
            this.priorityState = n3;
            this.timeToLiveState = l3;
            this.forwardingState = bl;
            this.setListener(this);
        }
    }

    public FEProducerSendRequest(JMSID jMSID, MessageImpl messageImpl, DestinationImpl destinationImpl, long l, int n) {
        super(jMSID, 5129);
        this.message = messageImpl;
        this.destination = destinationImpl;
        this.sendTimeout = l;
        this.compressionThreshold = n;
    }

    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void rememberOneWayState() {
    }

    public void setNoResponse(boolean bl) {
        this.noResponse = bl;
    }

    public boolean isNoResponse() {
        return this.noResponse;
    }

    public MessageImpl getMessage() {
        return this.message;
    }

    DestinationImpl getDestination() {
        return this.destination;
    }

    void setDestination(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    JMSDispatcher getDispatcher() {
        return this.dispatcher;
    }

    void setDispatcher(JMSDispatcher jMSDispatcher) {
        this.dispatcher = jMSDispatcher;
    }

    void setFailover(Object object) {
        this.failover = object;
    }

    Object getFailover() {
        return this.failover;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    void setInfected(boolean bl) {
        this.infected = bl;
    }

    boolean isInfected() {
        return this.infected;
    }

    void setUooNoFailover(boolean bl) {
        this.uooNoFailover = bl;
    }

    boolean getUOONoFailover() {
        return this.uooNoFailover;
    }

    void setUnitForRouting(String string) {
        this.unitForRouting = string;
    }

    String getUnitForRouting() {
        return this.unitForRouting;
    }

    public void setCheckUOO(int n) {
        this.checkUnitOfOrder = n;
    }

    int getCheckUOO() {
        return this.checkUnitOfOrder;
    }

    int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(int n) {
        this.numberOfRetries = n;
    }

    FEProducerSendRequest[] getSubRequest() {
        return this.subRequest;
    }

    void setSubRequest(FEProducerSendRequest[] fEProducerSendRequestArray) {
        this.subRequest = fEProducerSendRequestArray;
    }

    public Request getBackendRequest() {
        return this.backendRequest;
    }

    public void setBackendRequest(Request request) {
        this.backendRequest = request;
    }

    public void setUOOInfo(String string, Serializable serializable) {
        this.pathServiceJndi = string;
        this.uooKey = serializable;
    }

    public String getPathServiceJndi() {
        return this.pathServiceJndi;
    }

    public Object getUOOKey() {
        return this.uooKey;
    }

    public int remoteSignature() {
        if (this.noResponse) {
            return 64;
        }
        return 19;
    }

    public Response createResponse() {
        return new JMSProducerSendResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Object object) {
        CompletionListener completionListener;
        FEProducerSendRequest fEProducerSendRequest = this;
        synchronized (fEProducerSendRequest) {
            if (this.appListener == null) {
                return;
            }
            completionListener = this.appListener;
            this.appListener = null;
        }
        try {
            this.jmsProducer.completeAsyncSend(object, this, this.destination, this.messageState, this.message, this.deliveryModeState, this.timeToDeliverState, this.priorityState, this.timeToLiveState, this.forwardingState, completionListener);
        }
        catch (Throwable throwable) {
            completionListener.onException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Throwable throwable) {
        CompletionListener completionListener;
        FEProducerSendRequest fEProducerSendRequest = this;
        synchronized (fEProducerSendRequest) {
            if (this.appListener == null) {
                return;
            }
            completionListener = this.appListener;
            this.appListener = null;
        }
        completionListener.onException(throwable);
    }

    public FEProducerSendRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 0;
        PeerInfo peerInfo = ((PeerInfoable)((Object)(objectOutput = this.getVersionedStream(objectOutput)))).getPeerInfo();
        if (peerInfo.compareTo(PeerInfo.VERSION_61) < 0) {
            throw JMSUtilities.versionIOException(0, 1, 2);
        }
        int n2 = peerInfo.compareTo(PeerInfo.VERSION_81) < 0 ? 1 : (peerInfo.compareTo(PeerInfo.VERSION_901) < 0 ? 2 : 4);
        int n3 = n2 | this.message.getType() << 8;
        n3 |= Destination.getDestinationType(this.destination, 16);
        if (n2 >= 2 && this.sendTimeout != 10L) {
            n3 |= 0x100000;
        }
        if (n2 >= 4 && this.noResponse) {
            n3 |= 0x200000;
        }
        objectOutput.writeInt(n3);
        super.writeExternal(objectOutput);
        if (this.noResponse) {
            n = MessageImpl.getPosition(objectOutput);
        }
        this.message.writeExternal(MessageImpl.createJMSObjectOutputWrapper(objectOutput, this.compressionThreshold, false));
        if (this.noResponse) {
            this.dataLen = MessageImpl.getPosition(objectOutput) - n;
        }
        if (this.destination != null) {
            this.destination.writeExternal(objectOutput);
        }
        if ((n3 & 0x100000) != 0) {
            objectOutput.writeLong(this.sendTimeout);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || n2 > 4) {
            throw JMSUtilities.versionIOException(n2, 1, 4);
        }
        super.readExternal(objectInput);
        int n3 = (n & 0xFF00) >>> 8;
        this.message = MessageImpl.createMessageImpl((byte)n3);
        this.message.readExternal(objectInput);
        int n4 = (n & 0xF0000) >>> 16;
        this.destination = Destination.createDestination((byte)n4, objectInput);
        if ((n & 0x100000) != 0) {
            this.sendTimeout = objectInput.readLong();
        }
        this.noResponse = (n & 0x200000) != 0;
    }

    void setUpPushPopSubject(boolean bl) {
        this.pushPopSubject = bl;
    }

    boolean getPushPopSubject() {
        return this.pushPopSubject;
    }

    void setAuthenticatedSubject(Object object) {
        this.authenticatedSubject = object;
    }

    Object getAuthenticatedSubject() {
        return this.authenticatedSubject;
    }
}

