/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FESessionAcknowledgeRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -569536026964306235L;
    private long lastSequenceNumber;
    private int acknowledgePolicy;
    private boolean doCommit;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int ACKNOWLEDGE_POLICY_MASK = 65280;
    private static final int COMMIT_MASK = 65536;
    private static final int SEQUENCE_NUMBER_MASK = 131072;
    private static final int ACKNOWLEDGE_POLICY_SHIFT = 8;
    static final int COMMIT_START = 0;
    static final int ACK_START = 1;
    static final int ACK_FINISH = 2;
    static final int COMMIT_FINISH = 3;

    public FESessionAcknowledgeRequest(JMSID jMSID, long l, int n, boolean bl) {
        super(jMSID, 6152);
        this.lastSequenceNumber = l;
        this.acknowledgePolicy = n;
        this.doCommit = bl;
    }

    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    boolean doCommit() {
        return this.doCommit;
    }

    public int remoteSignature() {
        return this.doCommit ? 18 : 19;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FESessionAcknowledgeRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1 | this.acknowledgePolicy << 8;
        if (this.doCommit) {
            n |= 0x10000;
        }
        if (this.lastSequenceNumber != 0L) {
            n |= 0x20000;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        if (this.lastSequenceNumber != 0L) {
            objectOutput.writeLong(this.lastSequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        if ((n & 0x20000) != 0) {
            this.lastSequenceNumber = objectInput.readLong();
        }
        this.acknowledgePolicy = (n & 0xFF00) >>> 8;
        this.doCommit = (n & 0x10000) != 0;
    }
}

