/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.BufferDataOutputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectIOBypass;
import weblogic.jms.extensions.SequenceGapException;
import weblogic.jms.multicast.JMSFragmentStash;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTMObjectIOBypassImpl;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;

public class JMSTMSocket
implements Runnable {
    private static final int MAX_FRAGMENT_SIZE = 10240;
    private static final int PAYLOAD_FUDGE_FACTOR = 232;
    private static final int MESSAGE_VERSION = 1;
    private static final int FRAGMENT_VERSION = 1;
    private static final int VERSION_MASK = 4095;
    private static final int FRAGMENT_MAGIC = 199886103;
    protected static final int INITIAL_SEQNO = 0;
    private JMSTDMSocket sock;
    private final Object wantLock = new Object();
    private int wantLockCount = 0;
    private final JMSSession session;
    protected boolean closed;
    private final JMSTMObjectIOBypassImpl objectIOBypassImpl = new JMSTMObjectIOBypassImpl();
    private final byte[] bdosMsgBuffer = new byte[10240];
    private final byte[] bdosFragBuffer = new byte[10240];
    private final byte[] bdisFragBuffer = new byte[10240];
    private final BufferOutputStream bdosMsg = new BufferDataOutputStream((ObjectIOBypass)this.objectIOBypassImpl, this.bdosMsgBuffer);
    private final BufferOutputStream bdosFrag = new BufferDataOutputStream(null, this.bdosFragBuffer);
    private final BufferDataInputStream bdisFrag = new BufferDataInputStream(null, this.bdisFragBuffer);
    private HashMap stashes;
    private final int receivePort;
    private final HashMap groups;
    private final HashMap destinations;
    private final HashMap dests;
    private long fragmentDelay;
    private long lastDelay;
    private long lastSendTime;
    private static final String PROTOCOL = "WeblogicMulticast";

    public JMSTMSocket(JMSSession jMSSession, JMSTDMSocket jMSTDMSocket, int n, int n2) throws IOException {
        this.session = jMSSession;
        this.sock = jMSTDMSocket;
        this.receivePort = n2;
        this.fragmentDelay = n;
        this.lastDelay = 0L;
        this.lastSendTime = 0L;
        this.closed = false;
        this.groups = new HashMap();
        this.destinations = new HashMap();
        this.dests = new HashMap();
        this.stashes = new HashMap();
        this.bdosMsg.setIsJMSMulticastOutputStream();
        this.bdosFrag.setIsJMSMulticastOutputStream();
    }

    public final void setFragmentDelay(long l) {
        this.fragmentDelay = l;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            if (!this.closed) {
                this.closed = true;
                this.sock = null;
                this.stashes = null;
            }
        }
        this.decWantLockCount();
    }

    public final void send(MessageImpl messageImpl, DestinationImpl destinationImpl, JMSID jMSID, InetAddress inetAddress, int n, byte by, long l) throws IOException {
        String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
        if (this.closed) {
            throw new IOException("Attempt to send message on multicast socket that is closed");
        }
        this.bdosMsg.reset();
        this.bdosMsg.writeShort(1);
        this.bdosMsg.writeByte(messageImpl.getType());
        messageImpl.writeExternal(this.bdosMsg.getObjectOutput());
        jMSID.writeExternal(this.bdosMsg.getObjectOutput());
        this.bdosMsg.flush();
        int n2 = this.bdosMsg.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.bdosFrag.reset();
            this.bdosFrag.writeInt(199886103);
            this.bdosFrag.writeShort(1);
            this.bdosFrag.writeUTF(string);
            this.bdosFrag.writeLong(l);
            this.bdosFrag.writeInt(n2);
            this.bdosFrag.writeInt(n4);
            this.bdosFrag.writeInt(n3);
            this.bdosFrag.flush();
            int n5 = Math.min(10008 - this.bdosFrag.size(), n2 - n3);
            this.bdosFrag.writeInt(n5);
            if (n5 > 0) {
                this.bdosFrag.write(this.bdosMsgBuffer, n3, n5);
            }
            this.bdosFrag.flush();
            this.sendThrottled(this.bdosFragBuffer, this.bdosFrag.size(), inetAddress, n, by);
            n3 += n5;
            ++n4;
        }
    }

    private void sendThrottled(byte[] byArray, int n, InetAddress inetAddress, int n2, byte by) throws IOException {
        long l = System.currentTimeMillis();
        this.lastDelay = Math.max(this.lastDelay - Math.max(l - this.lastSendTime, 0L) + this.fragmentDelay, 0L);
        this.lastSendTime = l;
        if (this.lastDelay > 0L) {
            try {
                Thread.sleep(this.lastDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sock.send(byArray, n, inetAddress, n2, by);
    }

    public final String getProtocol() {
        return PROTOCOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            MessageImpl messageImpl;
            if (this.getWantLockCount() != 0) {
                Thread.yield();
            }
            Runnable runnable = this;
            synchronized (runnable) {
                if (this.sock == null) {
                    break;
                }
                try {
                    messageImpl = this.receive();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (messageImpl == null) {
                    continue;
                }
            }
            runnable = this.session;
            synchronized (runnable) {
                JMSTMSocket jMSTMSocket = this;
                synchronized (jMSTMSocket) {
                    JMSID jMSID = messageImpl.getConnectionId();
                    messageImpl.setConnectionId(null);
                    DestinationImpl destinationImpl = (DestinationImpl)messageImpl.getJMSDestination();
                    String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                    JMSPushRequest jMSPushRequest = new JMSPushRequest(0, null, messageImpl);
                    ArrayList arrayList = (ArrayList)this.destinations.get(string);
                    if (arrayList == null) {
                        continue;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ConsumerInternal consumerInternal;
                        block21: {
                            consumerInternal = (ConsumerInternal)arrayList.get(i);
                            if (consumerInternal.privateGetNoLocal() && this.session.getConnection().getJMSID().equals(jMSID)) continue;
                            try {
                                if (consumerInternal.getExpressionEvaluator() != null && !consumerInternal.getExpressionEvaluator().evaluate(messageImpl)) {
                                }
                                break block21;
                            }
                            catch (ExpressionEvaluationException expressionEvaluationException) {
                            }
                            catch (ClassCastException classCastException) {}
                            continue;
                        }
                        JMSID jMSID2 = consumerInternal.getJMSID();
                        if (jMSID2 == null) continue;
                        JMSPushEntry jMSPushEntry = new JMSPushEntry(null, jMSID2, Long.MAX_VALUE, Long.MAX_VALUE, 1, 0);
                        jMSPushRequest.addPushEntry(jMSPushEntry);
                    }
                    this.session.pushMessage(jMSPushRequest, false);
                }
            }
        }
    }

    private MessageImpl receive() throws Exception {
        block16: {
            try {
                Chunk chunk;
                if (this.closed) {
                    return null;
                }
                if (this.sock.receive(this.bdisFragBuffer) == 0) {
                    return null;
                }
                this.bdisFrag.reset();
                if (this.bdisFrag.readInt() != 199886103) {
                    return null;
                }
                if ((this.bdisFrag.readShort() & 0xFFF) != 1) {
                    return null;
                }
                String string = this.bdisFrag.readUTF();
                DestinationImpl destinationImpl = (DestinationImpl)this.dests.get(string);
                if (destinationImpl == null) {
                    return null;
                }
                long l = this.bdisFrag.readLong();
                int n = this.bdisFrag.readInt();
                int n2 = this.bdisFrag.readInt();
                int n3 = this.bdisFrag.readInt();
                int n4 = this.bdisFrag.readInt();
                JMSFragmentStash jMSFragmentStash = (JMSFragmentStash)this.stashes.get(string);
                if (jMSFragmentStash == null) {
                    jMSFragmentStash = new JMSFragmentStash(this.session, l, destinationImpl);
                    this.stashes.put(string, jMSFragmentStash);
                }
                if ((chunk = jMSFragmentStash.processFragment(l, n, n2, n3, this.bdisFrag, n4)) != null) {
                    BufferInputStreamChunked bufferInputStreamChunked = new BufferInputStreamChunked(this.objectIOBypassImpl, new ChunkedDataInputStream(chunk, 0));
                    if ((bufferInputStreamChunked.readShort() & 0xFFF) != 1) {
                        return null;
                    }
                    MessageImpl messageImpl = MessageImpl.createMessageImpl(bufferInputStreamChunked.readByte());
                    messageImpl.readExternal(bufferInputStreamChunked);
                    JMSID jMSID = new JMSID();
                    jMSID.readExternal(bufferInputStreamChunked);
                    messageImpl.setJMSDestinationImpl(destinationImpl);
                    messageImpl.setConnectionId(jMSID);
                    return messageImpl;
                }
            }
            catch (IOException iOException) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("IOException", iOException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("ClassNotFoundException", classNotFoundException);
                }
            }
            catch (SequenceGapException sequenceGapException) {
                this.session.onException(sequenceGapException);
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("SequenceGapException", sequenceGapException);
                }
            }
            catch (Throwable throwable) {
                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block16;
                JMSDebug.JMSFrontEnd.debug("Throwable", throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void joinGroup(DestinationImpl destinationImpl, ConsumerInternal consumerInternal) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                InetAddress inetAddress;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                if (destinationImpl.getPort() != this.receivePort) {
                    throw new IOException("Wrong port");
                }
                String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                try {
                    inetAddress = InetAddress.getByName(destinationImpl.getMulticastAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException("Cannot parse multicast address " + destinationImpl.getMulticastAddress());
                }
                ArrayList<ConsumerInternal> arrayList = (ArrayList<ConsumerInternal>)this.groups.get(inetAddress);
                if (arrayList != null) {
                    if (arrayList.indexOf(consumerInternal) < 0) {
                        arrayList.add(consumerInternal);
                        ArrayList<ConsumerInternal> arrayList2 = (ArrayList<ConsumerInternal>)this.destinations.get(string);
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<ConsumerInternal>();
                            this.destinations.put(string, arrayList2);
                            this.dests.put(string, destinationImpl);
                        }
                        arrayList2.add(consumerInternal);
                    }
                } else {
                    this.sock.joinGroup(inetAddress);
                    arrayList = new ArrayList<ConsumerInternal>();
                    arrayList.add(consumerInternal);
                    this.groups.put(inetAddress, arrayList);
                    ArrayList<ConsumerInternal> arrayList3 = new ArrayList<ConsumerInternal>();
                    this.destinations.put(string, arrayList3);
                    this.dests.put(string, destinationImpl);
                    arrayList3.add(consumerInternal);
                }
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void leaveGroup(DestinationImpl destinationImpl, ConsumerInternal consumerInternal) throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                int n;
                InetAddress inetAddress;
                if (this.sock == null) {
                    throw new IOException("socket closed");
                }
                try {
                    inetAddress = InetAddress.getByName(destinationImpl.getMulticastAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException("Cannot parse multicast address " + destinationImpl.getMulticastAddress());
                }
                ArrayList arrayList = (ArrayList)this.groups.get(inetAddress);
                if (arrayList == null || (n = arrayList.indexOf(consumerInternal)) < 0) {
                    throw new IOException("Cannot find group info about consumer");
                }
                arrayList.remove(n);
                String string = destinationImpl.getServerName() + "/" + destinationImpl.getName();
                ArrayList arrayList2 = (ArrayList)this.destinations.get(string);
                if (arrayList2 == null || (n = arrayList2.indexOf(consumerInternal)) < 0) {
                    throw new IOException("can not find destination info about consumer");
                }
                arrayList2.remove(n);
                if (arrayList2.size() == 0) {
                    this.destinations.remove(string);
                    this.dests.remove(string);
                    this.stashes.remove(string);
                }
                if (arrayList.size() == 0) {
                    this.groups.remove(inetAddress);
                    this.sock.leaveGroup(inetAddress);
                }
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                for (InetAddress inetAddress : this.groups.keySet()) {
                    this.sock.joinGroup(inetAddress);
                }
                this.stashes = new HashMap();
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws IOException {
        this.incWantLockCount();
        JMSTMSocket jMSTMSocket = this;
        synchronized (jMSTMSocket) {
            try {
                if (this.sock == null) {
                    throw new IOException("socket is closed");
                }
                for (InetAddress inetAddress : this.groups.keySet()) {
                    this.sock.leaveGroup(inetAddress);
                }
                this.stashes = null;
            }
            catch (Throwable throwable) {
                this.decWantLockCount();
                throw new IOException(throwable.toString());
            }
        }
        this.decWantLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            ++this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            --this.wantLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWantLockCount() {
        Object object = this.wantLock;
        synchronized (object) {
            return this.wantLockCount;
        }
    }
}

